/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.anf.cryptotoken.sign.verifier.sources.tsl.model.DateDeserializer;
import com.anf.oauth.json.JSONFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import eu.europa.esig.dss.model.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.tsl.dto.DownloadCacheDTO;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TLinfoJson {
    private String id;
    private ParsingCacheDTO parsingInfoRecord;
    private DownloadCacheDTO downloadInfoRecord;
    private ValidationCacheDTO validationInfoRecord;
    private String url;

    public TLinfoJson(TLInfo info) {
        this.downloadInfoRecord = TLinfoJson.downloadInfo(info);
        this.parsingInfoRecord = TLinfoJson.parsingInfo(info);
        this.validationInfoRecord = TLinfoJson.validationInfo(info);
        this.url = info.getUrl();
        this.id = info.getDSSId().asXmlId();
    }

    private static ParsingCacheDTO parsingInfo(TLInfo info) {
        ParsingCacheDTO original = (ParsingCacheDTO)info.getParsingCacheInfo();
        ParsingCacheDTO copy = new ParsingCacheDTO();
        copy.setCacheState(original.getCacheState());
        copy.setDistributionPoints(original.getDistributionPoints());
        copy.setExceptionFirstOccurrenceTime(original.getExceptionFirstOccurrenceTime());
        copy.setExceptionLastOccurrenceTime(original.getExceptionLastOccurrenceTime());
        copy.setExceptionMessage(original.getExceptionMessage());
        copy.setExceptionStackTrace(original.getExceptionStackTrace());
        copy.setIssueDate(original.getIssueDate());
        copy.setLastStateTransitionTime(original.getLastStateTransitionTime());
        copy.setLastSuccessSynchronizationTime(original.getLastSuccessSynchronizationTime());
        List lotlOtherPointers = original.getLotlOtherPointers();
        if (lotlOtherPointers != null) {
            ArrayList<OtherTSLPointer> lotlOtherPointersCopy = new ArrayList<OtherTSLPointer>();
            for (OtherTSLPointer otherTSLPointer : lotlOtherPointers) {
                lotlOtherPointersCopy.add(TLinfoJson.copy(otherTSLPointer));
            }
            copy.setLotlOtherPointers(lotlOtherPointersCopy);
        }
        copy.setNextUpdateDate(original.getNextUpdateDate());
        copy.setPivotUrls(original.getPivotUrls());
        copy.setResultExist(original.isResultExist());
        copy.setSequenceNumber(original.getSequenceNumber());
        copy.setSigningCertificateAnnouncementUrl(original.getSigningCertificateAnnouncementUrl());
        copy.setTerritory(original.getTerritory());
        List tlOtherPointers = original.getTlOtherPointers();
        if (tlOtherPointers != null) {
            ArrayList<OtherTSLPointer> tlOtherPointersCopy = new ArrayList<OtherTSLPointer>();
            for (OtherTSLPointer otherTSLPointer : tlOtherPointers) {
                tlOtherPointersCopy.add(TLinfoJson.copy(otherTSLPointer));
            }
            copy.setTlOtherPointers(tlOtherPointersCopy);
        }
        copy.setTrustServiceProviders(null);
        copy.setVersion(original.getVersion());
        return copy;
    }

    private static OtherTSLPointer copy(OtherTSLPointer otherTSLPointer) {
        return new OtherTSLPointer(new OtherTSLPointer.OtherTSLPointerBuilder().setMimeType(otherTSLPointer.getMimeType()).setMra(otherTSLPointer.getMra()).setSchemeOperatorNames(otherTSLPointer.getSchemeOperatorNames()).setSchemeTerritory(otherTSLPointer.getSchemeTerritory()).setSchemeTypeCommunityRules(otherTSLPointer.getSchemeTypeCommunityRules()).setTslLocation(otherTSLPointer.getTSLLocation()).setTslType(otherTSLPointer.getTslType()));
    }

    private static DownloadCacheDTO downloadInfo(TLInfo info) {
        DownloadCacheDTO downloadCacheInfo = (DownloadCacheDTO)info.getDownloadCacheInfo();
        downloadCacheInfo.setDocument(null);
        return downloadCacheInfo;
    }

    private static ValidationCacheDTO validationInfo(TLInfo info) {
        ValidationCacheDTO original = (ValidationCacheDTO)info.getValidationCacheInfo();
        ValidationCacheDTO copy = new ValidationCacheDTO();
        copy.setCacheState(original.getCacheState());
        copy.setExceptionFirstOccurrenceTime(original.getExceptionFirstOccurrenceTime());
        copy.setExceptionLastOccurrenceTime(original.getExceptionLastOccurrenceTime());
        copy.setExceptionMessage(original.getExceptionMessage());
        copy.setExceptionStackTrace(original.getExceptionStackTrace());
        copy.setLastStateTransitionTime(original.getLastStateTransitionTime());
        copy.setLastSuccessSynchronizationTime(original.getLastSuccessSynchronizationTime());
        copy.setResultExist(original.isResultExist());
        copy.setIndication(original.getIndication());
        copy.setResultExist(original.isResultExist());
        copy.setSigningTime(original.getSigningTime());
        copy.setSubIndication(original.getSubIndication());
        copy.setSigningCertificate(null);
        copy.setPotentialSigners(null);
        return copy;
    }

    public String getId() {
        return this.id;
    }

    public String toJson() throws JsonProcessingException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        JSONFactory.getMapper().setDateFormat((DateFormat)dateFormat);
        JSONFactory.getMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return JSONFactory.getMapper().writer().with((DateFormat)dateFormat).writeValueAsString((Object)this);
    }

    public static TLinfoJson fromJson(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer("yyyy-MM-dd HH:mm:ssZ"));
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return X509Certificate.class.equals((Object)f.getDeclaredClass());
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return X509Certificate.class.equals(clazz);
            }
        }});
        return (TLinfoJson)gsonBuilder.create().fromJson(json, TLinfoJson.class);
    }

    public TLInfo toObject() {
        return new TLInfo((DownloadInfoRecord)this.downloadInfoRecord, (ParsingInfoRecord)this.parsingInfoRecord, (ValidationInfoRecord)this.validationInfoRecord, this.url);
    }
}

