/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.anf.cryptotoken.sign.verifier.sources.tsl.model.DateDeserializer;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.TLinfoJson;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LOTLInfoJson
extends TLinfoJson {
    private List<TLinfoJson> tlInfos;

    public LOTLInfoJson(LOTLInfo info) {
        super((TLInfo)info);
        if (info.getTLInfos() != null) {
            this.tlInfos = new ArrayList<TLinfoJson>(info.getTLInfos().size());
            for (TLInfo tlInfo : info.getTLInfos()) {
                this.tlInfos.add(new TLinfoJson(tlInfo));
            }
        }
        info.getTLInfos();
    }

    public LOTLInfo toObject() {
        TLInfo tlInfo = super.toObject();
        LOTLInfo info = new LOTLInfo(tlInfo.getDownloadCacheInfo(), tlInfo.getParsingCacheInfo(), tlInfo.getValidationCacheInfo(), tlInfo.getUrl());
        if (this.tlInfos != null) {
            info.setTlInfos(this.tlInfos.stream().map(TLinfoJson::toObject).toList());
        }
        return info;
    }

    public static LOTLInfoJson fromJson(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer("yyyy-MM-dd HH:mm:ssZ"));
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return X509Certificate.class.equals((Object)f.getDeclaredClass());
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return X509Certificate.class.equals(clazz);
            }
        }});
        return (LOTLInfoJson)gsonBuilder.create().fromJson(json, LOTLInfoJson.class);
    }
}

