/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateDeserializer
implements JsonDeserializer<Date> {
    private static final Logger log = LogManager.getLogger(DateDeserializer.class);
    private String format;
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.S z", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH-mm-ss", "yyyy:MM:dd HH:mm:ss", "yyyy-MM-dd", "yyyy:MM:dd", "dd-MM-yyyy HH:mm:ss"};

    public DateDeserializer(String format) {
        this.format = format;
    }

    public Date deserialize(JsonElement element, Type arg1, JsonDeserializationContext ctxt) throws JsonParseException {
        String date = element.getAsString();
        if (date != null && date.isBlank()) {
            return null;
        }
        try {
            return new SimpleDateFormat(this.format).parse(date);
        }
        catch (Exception e) {
            log.debug("no se pudo parsear la fecha {} con el formato por defecto: {}. el error es: {}", (Object)date, (Object)this.format, (Object)e.getMessage());
            for (String DATE_FORMAT : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(DATE_FORMAT).parse(date);
                }
                catch (Exception e2) {
                    log.debug("no se pudo parsear la fecha {} con el formato: {}. el error es: {}", (Object)date, (Object)DATE_FORMAT, (Object)e2.getMessage());
                }
            }
            throw new RuntimeException("Unparseable date: \"" + date + "\". Supported formats: " + Arrays.toString(DATE_FORMATS));
        }
    }
}

