/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl;

import com.anf.cryptotoken.sign.verifier.sources.ANFTrustedCertificateSource;
import com.anf.cryptotoken.sign.verifier.sources.tsl.TLValidationSummaryService;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.GetCertificateBy;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.GetCertificateByResp;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.TrustPropertiesListJson;
import com.anf.oauth.json.JSONFactory;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class ANFTSLServiceCertificateSource
extends TrustedListsCertificateSource {
    private static final Logger log = LogManager.getLogger(ANFTSLServiceCertificateSource.class);
    private static final long serialVersionUID = 1L;
    private String url = "http://localhost:8091";
    private transient HttpClient client;
    private transient RequestConfig requestConfig;
    private static final int DEFAULT_TIMEOUT = 3000;
    private ANFTrustedCertificateSource trustedCertificateSource = new ANFTrustedCertificateSource();
    private CommonCertificateSource source = new CommonCertificateSource();
    private TLValidationSummaryService summary;
    private Map<EntityIdentifier, List<TrustProperties>> trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();
    private Map<EntityIdentifier, Boolean> knownFlagMap = new HashMap<EntityIdentifier, Boolean>();
    private long lastUpdate = System.currentTimeMillis();
    private long updateInterval = TimeUnit.HOURS.toMillis(1L);
    private transient CertificateFactory certificateFactory;
    private boolean trustedFinalCert = false;
    private Map<String, Set<CertificateToken>> tokensCache = new TreeMap<String, Set<CertificateToken>>();

    public ANFTSLServiceCertificateSource() {
        this(3000);
    }

    public ANFTSLServiceCertificateSource(int timeout) {
        this(ANFTSLServiceCertificateSource.findServiceUrl(), timeout);
    }

    private static String findServiceUrl() {
        String url = System.getenv("tsl.service.url");
        if (url == null) {
            url = System.getProperty("tsl.service.url", "https://validaciones.anf.es");
        }
        return url;
    }

    public ANFTSLServiceCertificateSource(String url, int timeout) {
        this.url = url;
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
            DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy).build();
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeout)).setResponseTimeout(Timeout.ofMilliseconds((long)timeout)).build();
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)timeout, TimeUnit.MILLISECONDS).setSocketTimeout(timeout, TimeUnit.MILLISECONDS).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(timeout, TimeUnit.MILLISECONDS).build();
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).setDefaultSocketConfig(socketConfig).build();
            this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(this.requestConfig).build();
            this.summary = new TLValidationSummaryService(url, this.client, this.requestConfig);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            this.certificateFactory = CertificateFactory.getInstance("X509", "BC");
        }
        catch (NoSuchProviderException | CertificateException e) {
            log.error((Object)e);
        }
    }

    public void setTrustedFinalCert(boolean trustedFinalCert) {
        this.trustedFinalCert = trustedFinalCert;
    }

    public boolean isTrustedFinalCert() {
        return this.trustedFinalCert;
    }

    private synchronized void refreshIfNeeded() {
        if (System.currentTimeMillis() - this.lastUpdate > this.updateInterval) {
            log.info("refresh needed, last update: {}", (Object)new Date(this.lastUpdate));
            this.lastUpdate = System.currentTimeMillis();
            this.knownFlagMap = new HashMap<EntityIdentifier, Boolean>();
            this.trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();
            this.source = new CommonCertificateSource();
            this.summary.refresh();
        }
    }

    public boolean isTrusted(CertificateToken token) {
        return this.isKnown(token);
    }

    public synchronized boolean isKnown(CertificateToken token) {
        if (!this.trustedFinalCert && token.getCertificate().getBasicConstraints() == -1) {
            return false;
        }
        this.refreshIfNeeded();
        Boolean known = this.knownFlagMap.get(token.getEntityKey());
        if (known != null) {
            return known;
        }
        boolean found = this.source.isKnown(token);
        if (!found && (found = this.checkCertificate(token, "/validate/tsl/known", e -> this.trustedCertificateSource.isKnown(token)))) {
            this.source.addCertificate(token);
        }
        this.knownFlagMap.put(token.getEntityKey(), found);
        log.debug("known:{}: {}", (Object)found, (Object)token.getSubject().getPrincipal().getName());
        return found;
    }

    public int getNumberOfCertificates() {
        this.refreshIfNeeded();
        return this.source.getNumberOfCertificates();
    }

    private Set<CertificateToken> getCertificateBy(GetCertificateBy jsonRequest) {
        String uri = "/tsl/validate/certby";
        try {
            String json = JSONFactory.buildJSON((Object)jsonRequest, (String)"request");
            HttpPost request = new HttpPost(this.url + uri);
            request.setEntity((HttpEntity)new StringEntity(json));
            request.setConfig(this.requestConfig);
            log.info("getCertificateBy {} {}", (Object)uri, (Object)json);
            return (Set)this.client.execute((ClassicHttpRequest)request, httpResp -> {
                HashSet<CertificateToken> tokens = new HashSet<CertificateToken>();
                int statusCode = httpResp.getCode();
                if (statusCode != 200) {
                    return tokens;
                }
                byte[] content = IOUtils.toByteArray((InputStream)httpResp.getEntity().getContent());
                GetCertificateByResp resp = (GetCertificateByResp)((Object)((Object)JSONFactory.buildObject((byte[])content, (String)"response", GetCertificateByResp.class)));
                if (!resp.isSuccess()) {
                    throw new HttpException(resp.getError());
                }
                if (resp.getCertList() != null) {
                    for (String cert : resp.getCertList()) {
                        byte[] decode = Base64.getDecoder().decode(cert);
                        try {
                            tokens.add(new CertificateToken((X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(decode))));
                        }
                        catch (CertificateException e) {
                            throw new IOException(e);
                        }
                    }
                }
                return tokens;
            });
        }
        catch (Exception e) {
            log.warn("tsl service error get by {}: {}", (Object)jsonRequest.getMethod(), (Object)e.getMessage());
            return new HashSet<CertificateToken>();
        }
    }

    public Set<CertificateToken> getBySignerIdentifier(SignerIdentifier signerIdentifier) {
        this.refreshIfNeeded();
        Set<CertificateToken> tokens = super.getBySignerIdentifier(signerIdentifier);
        if (tokens == null || tokens.isEmpty()) {
            tokens = this.getCertificateBy(new GetCertificateBy(signerIdentifier));
            this.addCertificates(tokens);
        }
        log.debug("byid: {}: {}", (Object)tokens.size(), (Object)signerIdentifier.getSerialNumber());
        return tokens;
    }

    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        this.refreshIfNeeded();
        Set<CertificateToken> tokens = this.source.getByCertificateDigest(digest);
        if (tokens == null || tokens.isEmpty()) {
            tokens = this.getCertificateBy(new GetCertificateBy(digest));
            this.addCertificates(tokens);
        }
        log.debug("bydigest: {}: {}", (Object)tokens.size(), (Object)digest.getHexValue());
        return tokens;
    }

    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        this.refreshIfNeeded();
        Set<CertificateToken> tokens = this.source.getByPublicKey(publicKey);
        if (tokens == null || tokens.isEmpty()) {
            tokens = this.getCertificateBy(new GetCertificateBy(publicKey));
            this.addCertificates(tokens);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("bykey: {}: {}", (Object)tokens.size(), (Object)Hex.toHexString((byte[])MessageDigest.getInstance("SHA1").digest(publicKey.getEncoded())));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("digest alg error: {}", (Object)e.getMessage());
        }
        return tokens;
    }

    public Set<CertificateToken> getBySki(byte[] ski) {
        this.refreshIfNeeded();
        Set<CertificateToken> tokens = this.source.getBySki(ski);
        if (tokens == null || tokens.isEmpty()) {
            tokens = this.getCertificateBy(new GetCertificateBy(ski));
            this.addCertificates(tokens);
        }
        if (log.isDebugEnabled()) {
            log.debug("byski: {}: {}", (Object)tokens.size(), (Object)Hex.toHexString((byte[])ski));
        }
        return tokens;
    }

    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        this.refreshIfNeeded();
        Set<CertificateToken> tokens = this.source.getBySubject(subject);
        if (tokens == null || tokens.isEmpty()) {
            GetCertificateBy issuerName = new GetCertificateBy(subject.getPrincipal());
            tokens = this.tokensCache.get(issuerName.getIssuerName());
            if (tokens == null && (tokens = this.getCertificateBy(issuerName)) != null) {
                this.tokensCache.put(issuerName.getIssuerName(), tokens);
            }
            if (tokens != null) {
                this.addCertificates(tokens);
            }
        }
        log.debug("bysubject: {}: {}", (Object)(tokens != null ? Integer.valueOf(tokens.size()) : null), (Object)subject.getPrincipal().getName());
        return tokens;
    }

    private void addCertificates(Set<CertificateToken> tokens) {
        tokens.forEach(this::addCertificate);
    }

    public CertificateToken addCertificate(CertificateToken certificate) {
        this.source.addCertificate(certificate);
        return certificate;
    }

    public List<CertificateToken> getCertificates() {
        this.refreshIfNeeded();
        return this.source.getCertificates();
    }

    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_LIST;
    }

    private boolean checkCertificate(CertificateToken certificateToken, String uri, Predicate<Exception> errorHandler) {
        boolean ok;
        block3: {
            ok = false;
            try {
                log.info("checkCertificate {} {}", (Object)uri, (Object)certificateToken.getSubject().getPrettyPrintRFC2253());
                HttpPost request = new HttpPost(this.url + uri);
                request.setEntity((HttpEntity)new ByteArrayEntity(certificateToken.getCertificate().getEncoded(), ContentType.DEFAULT_BINARY));
                request.setConfig(this.requestConfig);
                ok = (Boolean)this.client.execute((ClassicHttpRequest)request, httpResp -> httpResp.getCode() == 200);
                if (!ok) {
                    ok = errorHandler.test(null);
                }
            }
            catch (Exception e) {
                log.warn("tsl service error cert {}: {}", (Object)certificateToken.getSerialNumber(), (Object)e.getMessage());
                if (errorHandler == null) break block3;
                ok = errorHandler.test(e);
            }
        }
        log.info("{}: {}: {}", (Object)uri, (Object)ok, (Object)certificateToken.getSubject().getPrincipal());
        return ok;
    }

    public synchronized List<TrustProperties> getTrustServices(CertificateToken token) {
        this.refreshIfNeeded();
        List trustProperties = this.trustPropertiesByEntity.get(token.getEntityKey());
        if (trustProperties == null) {
            try {
                HttpPost request = new HttpPost(this.url + "/validate/tsl/trust-service");
                request.setEntity((HttpEntity)new ByteArrayEntity(token.getCertificate().getEncoded(), ContentType.DEFAULT_BINARY));
                request.setConfig(this.requestConfig);
                trustProperties = (List)this.client.execute((ClassicHttpRequest)request, httpResp -> {
                    int statusCode = httpResp.getCode();
                    if (statusCode == 200) {
                        String json = new String(IOUtils.toByteArray((InputStream)httpResp.getEntity().getContent()));
                        TrustPropertiesListJson list = TrustPropertiesListJson.fromJson(json);
                        List<TrustProperties> props = list.toList();
                        this.addCertificateLocal(token, props);
                        return props;
                    }
                    return null;
                });
            }
            catch (IOException | UnsupportedOperationException | CertificateEncodingException e) {
                log.warn("error trust service cert {} error: {}", (Object)token.getSerialNumber(), (Object)e.getMessage());
            }
            if (trustProperties == null) {
                trustProperties = super.getTrustServices(token);
            }
        }
        log.debug("trustservices: {}: {}", (Object)trustProperties.size(), (Object)token.getSubject().getPrincipal().getName());
        return trustProperties;
    }

    private void addCertificateLocal(CertificateToken certificateToken, List<TrustProperties> trustPropertiesList) {
        this.source.addCertificate(certificateToken);
        EntityIdentifier entityKey = certificateToken.getEntityKey();
        List list = this.trustPropertiesByEntity.computeIfAbsent(entityKey, k -> new ArrayList());
        for (TrustProperties trustProperties : trustPropertiesList) {
            if (list.contains(trustProperties)) continue;
            list.add(trustProperties);
        }
    }

    public TLValidationSummaryService getSummary() {
        this.refreshIfNeeded();
        return this.summary;
    }
}

