/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier;

import com.anf.cryptotoken.ocsp.OCSPHandler;
import com.anf.cryptotoken.ocsp.OCSPHandlerFactory;
import com.anf.cryptotoken.sign.policy.ANFSignaturePolicyProvider;
import com.anf.cryptotoken.sign.verifier.error.AlertErrorCode;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlert;
import com.anf.cryptotoken.sign.verifier.sources.ANFAIASource;
import com.anf.cryptotoken.sign.verifier.sources.ANFOnlineOCSPSource;
import eu.europa.esig.dss.service.crl.OnlineCRLSource;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.service.http.commons.OCSPDataLoader;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import eu.europa.esig.dss.spi.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hc.core5.ssl.TrustStrategy;

public class ANFCertificateVerifier
extends CommonCertificateVerifier {
    private ANFSignaturePolicyProvider signaturePolicyProvider;
    private TrustStrategy trustAll = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    };
    protected OCSPHandler ocspHandler = OCSPHandlerFactory.ocspHandler();

    public ANFCertificateVerifier(CertificateSource ... sources) {
        this.setTrustedCertSources(sources);
        this.setCheckRevocationForUntrustedChains(true);
        this.setAlertOnExpiredCertificate(new SignatureAlert(AlertErrorCode.EXPIRED_CERTIFICATE_NO_POE));
        this.setAlertOnInvalidSignature(new SignatureAlert(AlertErrorCode.INVALID_SIGNATURE));
        this.setAlertOnInvalidTimestamp(new SignatureAlert(AlertErrorCode.INVALID_TIMESTAMP));
        this.setAlertOnMissingRevocationData(new SignatureAlert(AlertErrorCode.MISSING_REVOCATION_DATA));
        this.setAlertOnNotYetValidCertificate(new SignatureAlert(AlertErrorCode.CERTIFICATE_VALIDITY));
        this.setAlertOnRevokedCertificate(new SignatureAlert(AlertErrorCode.CERTIFICATE_REVOKED));
        CommonsDataLoader crlDataLoader = new CommonsDataLoader();
        crlDataLoader.setTimeoutConnection(30000);
        crlDataLoader.setTimeoutSocket(30000);
        crlDataLoader.setTimeoutResponse(3000);
        crlDataLoader.setTimeoutConnectionRequest(3000);
        crlDataLoader.setTrustStrategy(this.trustAll);
        OnlineCRLSource crlSource = new OnlineCRLSource((DataLoader)crlDataLoader);
        this.setCrlSource((RevocationSource)crlSource);
        OCSPDataLoader commonsHttpDataLoader = new OCSPDataLoader();
        commonsHttpDataLoader.setTimeoutConnection(30000);
        commonsHttpDataLoader.setTimeoutSocket(30000);
        commonsHttpDataLoader.setTimeoutResponse(3000);
        commonsHttpDataLoader.setTimeoutConnectionRequest(3000);
        commonsHttpDataLoader.setTrustStrategy(this.trustAll);
        ANFOnlineOCSPSource ocspSource = new ANFOnlineOCSPSource((DataLoader)commonsHttpDataLoader);
        ocspSource.setAlertOnInvalidNonce(new SignatureAlert(AlertErrorCode.OCSP_INVALID_NONCE));
        this.setOcspSource((RevocationSource)ocspSource);
        CommonsDataLoader aiaDataLoader = new CommonsDataLoader();
        aiaDataLoader.setTimeoutConnection(3000);
        aiaDataLoader.setTimeoutConnectionRequest(3000);
        aiaDataLoader.setTimeoutResponse(3000);
        aiaDataLoader.setTimeoutSocket(3000);
        commonsHttpDataLoader.setTrustStrategy(this.trustAll);
        this.setAIASource((AIASource)new ANFAIASource(aiaDataLoader));
    }

    public SignaturePolicyProvider getSignaturePolicyProvider() {
        if (this.signaturePolicyProvider == null) {
            this.signaturePolicyProvider = new ANFSignaturePolicyProvider();
        }
        return this.signaturePolicyProvider;
    }

    public OCSPHandler getOcspHandler() {
        return this.ocspHandler;
    }
}

