/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.result.PadesSignatureResult;
import com.anf.cryptotoken.sign.validation.tsu.TimeStampDataImpl;
import com.anf.cryptotoken.sign.validation.validator.AbstractValidator;
import com.anf.cryptotoken.sign.validation.validator.PadesValidator;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.tsp.TSPException;

public class PadesValidatorImpl
extends AbstractValidator<PadesSignatureResult>
implements PadesValidator {
    private static final Logger log = Logger.getLogger(PadesValidatorImpl.class);

    public PadesValidatorImpl(ANFCertificateVerifier verifier) {
        super(verifier);
    }

    public PadesValidatorImpl(ANFCertificateVerifier verifier, SignedDocumentValidator validator) {
        super(verifier, validator);
    }

    @Override
    public void verifySignatures(SignedDocumentValidator validator, VerificationResult pvr) {
        Reports reports = validator.validateDocument(this.validationPolicy);
        pvr.setReportGenerator(reports);
        List signatures = validator.getSignatures();
        signatures.forEach(signature -> {
            DefaultAdvancedSignature sign = (DefaultAdvancedSignature)signature;
            PadesSignatureResult result = new PadesSignatureResult(this.verifier, reports, sign, this.isOCSPValidation());
            List originalDocuments = validator.getOriginalDocuments(signature);
            if (!originalDocuments.isEmpty()) {
                result.setOriginalContent((DSSDocument)originalDocuments.get(0));
            }
            pvr.addSignatureResult(result);
        });
        List detachedTimestamps = validator.getDetachedTimestamps();
        if (detachedTimestamps != null && !detachedTimestamps.isEmpty()) {
            detachedTimestamps.forEach(tsp -> {
                try {
                    TimeStampDataImpl data = new TimeStampDataImpl((TimestampToken)tsp, tsp.isValid(), this.isOCSPValidation());
                    pvr.addTimestamp(data);
                }
                catch (TSPException e) {
                    log.error((Object)e);
                }
            });
        }
    }

    @Override
    public SignaturePackaging getSignaturePackaging(File file) throws IOException {
        return SignaturePackaging.ENVELOPED;
    }
}

