/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.pades.factory.PdfSignatureObjectFactoryServiceLocator;
import com.anf.cryptotoken.sign.validation.SignatureResult;
import com.anf.cryptotoken.sign.validation.TimeStampData;
import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.exception.NullValidatorException;
import com.anf.cryptotoken.sign.validation.policy.ANFValidationPolicyFactory;
import com.anf.cryptotoken.sign.validation.validator.SignatureValidator;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import com.anf.timestamp.services.TimeStampValidator;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bouncycastle.tsp.TimeStampToken;

public abstract class AbstractValidator<E extends SignatureResult>
implements SignatureValidator {
    private static final Logger log = Logger.getLogger(AbstractValidator.class);
    private boolean doOCSPValidation = true;
    protected ANFCertificateVerifier verifier;
    private SignedDocumentValidator validator;
    private File originalFile;
    private Locale locale = Locale.getDefault();
    protected ValidationPolicy validationPolicy = ANFValidationPolicyFactory.getDefaultPolicy();

    protected AbstractValidator(ANFCertificateVerifier verifier) {
        this(verifier, null);
    }

    protected AbstractValidator(ANFCertificateVerifier verifier, SignedDocumentValidator validator) {
        this.verifier = verifier;
        this.validator = validator;
        this.setOCSPValidation(verifier != null && verifier.getOcspSource() != null);
    }

    @Override
    public AbstractValidator<E> setOCSPValidation(boolean doOCSPValidation) {
        this.doOCSPValidation = doOCSPValidation;
        return this;
    }

    @Override
    public AbstractValidator<E> setOriginalFile(File originalFile) {
        this.originalFile = originalFile;
        return this;
    }

    @Override
    public boolean isOCSPValidation() {
        return this.doOCSPValidation;
    }

    @Override
    public VerificationResult verifySignatures() throws IOException {
        if (this.validator == null) {
            throw new NullValidatorException();
        }
        return this.verifySignature(this.validator);
    }

    @Override
    public VerificationResult verifySignatures(File file) throws IOException {
        return this.verifySignature(this.createDSSValidator(file));
    }

    private VerificationResult verifySignature(SignedDocumentValidator validator) {
        VerificationResult pvr = new VerificationResult();
        if (this.originalFile != null) {
            validator.setDetachedContents(Arrays.asList(new FileDocument(this.originalFile)));
        }
        validator.setLocale(this.locale);
        validator.setCertificateVerifier((CertificateVerifier)this.verifier);
        this.verifySignatures(validator, pvr);
        pvr.setLang(this.locale.getLanguage());
        return pvr;
    }

    public abstract void verifySignatures(SignedDocumentValidator var1, VerificationResult var2);

    public X509Certificate[] getSigningCertificateChain(File file) {
        return this.getSigningCertificateChain(file, null);
    }

    public X509Certificate[] getSigningCertificateChain(File file, String signatureId) {
        SignedDocumentValidator fileValidator = this.createDSSValidator(file);
        ArrayList certs = new ArrayList();
        List signatures = fileValidator.getSignatures();
        for (AdvancedSignature sign : signatures) {
            if (signatureId != null && !sign.getId().equals(signatureId)) continue;
            List certInfos = sign.getCertificateSource().getKeyInfoCertificates();
            certInfos.forEach(token -> certs.add(token.getCertificate()));
            break;
        }
        X509Certificate[] chain = new X509Certificate[certs.size()];
        certs.toArray(chain);
        return chain;
    }

    @Override
    public List<AdvancedSignature> getSignatures(File file) throws IOException {
        SignedDocumentValidator fileValidator = this.createDSSValidator(file);
        return fileValidator.getSignatures();
    }

    @Override
    public boolean getSignedContent(File file, File output) throws IOException {
        List signatures;
        SignedDocumentValidator fileValidator = this.createDSSValidator(file);
        if (this.originalFile != null) {
            fileValidator.setDetachedContents(Arrays.asList(new FileDocument(this.originalFile)));
        }
        if (!(signatures = fileValidator.getSignatures()).isEmpty()) {
            List originalDocuments = fileValidator.getOriginalDocuments((AdvancedSignature)signatures.get(0));
            if (!originalDocuments.isEmpty()) {
                ((DSSDocument)originalDocuments.get(0)).save(output.getCanonicalPath());
            }
            return !originalDocuments.isEmpty() && output.exists() && output.length() > 0L;
        }
        return false;
    }

    @Override
    public boolean getSignedContent(File file, String signatureId, File output) throws IOException {
        List originalDocuments;
        SignedDocumentValidator fileValidator = this.createDSSValidator(file);
        if (this.originalFile != null) {
            fileValidator.setDetachedContents(Arrays.asList(new FileDocument(this.originalFile)));
        }
        if (!(originalDocuments = fileValidator.getOriginalDocuments(signatureId)).isEmpty()) {
            ((DSSDocument)originalDocuments.get(0)).save(output.getCanonicalPath());
        }
        return !originalDocuments.isEmpty() && output.exists() && output.length() > 0L;
    }

    public SignedDocumentValidator createDSSValidator(File file) {
        FileDocument document = new FileDocument(file);
        SignedDocumentValidator fileValidator = SignedDocumentValidator.fromDocument((DSSDocument)document);
        fileValidator.setCertificateVerifier((CertificateVerifier)this.verifier);
        fileValidator.setEnableEtsiValidationReport(true);
        fileValidator.setValidationLevel(ValidationLevel.ARCHIVAL_DATA);
        if (fileValidator instanceof PDFDocumentValidator) {
            PDFDocumentValidator pdfValidator = (PDFDocumentValidator)fileValidator;
            pdfValidator.setPdfObjFactory((IPdfObjFactory)PdfSignatureObjectFactoryServiceLocator.getSignatureObjectFactory(file.length() < 0x100000L));
        }
        return fileValidator;
    }

    @Override
    public Map<String, TimeStampToken> extractTimeStamp(File xades) throws IOException {
        TreeMap<String, TimeStampToken> map = new TreeMap<String, TimeStampToken>();
        VerificationResult result = this.verifySignatures(xades);
        result.getSignatureResults().forEach(signRes -> {
            List<TimeStampData> tsData = signRes.getTsData();
            if (tsData != null && !tsData.isEmpty()) {
                map.put(signRes.getId(), tsData.get(0).getTst());
            }
        });
        return map;
    }

    @Override
    public boolean verifyTimeStamp(File signedFile, TimeStampToken requestToken) throws IOException {
        VerificationResult result = this.verifySignatures(signedFile);
        AtomicBoolean valid = new AtomicBoolean(false);
        result.getSignatureResults().forEach(signRes -> {
            List<TimeStampData> tsData = signRes.getTsData();
            if (tsData != null && !tsData.isEmpty()) {
                TimeStampData tsd = tsData.get(0);
                TimeStampToken token = tsd.getTst();
                try {
                    if (Arrays.equals(token.getEncoded(), requestToken.getEncoded()) && tsd.getTimeStampedData() != null) {
                        byte[] timeStampedData = tsd.getTimeStampedData().getContent();
                        boolean verifyTimeStamp = TimeStampValidator.verifyTimeStamp((TimeStampToken)requestToken, (byte[])timeStampedData);
                        log.info((Object)("time stamp found with serial number: " + requestToken.getTimeStampInfo().getSerialNumber() + ", and verified " + verifyTimeStamp));
                        valid.set(verifyTimeStamp);
                    }
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        });
        return valid.get();
    }

    @Generated
    public boolean isDoOCSPValidation() {
        return this.doOCSPValidation;
    }

    @Generated
    public ANFCertificateVerifier getVerifier() {
        return this.verifier;
    }

    @Generated
    public SignedDocumentValidator getValidator() {
        return this.validator;
    }

    @Generated
    public File getOriginalFile() {
        return this.originalFile;
    }

    @Override
    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public ValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    @Generated
    public void setDoOCSPValidation(boolean doOCSPValidation) {
        this.doOCSPValidation = doOCSPValidation;
    }

    @Generated
    public void setVerifier(ANFCertificateVerifier verifier) {
        this.verifier = verifier;
    }

    @Generated
    public void setValidator(SignedDocumentValidator validator) {
        this.validator = validator;
    }

    @Override
    @Generated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Generated
    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }
}

