/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.result;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.validation.impl.SignatureResultImpl;
import com.anf.cryptotoken.sign.validation.tsu.TimeStampDataImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import com.anf.cryptotoken.utils.AdditionalSignatureInformation;
import com.anf.cryptotoken.utils.CMSUtils;
import com.anf.cryptotoken.utils.TSPAlgoritmos;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Hex;

public class SMIMESignatureResult
extends SignatureResultImpl {
    private static final Logger log = Logger.getLogger(SMIMESignatureResult.class);
    private static final long serialVersionUID = 1L;
    private CMSTimeStampedData tsdata;
    private CMSSignedData signedData;

    public SMIMESignatureResult(ANFCertificateVerifier verifier, String sourceFileName, Reports reports, DefaultAdvancedSignature signature, boolean doOCSPValidation) {
        super(verifier, reports, signature, doOCSPValidation);
        this.fileName = sourceFileName;
        this.signaturePackaging = SignaturePackaging.ENVELOPED;
        if (signature instanceof CAdESSignature) {
            this.setContentHash(this.getSignature().getMessageDigestValue());
            System.out.println("hash:" + new String(Hex.encode((byte[])this.getContentHash())));
        }
    }

    public SMIMESignatureResult(String id, CMSSignedData data, AdditionalSignatureInformation additionalSignatureInformation, boolean doOCSPValidation) {
        this.init(id, data, additionalSignatureInformation, doOCSPValidation);
    }

    public SMIMESignatureResult(String id, CMSTimeStampedData tsdata, CMSProcessable contentFile, AdditionalSignatureInformation additionalSignatureInformation, boolean doOCSPValidation) {
        super(null, doOCSPValidation);
        this.id = id;
        this.tsdata = tsdata;
        try {
            TimeStampToken[] tokens = tsdata.getTimeStampTokens();
            for (int i = 0; i < tokens.length; ++i) {
                TimeStampToken token = tokens[i];
                TimeStampDataImpl tsd = new TimeStampDataImpl(token, tsdata, false);
                this.tsData.add(tsd);
            }
            this.signedData = contentFile == null ? new CMSSignedData(tsdata.getContent()) : new CMSSignedData(contentFile, tsdata.getContent());
            this.init(id, this.signedData, additionalSignatureInformation, doOCSPValidation);
        }
        catch (Throwable e) {
            this.errors.add(e);
        }
    }

    private void init(String id, CMSSignedData data, AdditionalSignatureInformation additionalSignatureInformation, boolean doOCSPValidation) {
        this.id = id;
        this.signedData = data;
        try {
            X509Certificate issuer;
            BasicOCSPResponse response = this.getOCSPResponse();
            if (response != null) {
                this.ocspResult = this.ocspHandler.getValidationResult(response);
            }
            this.signingCertificateChain = CMSUtils.getCertificates((CMSSignedData)this.signedData);
            X509Certificate signCert = this.signingCertificateChain[CertUtils.getFinalCert((X509Certificate[])this.signingCertificateChain)];
            this.coversWholeDocument = this.integrity = SMIMESignatureResult.verifyIntegrity(signCert, Security.getProvider("BC"), this.signedData);
            SignerInformation sigInfo = (SignerInformation)data.getSignerInfos().getSigners().iterator().next();
            this.hashAlgorithmOid = sigInfo.getDigestAlgOID();
            if (this.hashAlgorithmOid != null) {
                this.hashAlgorithm = TSPAlgoritmos.getAlgName((String)this.hashAlgorithmOid);
                if (this.hashAlgorithm != null && !this.hashAlgorithm.isEmpty()) {
                    this.encryptionAlgorithm = new DefaultDigestAlgorithmIdentifierFinder().find(new ASN1ObjectIdentifier(sigInfo.getEncryptionAlgOID())).getAlgorithm().getId();
                    if (this.encryptionAlgorithm != null && !this.encryptionAlgorithm.isEmpty()) {
                        this.signAlgorithm = this.hashAlgorithm.replace("-", "") + "with" + this.encryptionAlgorithm;
                    }
                }
            }
            this.contentHash = sigInfo.getContentDigest();
            this.signingCertificateChainStatus = this.ocspHandler.verifyCertificateChain(this.signingCertificateChain);
            if (doOCSPValidation && (issuer = CertUtils.getIssuerCertificate((X509Certificate[])this.signingCertificateChain, (X509Certificate)signCert)) != null) {
                for (int i = 0; i < this.signingCertificateChainStatus.size(); ++i) {
                    CertStatus status = (CertStatus)this.signingCertificateChainStatus.get(i);
                    if (!status.getCert().getSerialNumber().toString().equals(signCert.getSerialNumber().toString())) continue;
                    BasicOCSPResp ocspResponse = this.ocspHandler.getOCSPResponse(signCert, issuer);
                    status.setOcspResponse(ocspResponse);
                    status.setStatusOCSP(this.ocspHandler.getStatus(ocspResponse));
                }
            }
        }
        catch (CertificateException | CMSException e) {
            log.error((Object)e);
            this.errors.add(e);
        }
    }

    public static boolean verifyIntegrity(final X509Certificate certificate, Provider provider, CMSSignedData firmado) throws CMSException {
        final JcaSimpleSignerInfoVerifierBuilder sigVerifBuilder = new JcaSimpleSignerInfoVerifierBuilder();
        SignerInformationVerifierProvider verifierProvider = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                SignerInformationVerifier build = sigVerifBuilder.setProvider("BC").build(certificate);
                return build;
            }
        };
        boolean verify = firmado.verifySignatures(verifierProvider);
        return verify;
    }

    private BasicOCSPResponse getOCSPResponse() {
        Iterator iter;
        Collection matches;
        BasicOCSPResponse response = null;
        Store otherRevocationInfo = this.signedData.getOtherRevocationInfo(PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
        if (otherRevocationInfo != null && (matches = otherRevocationInfo.getMatches(null)) != null && (iter = matches.iterator()).hasNext()) {
            try {
                response = BasicOCSPResponse.getInstance(iter.next());
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        return response;
    }

    public CAdESSignature getSignature() {
        return (CAdESSignature)super.getSignature();
    }

    @Override
    public InputStream getSignedContent() {
        return null;
    }
}

