/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.result;

import com.anf.cryptotoken.sign.validation.impl.SignatureResultImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfModificationDetection;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.reports.Reports;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class PadesSignatureResult
extends SignatureResultImpl {
    private static final Logger log = LogManager.getLogger(PadesSignatureResult.class);
    private static final long serialVersionUID = 1L;
    private PdfModificationDetection modificationDetection;

    public PadesSignatureResult(ANFCertificateVerifier verifier, Reports reports, DefaultAdvancedSignature signature, boolean doOCSPValidation) {
        super(verifier, reports, signature, doOCSPValidation);
        if (signature instanceof PAdESSignature) {
            this.signaturePackaging = SignaturePackaging.ENVELOPED;
            this.setContentHash(this.getSignature().getMessageDigestValue());
            byte[] hashContent = this.getContentHash();
            log.info("signature hash: {}", (Object)(hashContent == null ? null : new String(Hex.encode((byte[])hashContent))));
            this.checkPdfModifications();
        }
    }

    private void checkPdfModifications() {
        PdfSignatureRevision pdfRevision = this.getSignature().getPdfRevision();
        if (pdfRevision != null) {
            this.signatureByteRange = pdfRevision.getPdfSigDictInfo().getByteRange();
            this.modificationDetection = pdfRevision.getModificationDetection();
            if (this.modificationDetection != null) {
                this.modifications = 0;
                PdfObjectModifications objectModifications = this.modificationDetection.getObjectModifications();
                if (objectModifications != null) {
                    this.countModifications(objectModifications);
                    this.modifications += objectModifications.getUndefinedChanges().size();
                }
                this.modifications += this.modificationDetection.getPageDifferences().size();
                this.modifications += this.modificationDetection.getVisualDifferences().size();
                this.modified = this.modifications > 0;
            }
        }
    }

    private void countModifications(PdfObjectModifications objectModifications) {
        TreeSet<String> index = new TreeSet<String>();
        for (ObjectModification mod : objectModifications.getAnnotCreationChanges()) {
            PdfObject pdfObject = mod.getFinalObject();
            if (pdfObject instanceof PdfArray) {
                PdfArray arrayObj = (PdfArray)pdfObject;
                int size = arrayObj.size();
                for (int i = 0; i < size; ++i) {
                    PdfDict dictObj = arrayObj.getAsDict(i);
                    this.countModification(objectModifications, index, mod, dictObj);
                }
                continue;
            }
            pdfObject = mod.getFinalObject();
            if (!(pdfObject instanceof PdfDict)) continue;
            PdfDict dictObj = (PdfDict)pdfObject;
            this.countModification(objectModifications, index, mod, dictObj);
        }
    }

    private void countModification(PdfObjectModifications objectModifications, Set<String> index, ObjectModification mod, PdfDict dictObj) {
        ObjectModification found;
        String objName = dictObj.getNameValue("T");
        if (objName != null && index.add(objName) && ((found = this.findObjectInSecureChanges(objectModifications.getSecureChanges(), objName)) == null || found.getActionType() != mod.getActionType())) {
            ++this.modifications;
        }
    }

    private ObjectModification findObjectInSecureChanges(List<ObjectModification> secureChanges, String objName) {
        for (ObjectModification mod : secureChanges) {
            PdfDict dict;
            String modName;
            PdfObject pdfObject = mod.getFinalObject();
            if (pdfObject instanceof PdfArray) {
                PdfArray arrayObj = (PdfArray)pdfObject;
                int size = arrayObj.size();
                for (int i = 0; i < size; ++i) {
                    PdfDict dictObj = arrayObj.getAsDict(i);
                    String dictObjName = dictObj.getNameValue("T");
                    if (dictObjName == null || !dictObjName.equals(objName)) continue;
                    return mod;
                }
                continue;
            }
            PdfObject size = mod.getFinalObject();
            if (!(size instanceof PdfDict) || (modName = (dict = (PdfDict)size).getNameValue("T")) == null || !modName.equals(objName)) continue;
            return mod;
        }
        return null;
    }

    public PAdESSignature getSignature() {
        return (PAdESSignature)super.getSignature();
    }
}

