/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.result;

import com.anf.cryptotoken.sign.validation.impl.SignatureResultImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.InputStream;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.util.encoders.Hex;

public class CadesSignatureResult
extends SignatureResultImpl {
    private static final long serialVersionUID = 1L;

    public CadesSignatureResult(String id, boolean integrity) {
        super(id, integrity);
    }

    public CadesSignatureResult(ANFCertificateVerifier verifier, Reports reports, DefaultAdvancedSignature signature, boolean doOCSPValidation) {
        super(verifier, reports, signature, doOCSPValidation);
        if (signature instanceof CAdESSignature) {
            CAdESSignature cades = (CAdESSignature)signature;
            this.setContentHash(this.getSignature().getMessageDigestValue());
            System.out.println("hash:" + new String(Hex.encode((byte[])this.getContentHash())));
            CMSTypedData signedContent = cades.getCmsSignedData().getSignedContent();
            this.signaturePackaging = signedContent == null ? SignaturePackaging.DETACHED : SignaturePackaging.ENVELOPING;
        }
    }

    public CAdESSignature getSignature() {
        return (CAdESSignature)super.getSignature();
    }

    @Override
    public InputStream getSignedContent() {
        return this.getSignature().getOriginalDocument().openStream();
    }
}

