/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.impl;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.api.ocsp.OCSPValidationResult;
import com.anf.cryptotoken.api.sign.exception.ANFVerifySignatureException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.json.TSLCertificateValidation;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.OCSPHandler;
import com.anf.cryptotoken.sign.validation.PolicyValidationResult;
import com.anf.cryptotoken.sign.validation.SignatureResult;
import com.anf.cryptotoken.sign.validation.TimeStampData;
import com.anf.cryptotoken.sign.validation.impl.PolicyValidationResultImpl;
import com.anf.cryptotoken.sign.validation.tsu.TimeStampDataImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import com.anf.cryptotoken.tsl.TSLController;
import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.OriginalIdentifierProvider;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPException;

public abstract class SignatureResultImpl
implements SignatureResult,
Serializable {
    private static final Logger log = Logger.getLogger(SignatureResultImpl.class);
    private static final long serialVersionUID = 1L;
    protected String id;
    protected boolean integrity;
    protected OCSPValidationResult ocspResult;
    protected X509Certificate[] signingCertificateChain;
    protected List<TimeStampData> tsData = new ArrayList<TimeStampData>();
    protected List<CertStatus> signingCertificateChainStatus;
    protected boolean coversWholeDocument;
    protected List<Throwable> errors = new ArrayList<Throwable>();
    protected String signAlgorithm;
    protected String signAlgorithmXmlId;
    protected String encryptionAlgorithm;
    protected String encryptionAlgorithmOid;
    protected String hashAlgorithm;
    protected String hashAlgorithmOid;
    protected String hashAlgorithmXmlId;
    protected byte[] contentHash;
    protected DefaultDigestAlgorithmIdentifierFinder algNameFinder;
    protected Date signingTime;
    protected DefaultAdvancedSignature signature;
    protected String fileName;
    protected String reason;
    protected String location;
    protected SignatureLevel signatureLevel;
    protected OCSPHandler ocspHandler;
    protected String scope;
    protected String scopeType;
    protected ByteRange signatureByteRange;
    private List<CommitmentTypeIndication> commitmentTypeIndications;
    private SignaturePolicy policy;
    private PolicyValidationResult policyValidation;
    private Indication validationIndication;
    private SubIndication validationSubIndication;
    private Set<String> infos;
    private Set<String> warnings;
    private DSSDocument originalContent;
    protected boolean modified;
    protected int modifications;
    protected SignaturePackaging signaturePackaging;
    protected TSLCertificateValidation tslInfo;
    protected X509Certificate signCert;
    protected Indication longTermValidationIndication;
    protected Map<String, String> semanticsMap = new TreeMap<String, String>();

    protected SignatureResultImpl(String id, boolean integrity) {
        this.id = id;
        this.integrity = integrity;
    }

    public SignatureResultImpl() {
        AgregarProveedor.agregarBouncyCastleProvider();
        this.algNameFinder = new DefaultDigestAlgorithmIdentifierFinder();
    }

    public SignatureResultImpl(ANFCertificateVerifier verifier, Reports reports, DefaultAdvancedSignature signature, boolean doOCSPValidation) {
        this();
        String signatureId;
        this.ocspHandler = verifier.getOcspHandler();
        this.signature = signature;
        this.id = signatureId = signature.getId();
        try {
            this.integrity = signature.getSignatureCryptographicVerification().isSignatureValid();
        }
        catch (Exception e) {
            this.integrity = false;
        }
        List signatureScopes = signature.getSignatureScopes();
        if (signatureScopes != null && !signatureScopes.isEmpty()) {
            SignatureScope signatureScope = (SignatureScope)signatureScopes.get(0);
            if (signatureScope.getType() != null) {
                this.scopeType = signatureScope.getType().name();
            }
            OriginalIdentifierProvider tokenIdentifierProvider = new OriginalIdentifierProvider();
            this.scope = signatureScope.getName((TokenIdentifierProvider)tokenIdentifierProvider) + (String)(this.scopeType != null ? " (" + this.scopeType + ")" : "") + " " + signatureScope.getDescription((TokenIdentifierProvider)tokenIdentifierProvider);
        }
        this.signatureLevel = signature.getDataFoundUpToLevel();
        this.commitmentTypeIndications = signature.getCommitmentTypeIndications();
        try {
            this.policy = signature.getSignaturePolicy();
        }
        catch (Exception e1) {
            log.error((Object)e1);
            this.errors.add(e1);
        }
        this.fileName = signature.getFilename();
        this.signingTime = signature.getSigningTime();
        this.encryptionAlgorithm = signature.getEncryptionAlgorithm().getName();
        this.encryptionAlgorithmOid = signature.getEncryptionAlgorithm().getOid();
        if (signature.getDigestAlgorithm() != null) {
            this.hashAlgorithm = signature.getDigestAlgorithm().getJavaName();
            this.hashAlgorithmOid = signature.getDigestAlgorithm().getOid();
            this.hashAlgorithmXmlId = signature.getDigestAlgorithm().getUri();
        }
        this.signAlgorithm = signature.getSignatureAlgorithm().getJCEId();
        this.signAlgorithmXmlId = signature.getSignatureAlgorithm().getUri();
        this.coversWholeDocument = this.integrity;
        SignatureWrapper signatureWrapper = reports.getDiagnosticData().getSignatureById(signatureId);
        if (signatureWrapper.isPolicyPresent()) {
            this.policyValidation = new PolicyValidationResultImpl(signatureWrapper.isPolicyDigestValid(), signatureWrapper.getPolicyProcessingError(), signatureWrapper.getPolicyId(), signatureWrapper.getPolicyDescription(), signatureWrapper.getPolicyUrl());
        }
        this.reason = signatureWrapper.getReason();
        this.location = signatureWrapper.getCountryName();
        if (this.reason != null) {
            if (this.policy != null) {
                this.errors.add(new Exception("ERR_REASON_AND_POLICY"));
            }
            if (this.commitmentTypeIndications != null && !this.commitmentTypeIndications.isEmpty()) {
                this.errors.add(new Exception("ERR_REASON_AND_COMMITMENTS"));
            }
        }
        reports.getDetailedReportJaxb().getSemantic().forEach(s -> this.semanticsMap.put(s.getKey(), s.getValue()));
        DetailedReport detailedReport = reports.getDetailedReport();
        this.validationIndication = detailedReport.getFinalIndication(signatureId);
        this.validationSubIndication = detailedReport.getFinalSubIndication(signatureId);
        this.longTermValidationIndication = detailedReport.getLongTermValidationIndication(signatureId);
        this.infos = detailedReport.getAdESValidationInfos(signatureId).stream().map(Message::getValue).collect(Collectors.toSet());
        this.warnings = detailedReport.getAdESValidationWarnings(signatureId).stream().map(Message::getValue).collect(Collectors.toSet());
        this.errors.addAll(detailedReport.getAdESValidationErrors(signatureId).stream().map(Message::getValue).map(Exception::new).collect(Collectors.toList()));
        CertificateToken signingCertificateToken = signature.getSigningCertificateToken();
        if (signingCertificateToken != null) {
            List certificates = verifier.getTrustedCertSources().getCertificates();
            this.buildCertificateChain(signingCertificateToken, certificates, doOCSPValidation);
            this.signCert = signingCertificateToken.getCertificate();
            Set allRevocationTokens = signature.getOCSPSource().getAllRevocationTokens();
            this.matchSignCertOCSPResponse(this.signCert, allRevocationTokens);
        }
        List archiveTimestamps = signature.getArchiveTimestamps();
        List signatureTimestamps = signature.getSignatureTimestamps();
        try {
            TimestampToken timestampToken = null;
            if (archiveTimestamps != null && !archiveTimestamps.isEmpty()) {
                timestampToken = (TimestampToken)archiveTimestamps.get(0);
            } else if (signatureTimestamps != null && !signatureTimestamps.isEmpty()) {
                timestampToken = (TimestampToken)signatureTimestamps.get(0);
            }
            if (timestampToken != null) {
                TimeStampDataImpl tsd = new TimeStampDataImpl(timestampToken, null, doOCSPValidation);
                this.tsData.add(tsd);
            }
        }
        catch (TSPException e) {
            log.error((Object)e);
        }
    }

    @Override
    public void validateSignatureResult() {
        if (!this.integrity) {
            throw new ANFVerifySignatureException("ERR_SIGNATURE_INTEGRITY");
        }
        if (this.signatureLevel == null) {
            throw new ANFVerifySignatureException("ERR_SIGNATURE_LEVEL");
        }
        if (this.signAlgorithm == null) {
            throw new ANFVerifySignatureException("ERR_SIGNATURE_ALGORITHM");
        }
        if (this.contentHash == null) {
            throw new ANFVerifySignatureException("ERR_CONTENT_HASH");
        }
        if (this.signingCertificateChain == null) {
            throw new ANFVerifySignatureException("ERR_NO_SIGN_CERT");
        }
        if (this.signingCertificateChain == null || this.signingCertificateChain.length == 0) {
            throw new ANFVerifySignatureException("ERR_NO_SIGN_CERT");
        }
        if (this.signingCertificateChainStatus == null || this.signingCertificateChainStatus.size() == 0) {
            throw new ANFVerifySignatureException("ERR_NO_SIGN_CERT_STATUS");
        }
        if (this.validationIndication != Indication.TOTAL_PASSED) {
            throw new ANFVerifySignatureException("ERR_INVALID_INDICATION:" + this.validationIndication);
        }
        if (this.modified || this.modifications > 0) {
            throw new ANFVerifySignatureException("ERR_MODIFICATIONS");
        }
        if (this.validationSubIndication != null) {
            throw new ANFVerifySignatureException(this.validationSubIndication.name());
        }
        Date signTime = null;
        if (this.ocspResult != null) {
            if (!this.ocspResult.isValid()) {
                throw new ANFVerifySignatureException("ERR_INVALID_OCSP_RESP");
            }
            signTime = this.ocspResult.getProducedAt();
        }
        if (this.tsData != null && !this.tsData.isEmpty()) {
            for (TimeStampData timeStampData : this.tsData) {
                if (!(!timeStampData.isTimeStampSignature() || timeStampData.isValidateTimeStamp() && timeStampData.isVerifyTimeStamp() && timeStampData.isVigentOnSignTime())) {
                    throw new ANFVerifySignatureException("ERR_INVALID_TIMESTAMP");
                }
                Date timestampTime = timeStampData.getTst().getTimeStampInfo().getGenTime();
                if (signTime == null) {
                    signTime = timestampTime;
                }
                List<CertStatus> chainStatus = timeStampData.getTimeStampCertificateChainStatus();
                for (CertStatus status : chainStatus) {
                    X500Principal cert = status.getCert().getSubjectX500Principal();
                    if (cert == null) {
                        throw new ANFVerifySignatureException("ERR_NO_CERT_IN_CHAIN");
                    }
                    if (!status.isVerified()) {
                        throw new ANFVerifySignatureException("ERR_INVALID_CERT:" + cert);
                    }
                    if (status.getOcspValidationResult() == null || !status.getOcspValidationResult().isValid()) {
                        throw new ANFVerifySignatureException("ERR_INVALID_CERT_STATUS:" + cert);
                    }
                    Date revocationTime = status.getRevocationTime();
                    if (revocationTime == null || !revocationTime.before(timestampTime)) continue;
                    throw new ANFVerifySignatureException("ERR_TSU_CERT_REVOKED_ON_SIGN_TIME:" + cert);
                }
            }
        }
        for (CertStatus status : this.signingCertificateChainStatus) {
            X500Principal cert;
            block27: {
                cert = status.getCert().getSubjectX500Principal();
                if (cert == null) {
                    throw new ANFVerifySignatureException("ERR_NO_CERT_IN_CHAIN");
                }
                if (!status.isVerified()) {
                    throw new ANFVerifySignatureException("ERR_INVALID_CERT:" + cert);
                }
                try {
                    status.getCert().checkValidity();
                }
                catch (Exception e) {
                    if (signTime != null) break block27;
                    throw new ANFVerifySignatureException("ERR_EXPIRED_INDETERMINATE_SIGN_TIME");
                }
            }
            if (status.getOcspValidationResult() == null || !status.getOcspValidationResult().isValid()) {
                throw new ANFVerifySignatureException("ERR_INVALID_CERT_STATUS:" + cert);
            }
            Date revocationTime = status.getRevocationTime();
            if (signTime == null && revocationTime != null) {
                throw new ANFVerifySignatureException("ERR_REVOKED_INDETERMINATE_SIGN_TIME");
            }
            if (revocationTime == null || !revocationTime.before(signTime)) continue;
            throw new ANFVerifySignatureException("ERR_CERT_REVOKED_ON_SIGN_TIME:" + cert);
        }
    }

    private void matchSignCertOCSPResponse(X509Certificate signCert, Set<RevocationToken<OCSP>> allRevocationTokens) {
        for (RevocationToken<OCSP> ocspToken : allRevocationTokens) {
            try {
                X509Certificate ocspCert;
                OCSPResp ocspResp = new OCSPResp(ocspToken.getEncoded());
                BasicOCSPResp responseResponse = (BasicOCSPResp)ocspResp.getResponseObject();
                OCSPValidationResult ocspResult = this.ocspHandler.getValidationResult(responseResponse);
                X509Certificate[] ocspChain = ocspResult.getResponderCertChain();
                int ocspFinal = CertUtils.getFinalCert((X509Certificate[])ocspChain);
                if (ocspFinal != -1 && Arrays.equals((ocspCert = ocspChain[ocspFinal]).getIssuerX500Principal().getEncoded(), signCert.getIssuerX500Principal().getEncoded())) {
                    this.ocspResult = ocspResult;
                    break;
                }
                System.out.println(responseResponse);
            }
            catch (IOException | OCSPException e) {
                log.error((Object)e);
            }
        }
        System.out.println(allRevocationTokens);
    }

    private void matchOcspToSignCert(X509Certificate signCert, List<BasicOCSPResp> containedOCSPResponses) {
        for (BasicOCSPResp basicOCSPResp : containedOCSPResponses) {
            X509Certificate ocspCert;
            OCSPValidationResult ocspResult = this.ocspHandler.getValidationResult(basicOCSPResp);
            X509Certificate[] ocspChain = ocspResult.getResponderCertChain();
            int ocspFinal = CertUtils.getFinalCert((X509Certificate[])ocspChain);
            if (ocspFinal == -1 || !Arrays.equals((ocspCert = ocspChain[ocspFinal]).getIssuerX500Principal().getEncoded(), signCert.getIssuerX500Principal().getEncoded())) continue;
            this.ocspResult = ocspResult;
            break;
        }
    }

    protected void buildCertificateChain(CertificateToken signingCertificateToken, List<CertificateToken> certificates, boolean doOCSPValidation) {
        List statusList;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        X509Certificate signCert = signingCertificateToken.getCertificate();
        certs.add(signCert);
        X509Certificate issuer = signCert;
        while (issuer != null && !CertUtils.isSelfSigned((X509Certificate)issuer)) {
            X509Certificate nextIssuer = this.findIssuer(issuer, certificates);
            if (nextIssuer == null) {
                nextIssuer = CertUtils.getIssuerCertificate((X509Certificate)issuer);
            }
            if (nextIssuer != null) {
                certs.add(nextIssuer);
            }
            issuer = nextIssuer;
        }
        this.signingCertificateChain = new X509Certificate[certs.size()];
        certs.toArray(this.signingCertificateChain);
        this.signingCertificateChainStatus = this.ocspHandler.verifyCertificateChain(this.signingCertificateChain);
        if (doOCSPValidation && (statusList = this.ocspHandler.validateOCSPCertificateChain(this.signingCertificateChain)).size() == this.signingCertificateChainStatus.size()) {
            for (int i = 0; i < statusList.size(); ++i) {
                CertStatus certStatus = (CertStatus)statusList.get(i);
                if (certStatus.getOcspResponse() != null) {
                    this.signingCertificateChainStatus.get(i).setOcspResponse(certStatus.getOcspResponse());
                }
                if (certStatus.getStatusOCSP() == null) continue;
                this.signingCertificateChainStatus.get(i).setStatusOCSP(certStatus.getStatusOCSP());
            }
        }
    }

    private X509Certificate findIssuer(X509Certificate signCert, List<CertificateToken> certificates) {
        for (CertificateToken cert : certificates) {
            if (!CertUtils.isIssuer((X509Certificate)signCert, (X509Certificate)cert.getCertificate())) continue;
            return cert.getCertificate();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isIntegrity() {
        return this.integrity;
    }

    @Override
    public X509Certificate[] getSigningCertificateChain() {
        return this.signingCertificateChain;
    }

    @Override
    public List<CertStatus> getSigningCertificateChainStatus() {
        return this.signingCertificateChainStatus;
    }

    @Override
    public boolean isCoversWholeDocument() {
        return this.coversWholeDocument;
    }

    @Override
    public List<Throwable> getErrors() {
        return this.errors;
    }

    @Override
    public List<TimeStampData> getTsData() {
        return this.tsData;
    }

    @Override
    public void setOcspResult(OCSPValidationResult ocspResult) {
        this.ocspResult = ocspResult;
    }

    @Override
    public OCSPValidationResult getOcspResult() {
        return this.ocspResult;
    }

    @Override
    public boolean isQualifiedIssuer() {
        int finalCert = CertUtils.getFinalCert((X509Certificate[])this.signingCertificateChain);
        if (finalCert == -1) {
            throw new ANFCertificateException("ERR_SIGN_CERT_NOT_FOUND");
        }
        X509Certificate certificate = this.signingCertificateChain[finalCert];
        X509Certificate issuerCertificate = CertUtils.getIssuerCertificate((X509Certificate[])this.signingCertificateChain, (X509Certificate)certificate);
        if (this.tslInfo == null) {
            TSLController tslController = new TSLController();
            if (issuerCertificate != null) {
                try {
                    this.tslInfo = tslController.validateSignCertificateChain(this.signingCertificateChain);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        }
        if (this.tslInfo == null) {
            return false;
        }
        try {
            X509Certificate issuer = this.tslInfo.getTslIdCertificate();
            return issuer != null && Arrays.equals(issuer.getSignature(), issuerCertificate.getSignature());
        }
        catch (Throwable e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public void setCoversWholeDocument(boolean coversWholeDocument) {
        this.coversWholeDocument = coversWholeDocument;
    }

    @Override
    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    @Override
    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public String getHashAlgorithmOid() {
        return this.hashAlgorithmOid;
    }

    @Override
    public byte[] getContentHash() {
        return this.contentHash;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public String getSignAlgorithmXmlId() {
        return this.signAlgorithmXmlId;
    }

    @Override
    public String getEncryptionAlgorithmOid() {
        return this.encryptionAlgorithmOid;
    }

    @Override
    public String getHashAlgorithmXmlId() {
        return this.hashAlgorithmXmlId;
    }

    public DefaultDigestAlgorithmIdentifierFinder getAlgNameFinder() {
        return this.algNameFinder;
    }

    @Override
    public Date getSigningTime() {
        return this.signingTime;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected void setContentHash(byte[] contentHash) {
        this.contentHash = contentHash;
    }

    @Override
    public String getSignatureLevel() {
        return this.signatureLevel.name();
    }

    @Override
    public String getSignatureForm() {
        return this.signatureLevel.getSignatureForm().name();
    }

    public SignatureLevel getSignatureLevelEnum() {
        return this.signatureLevel;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public ByteRange getSignatureByteRange() {
        return this.signatureByteRange;
    }

    @Override
    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        return this.commitmentTypeIndications;
    }

    @Override
    public SignaturePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public Set<String> getInfos() {
        return this.infos;
    }

    @Override
    public Set<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public PolicyValidationResult getPolicyValidation() {
        return this.policyValidation;
    }

    @Override
    public Indication getValidationIndication() {
        return this.validationIndication;
    }

    @Override
    public SubIndication getValidationSubIndication() {
        return this.validationSubIndication;
    }

    public void setOriginalContent(DSSDocument originalContent) {
        this.originalContent = originalContent;
    }

    @Override
    public InputStream getSignedContent() {
        if (this.originalContent != null) {
            return this.originalContent.openStream();
        }
        return null;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public int getModifications() {
        return this.modifications;
    }

    @Override
    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    @Override
    @Generated
    public DefaultAdvancedSignature getSignature() {
        return this.signature;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public OCSPHandler getOcspHandler() {
        return this.ocspHandler;
    }

    @Generated
    public DSSDocument getOriginalContent() {
        return this.originalContent;
    }

    @Generated
    public TSLCertificateValidation getTslInfo() {
        return this.tslInfo;
    }

    @Override
    @Generated
    public X509Certificate getSignCert() {
        return this.signCert;
    }

    @Override
    @Generated
    public Indication getLongTermValidationIndication() {
        return this.longTermValidationIndication;
    }

    @Override
    @Generated
    public Map<String, String> getSemanticsMap() {
        return this.semanticsMap;
    }
}

