/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSUtils;

public final class SignPolicyBuilder {
    public static final String OID_SIGN_POLICY_ANF = "1.3.6.1.4.1.18332.27.1.1";
    private static final CommonsDataLoader httpDataLoader = new CommonsDataLoader();

    public static Policy buildPolicy() {
        Policy policy = new Policy();
        SignPolicyBuilder.defaultPolicyValues(policy);
        return policy;
    }

    public static void defaultPolicyValues(Policy policy) {
        policy.setId(OID_SIGN_POLICY_ANF);
        policy.setQualifier(ObjectIdentifierQualifier.OID_AS_URN);
        policy.setDigestAlgorithm(DigestAlgorithm.SHA256);
        policy.setDigestValue(new byte[]{0});
    }

    public static Policy buildPolicy(DigestAlgorithm signaturePolicyHashAlgo, String signaturePolicyDescription, String spURI) {
        return SignPolicyBuilder.buildPolicy(signaturePolicyHashAlgo, signaturePolicyDescription, spURI, null);
    }

    public static Policy buildPolicy(DigestAlgorithm signaturePolicyHashAlgo, String signaturePolicyDescription, String spURI, byte[] spHash) {
        Policy signaturePolicy = SignPolicyBuilder.buildPolicy();
        if (spHash == null) {
            spHash = DSSUtils.digest((DigestAlgorithm)signaturePolicyHashAlgo, (byte[])httpDataLoader.get(spURI));
        }
        signaturePolicy.setDescription(signaturePolicyDescription);
        signaturePolicy.setSpuri(spURI);
        signaturePolicy.setDigestAlgorithm(signaturePolicyHashAlgo);
        signaturePolicy.setDigestValue(spHash);
        SpDocSpecification spec = new SpDocSpecification();
        spec.setQualifier(ObjectIdentifierQualifier.OID_AS_URN);
        signaturePolicy.setSpDocSpecification(spec);
        return signaturePolicy;
    }

    public static Policy buildPolicy(DigestAlgorithm signaturePolicyHashAlgo, String spURI) {
        return SignPolicyBuilder.buildPolicy(signaturePolicyHashAlgo, spURI, spURI, null);
    }

    public static Policy buildPolicy(DigestAlgorithm signaturePolicyHashAlgo, String spURI, byte[] spHash) {
        return SignPolicyBuilder.buildPolicy(signaturePolicyHashAlgo, null, spURI, spHash);
    }
}

