/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.factory;

import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.sign.verifier.error.AlertErrorCode;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.pdf.AbstractPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfPermissionsChecker;
import eu.europa.esig.dss.pdf.PdfSignatureFieldPositionChecker;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.PdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFinder;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import eu.europa.esig.dss.signature.resources.TempFileResourcesHandlerBuilder;

public abstract class PdfSignatureObjectFactory
extends AbstractPdfObjFactory {
    private DSSResourcesHandlerBuilder resourceHandlerBuilder;
    private PDFSignatureService signService;
    private PDFSignatureService contentTimestampService;
    private PDFSignatureService signTimestampService;
    private PDFSignatureService archiveTimestampService;
    private StatusAlert alertOnSignatureFieldOverlap = t -> {};

    protected PdfSignatureObjectFactory(boolean smallFile) {
        this.resourceHandlerBuilder = !smallFile ? new TempFileResourcesHandlerBuilder().setFileNamePrefix("anf-").setTempFileDirectory(Files.anf()) : new InMemoryResourcesHandlerBuilder();
        PdfSignatureFieldPositionChecker pdfSignatureFieldPositionChecker = new PdfSignatureFieldPositionChecker();
        pdfSignatureFieldPositionChecker.setAlertOnSignatureFieldOverlap(this.alertOnSignatureFieldOverlap);
        this.setPdfSignatureFieldPositionChecker(pdfSignatureFieldPositionChecker);
        this.setResourcesHandlerBuilder(this.resourceHandlerBuilder);
        this.setPdfObjectModificationsFinder((PdfObjectModificationsFinder)new DefaultPdfObjectModificationsFinder());
        this.setPdfDifferencesFinder((PdfDifferencesFinder)new DefaultPdfDifferencesFinder());
        PdfPermissionsChecker pdfPermissionsChecker = new PdfPermissionsChecker();
        pdfPermissionsChecker.setAlertOnForbiddenSignatureCreation((StatusAlert)new SignatureAlert(AlertErrorCode.FORBIDDEN_SIGNATURE_CREATION));
        this.setPdfPermissionsChecker(pdfPermissionsChecker);
    }

    public void setAlertOnSignatureFieldOverlap(StatusAlert alertOnSignatureFieldOverlap) {
        this.alertOnSignatureFieldOverlap = alertOnSignatureFieldOverlap;
    }

    protected abstract PDFSignatureService build(PDFServiceMode var1);

    public PDFSignatureService newPAdESSignatureService() {
        if (this.signService == null) {
            this.signService = this.configure(this.build(PDFServiceMode.SIGNATURE));
        }
        return this.signService;
    }

    public PDFSignatureService newContentTimestampService() {
        if (this.contentTimestampService == null) {
            this.contentTimestampService = this.configure(this.build(PDFServiceMode.CONTENT_TIMESTAMP));
        }
        return this.contentTimestampService;
    }

    public PDFSignatureService newSignatureTimestampService() {
        if (this.signTimestampService == null) {
            this.signTimestampService = this.configure(this.build(PDFServiceMode.SIGNATURE_TIMESTAMP));
        }
        return this.signTimestampService;
    }

    public PDFSignatureService newArchiveTimestampService() {
        if (this.archiveTimestampService == null) {
            this.archiveTimestampService = this.configure(this.build(PDFServiceMode.ARCHIVE_TIMESTAMP));
        }
        return this.archiveTimestampService;
    }

    public void clearTempFiles() {
        DSSResourcesHandlerBuilder dSSResourcesHandlerBuilder = this.resourceHandlerBuilder;
        if (dSSResourcesHandlerBuilder instanceof TempFileResourcesHandlerBuilder) {
            TempFileResourcesHandlerBuilder filesResourceBuilder = (TempFileResourcesHandlerBuilder)dSSResourcesHandlerBuilder;
            filesResourceBuilder.clear();
        }
    }
}

