/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.message.impl;

import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.ui.message.MessageController;
import com.anf.cryptotoken.ui.message.MessageResult;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class MessageFxController
implements MessageController {
    private Stage stage;

    public MessageFxController() {
    }

    public MessageFxController(Stage stage) {
        this.stage = stage;
    }

    @Override
    public MessageResult showConfirmMessage(Object message, String title) {
        AtomicReference<MessageResult> ref = new AtomicReference<MessageResult>(MessageResult.CANCEL);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initStyle(StageStyle.UNDECORATED);
            alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                alert.initOwner((Window)this.stage);
            }
            alert.setTitle(title);
            alert.setHeaderText(message.toString());
            Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
            btOk.setText(Confis.get().getString("yes", new Object[0]));
            Button btCancel = (Button)alert.getDialogPane().lookupButton(ButtonType.CANCEL);
            btCancel.setText(Confis.get().getString("no", new Object[0]));
            Optional result = alert.showAndWait();
            ref.set(this.translateResult(result));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    private MessageResult translateResult(Optional<ButtonType> result) {
        MessageResult resultType = MessageResult.CANCEL;
        ButtonType buttonType = result.get();
        if (buttonType == ButtonType.OK) {
            resultType = MessageResult.OK;
        } else if (buttonType == ButtonType.CANCEL) {
            resultType = MessageResult.CANCEL;
        } else if (buttonType == ButtonType.YES) {
            resultType = MessageResult.YES;
        } else if (buttonType == ButtonType.NO) {
            resultType = MessageResult.NO;
        }
        return resultType;
    }

    @Override
    public MessageResult showInfoMessage(Object message, String title) {
        AtomicReference<MessageResult> ref = new AtomicReference<MessageResult>(MessageResult.CANCEL);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initStyle(StageStyle.UNDECORATED);
            alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                alert.initOwner((Window)this.stage);
            }
            alert.setTitle(title);
            alert.setHeaderText(message.toString());
            Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
            btOk.setText(Confis.get().getString("accept", new Object[0]));
            Optional result = alert.showAndWait();
            ref.set(this.translateResult(result));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    @Override
    public MessageResult showErrorMessage(Object message, String title) {
        AtomicReference<MessageResult> ref = new AtomicReference<MessageResult>(MessageResult.CANCEL);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initStyle(StageStyle.UNDECORATED);
            alert.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                alert.initOwner((Window)this.stage);
            }
            alert.setHeaderText(message.toString());
            alert.setTitle(title);
            Button btOk = (Button)alert.getDialogPane().lookupButton(ButtonType.OK);
            btOk.setText(Confis.get().getString("accept", new Object[0]));
            Optional result = alert.showAndWait();
            ref.set(this.translateResult(result));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    public String showChoiceMsg(String header, List<String> choices, int select) {
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            ChoiceDialog dialog = new ChoiceDialog(choices.isEmpty() || select >= choices.size() ? null : (String)choices.get(select), (Collection)choices);
            dialog.initStyle(StageStyle.UNDECORATED);
            dialog.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                dialog.initOwner((Window)this.stage);
            }
            dialog.setHeaderText(header);
            Button btOk = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
            btOk.setText(Confis.get().getString("accept", new Object[0]));
            Button btCancel = (Button)dialog.getDialogPane().lookupButton(ButtonType.CANCEL);
            btCancel.setText(Confis.get().getString("cancel", new Object[0]));
            Optional result = dialog.showAndWait();
            ref.set(((String)result.get()));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    public String showInputTextMsg(String header, String defaultValue) {
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            TextInputDialog dialog = new TextInputDialog(defaultValue);
            dialog.initStyle(StageStyle.UNDECORATED);
            dialog.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                dialog.initOwner((Window)this.stage);
            }
            dialog.setHeaderText(header);
            Button btOk = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
            btOk.setText(Confis.get().getString("accept", new Object[0]));
            Button btCancel = (Button)dialog.getDialogPane().lookupButton(ButtonType.CANCEL);
            btCancel.setText(Confis.get().getString("cancel", new Object[0]));
            Optional result = dialog.showAndWait();
            ref.set(((String)result.get()));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    public String showPasswordTextMsg(String header, String defaultValue) {
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            Dialog dialog = new Dialog();
            dialog.initStyle(StageStyle.UNDECORATED);
            dialog.getDialogPane().setStyle("-fx-border-color: black;-fx-border-width: 1.0;");
            if (this.stage != null && this.stage.isShowing()) {
                dialog.initOwner((Window)this.stage);
            }
            dialog.setHeaderText(header);
            Image arg0 = new Image(ClassLoader.getSystemClassLoader().getResourceAsStream("images/login-icon.jpg"));
            ImageView view = new ImageView(arg0);
            dialog.setGraphic((Node)view);
            ButtonType btAccept = new ButtonType(Confis.get().getString("accept", new Object[0]), ButtonBar.ButtonData.OK_DONE);
            ButtonType btCancel = new ButtonType(Confis.get().getString("cancel", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
            dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{btAccept, btCancel});
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
            PasswordField password = new PasswordField();
            password.setPromptText("Password");
            grid.add((Node)password, 1, 1);
            Node loginButton = dialog.getDialogPane().lookupButton(btAccept);
            loginButton.setDisable(true);
            password.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
            dialog.getDialogPane().setContent((Node)grid);
            Platform.runLater(() -> password.requestFocus());
            dialog.setResultConverter(dialogButton -> {
                if (dialogButton == btAccept) {
                    return password.getText();
                }
                return null;
            });
            Optional result = dialog.showAndWait();
            ref.set(((String)result.get()));
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ref.get();
    }

    public static class Test
    extends Application {
        static MessageFxController controller;

        public void start(Stage stage) throws Exception {
            controller = new MessageFxController(stage);
            new Thread(() -> {
                controller.showErrorMessage("Hello", "title");
                System.out.println("OK");
            }).start();
        }

        public static void main(String[] args) {
            Test.launch((String[])args);
        }
    }
}

