/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard.controller;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.dto.PrivateKeyLogin;
import com.anf.cryptotoken.ui.keyboard.KeyBoardConfig;
import com.anf.cryptotoken.ui.keyboard.behaviour.KeyBoardBehaviour;
import com.anf.cryptotoken.ui.keyboard.controller.HelpController;
import com.anf.cryptotoken.ui.keyboard.keys.ExtendedKey;
import com.anf.cryptotoken.ui.keyboard.keys.KeyController;
import com.anf.cryptotoken.ui.keyboard.keys.KeySetGenerator;
import com.anf.cryptotoken.ui.keyboard.password.PasswordPolicy;
import com.anf.cryptotoken.ui.keyboard.password.PasswordValidation;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.utils.Sound;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class KeyBoardController<RESULT>
implements KeyController {
    private static final Logger log = Logger.getLogger(KeyBoardController.class);
    @FXML
    private StackPane stackPane;
    @FXML
    private GridPane grid;
    @FXML
    private GridPane keyGrid;
    @FXML
    private HBox topKeyBox;
    @FXML
    private HBox centerKeyBox;
    @FXML
    private HBox bottomKeyBox;
    @FXML
    private Label titleLabel;
    @FXML
    private VBox centerPanel;
    @FXML
    private Label centerText;
    @FXML
    private HBox actionsBox;
    @FXML
    private HBox pinBox;
    @FXML
    private HBox pinLeftBox;
    @FXML
    private Label passLabel;
    @FXML
    private PasswordField passwordField;
    @FXML
    private HBox pinRightBox;
    @FXML
    private Label mainTitleLabel;
    @FXML
    private HBox helpBox;
    @FXML
    private HBox soundBox;
    @FXML
    private HBox closeBox;
    @FXML
    private GridPane passwordBox;
    private KeySetGenerator generator;
    private boolean letters = true;
    private boolean upperCase = false;
    private Stage stage;
    private KeyBoardConfig conf;
    private String cssUrl = ClassLoader.getSystemClassLoader().getResource("com/anf/cryptotoken/ui/keyboard/css/keyboard.css").toExternalForm();
    JFXDialog dialog;
    Label messageText;
    JFXDialog helpDialog;
    JFXDialogLayout helpDialogLayout;
    HelpController help;
    private ExecutorService actionService = Executors.newSingleThreadExecutor();
    private boolean showPassword = false;
    private boolean playSound;
    private Runnable onCLose;
    private Consumer<Void> resetPasswordEventHandler;
    private KeyBoardBehaviour<RESULT> keyBoardBehaviour;
    private LoginResult<RESULT> result;
    private Sound sound;
    private StackPane progress;

    private Sound getSound() throws IOException {
        if (this.sound == null) {
            this.sound = new Sound("/sounds/tecladoTerminate.wav", true);
        }
        return this.sound;
    }

    @FXML
    private void initialize() {
        log.debug((Object)("keyboard instance " + this));
        this.grid.setDisable(false);
        this.stackPane.setStyle("-fx-background-color: rgba(238, 238, 238, 0.0); -fx-background-radius: 20;");
        this.centerPanel.setStyle("-fx-background-radius: 20 20 20 20;  -fx-border-color: transparent; -fx-border-radius: 20 20 20 20; -fx-background-color: rgba(255, 255, 255, 1.0); ");
        this.centerText.setStyle("-fx-border-color: transparent; -fx-border-radius: 20; -fx-background-color: rgba(255, 255, 255, 0.0); -fx-background-radius: 20pt;");
        this.centerText.setFont(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)18.0));
        this.centerText.setTextFill((Paint)Color.BLACK);
        this.grid.setStyle("-fx-background-color: rgba(238, 238, 238, 1.0); -fx-background-radius: 20;");
        this.grid.setEffect((Effect)new DropShadow(BlurType.THREE_PASS_BOX, Color.GRAY, 10.0, 0.0, 0.0, 5.0));
        this.generator = new KeySetGenerator(this, this.topKeyBox, this.centerKeyBox, this.bottomKeyBox, this.actionsBox);
        if (this.letters) {
            this.generator.switchLetters(this.upperCase);
        } else {
            this.generator.switchNumbers();
        }
        this.generator.createPinSection(this.pinLeftBox, this.pinRightBox, this.pinBox);
        this.generator.createTopSection(this.soundBox, this.helpBox, this.closeBox);
        ExtendedKey lettersSwitcher = this.generator.getLettersSwitcher();
        lettersSwitcher.setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.generator.switchLetters(this.onSwitchCase())));
        ExtendedKey numSymbolsSwitcher = this.generator.getNumSymbolsSwitcher();
        numSymbolsSwitcher.setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.generator.switchNumbers()));
        this.generator.getCloseKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            this.conf.clearPassword();
            this.close();
        }));
        this.generator.getLetterKeys().forEach(key -> key.setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.addCharacter(key.getCharacter()))));
        this.generator.getLetterUpperCaseKeys().forEach(key -> key.setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.addCharacter(key.getCharacter()))));
        this.generator.getNumberAndSymbolKeys().forEach(key -> key.setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.addCharacter(key.getCharacter()))));
        this.generator.getSpace().setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.addCharacter(' ')));
        this.generator.getDeleteKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.backSpace()));
        this.generator.getShowPinKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            this.showPassword = !this.showPassword;
            this.passwordField.setText(this.passwordField.getText());
        }));
        TextFieldSkin skin = new TextFieldSkin((TextField)this.passwordField){

            protected String maskText(String txt) {
                return KeyBoardController.this.showPassword ? txt : super.maskText(txt);
            }
        };
        this.passwordField.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.onAcceptAction();
            }
            if (event.getText() != null && !event.getText().isEmpty()) {
                log.debug((Object)("keyboard released key: " + event.getText()));
            } else {
                log.debug((Object)("keyboard released key: " + event.getCode().getName()));
            }
        });
        this.passwordField.setSkin((Skin)skin);
        this.generator.getActionKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            log.info((Object)"accept button clicked");
            this.onAcceptAction();
        }));
        this.generator.getReturnKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (this.resetPasswordEventHandler != null) {
                this.resetPasswordEventHandler.accept(null);
            } else {
                this.setFirstPassword();
            }
        }));
        this.generator.getHelpKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.showHelpMessage(this.conf.getTextConf().getHelp())));
        this.passwordField.getStylesheets().add((Object)this.cssUrl);
        this.passwordField.getStyleClass().add((Object)"password-field");
        this.passwordBox.getStylesheets().add((Object)this.cssUrl);
        this.passwordBox.getStyleClass().add((Object)"password-box");
        this.mainTitleLabel.getStylesheets().add((Object)this.cssUrl);
        this.mainTitleLabel.getStyleClass().add((Object)"main-title");
        this.titleLabel.getStylesheets().add((Object)this.cssUrl);
        this.titleLabel.getStyleClass().add((Object)"title-label");
        this.generator.getReturnKey().getButton().setDisable(this.resetPasswordEventHandler == null);
        this.generator.getSoundKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            this.playSound = !this.playSound;
            this.saveSoundConfig(this.playSound);
            this.generator.getSoundKey().getButton().setOpacity(this.playSound ? 1.0 : 0.25);
        }));
        this.playSound = this.loadSoundConfig();
        this.generator.getSoundKey().getButton().setOpacity(this.playSound ? 1.0 : 0.25);
        this.progress = this.createProgressPane();
    }

    private void backSpace() {
        if (!this.passwordField.getText().isEmpty()) {
            this.passwordField.setText(this.passwordField.getText().substring(0, this.passwordField.getText().length() - 1));
        }
    }

    private void addCharacter(char character) {
        this.passwordField.setText(this.passwordField.getText() + character);
    }

    private void playAcceptSound() {
        if (this.playSound) {
            new Thread(() -> {
                try {
                    this.getSound().playSound();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }, "sound window terminar").start();
        }
    }

    private boolean loadSoundConfig() {
        File dir = new File(System.getProperty("user.home"), "anf");
        File soundConfigFile = new File(dir, "sound.cfg");
        if (soundConfigFile.exists()) {
            boolean bl;
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(soundConfigFile);
            try {
                props.load(in);
                String active = props.getProperty("sound");
                bl = active != null && active.equals("true");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            in.close();
            return bl;
        }
        return true;
    }

    private boolean saveSoundConfig(boolean playSound) {
        File dir = new File(System.getProperty("user.home"), "anf");
        File soundFile = new File(dir, "sound.cfg");
        dir.mkdirs();
        Properties props = new Properties();
        props.setProperty("sound", "" + playSound);
        try (FileOutputStream out = new FileOutputStream(soundFile);){
            props.store(out, null);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return true;
    }

    private void showHelpMessage(String message) {
        if (this.helpDialog == null) {
            this.createHelpDialog(message);
        } else {
            try {
                this.help.init(message, this.conf.getLang());
            }
            catch (Exception e) {
                this.helpDialogLayout.setBody(new Node[]{new Text(message)});
                JFXButton button = new JFXButton(this.conf.getString("accept", new Object[0]));
                button.setEffect((Effect)new DropShadow(BlurType.THREE_PASS_BOX, Color.GRAY, 10.0, 0.0, 0.0, 5.0));
                this.helpDialogLayout.setActions(new Node[]{button});
            }
        }
        this.helpDialog.show();
    }

    private void createHelpDialog(String message) {
        JFXButton button;
        this.helpDialogLayout = new JFXDialogLayout();
        try {
            URL resource = ClassLoader.getSystemClassLoader().getResource("com/anf/cryptotoken/ui/keyboard/views/help.fxml");
            FXMLLoader loader = new FXMLLoader(resource);
            Parent content = (Parent)loader.load();
            this.help = (HelpController)loader.getController();
            this.help.init(message, this.conf.getLang());
            button = this.help.getAcceptBtn();
            this.helpDialogLayout.setBody(new Node[]{content});
        }
        catch (IOException e) {
            log.error((Object)e);
            this.helpDialogLayout.setBody(new Node[]{new Text(message)});
            button = new JFXButton(this.conf.getString("accept", new Object[0]));
            button.setEffect((Effect)new DropShadow(BlurType.THREE_PASS_BOX, Color.GRAY, 10.0, 0.0, 0.0, 5.0));
            this.helpDialogLayout.setActions(new Node[]{button});
        }
        this.helpDialog = new JFXDialog(this.stackPane, (Region)this.helpDialogLayout, JFXDialog.DialogTransition.CENTER);
        button.setOnAction(event -> {
            this.helpDialog.close();
            this.focusPassword();
        });
        this.helpDialog.setOpacity(0.0);
        this.helpDialog.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.helpDialog.setStyle("-fx-background-color: TRANSPARENT; -fx-background-radius: 25pt; -fx-border-radius: 15; ");
    }

    public void focusPassword() {
        this.passwordField.requestFocus();
    }

    public void setFirstPassword() {
        if (this.conf.isConfirm() && this.conf.isConfirming()) {
            this.conf.getCurrent().setPassword(this.passwordField.getText());
            this.passwordField.setText(null);
            this.passwordField.setText(this.conf.firstContainer().getPassword());
            this.passwordField.selectPositionCaret(this.passwordField.getText().length());
            this.generator.getShowPinKey().getButton().setDisable(this.conf.getCurrent().getPassword().isEmpty());
            this.generator.getReturnKey().getButton().setDisable(true);
        }
    }

    private void onAcceptAction() {
        log.info((Object)"keyboard accept");
        String password = this.passwordField.getText();
        if (password == null || password.isEmpty()) {
            log.info((Object)"password null or empty");
            this.showMessage(this.conf.getTextConf().getPassEmpty());
            return;
        }
        if (this.validateCurrentPassword(password)) {
            this.conf.getCurrent().setPassword(password);
            boolean close = false;
            close = this.conf.isConfirm() ? this.confirm(password) : this.conf.checkPassword();
            log.info((Object)("keyboard close " + close));
            if (close) {
                this.doLoginAction();
            }
        }
    }

    private boolean confirm(String password) {
        boolean close = false;
        if (!this.conf.isConfirming()) {
            this.generator.getShowPinKey().getButton().setDisable(password.isEmpty());
            this.generator.getReturnKey().getButton().setDisable(false);
            this.passwordField.setText(this.conf.confirmContainer().getPassword());
        } else {
            this.conf.confirmContainer().setPassword(password);
            if (this.conf.checkPassword()) {
                close = true;
            } else {
                this.showMessage(this.conf.getTextConf().getPassDontMatch());
            }
        }
        return close;
    }

    private boolean validateCurrentPassword(String password) {
        boolean valid;
        boolean bl = valid = !this.conf.isValidate();
        if (!valid) {
            log.info((Object)"validando password PasswordPolicy.validatePassword:");
            PasswordValidation validation = PasswordPolicy.validatePassword(password);
            valid = validation.isValid();
            log.info((Object)("PasswordPolicy.validatePassword:" + valid));
            if (!valid) {
                this.showMessage(this.conf.getString(validation.getError(), this.conf.getTextConf().getPassLabel(), 8));
            }
        }
        return valid;
    }

    private void doLoginAction() {
        this.stackPane.getChildren().add((Object)this.progress);
        this.grid.setDisable(true);
        this.actionService.execute(() -> {
            this.playAcceptSound();
            if (this.keyBoardBehaviour != null) {
                try {
                    char[] pin = this.conf.getCurrent().getPassword().toCharArray();
                    boolean res = this.keyBoardBehaviour.accept(new PrivateKeyLogin(pin), message -> Platform.runLater(() -> {
                        this.grid.setDisable(false);
                        this.showMessage((String)message);
                    }));
                    log.info((Object)("keyboard accept keyboard behaviour result: " + res));
                    this.result = this.keyBoardBehaviour.getResult();
                    if (res) {
                        this.close();
                    }
                }
                finally {
                    Platform.runLater(() -> this.stackPane.getChildren().remove((Object)this.progress));
                }
            }
        });
    }

    public StackPane createProgressPane() {
        ProgressIndicator indicator = new ProgressIndicator();
        int size = 60;
        indicator.setMinHeight((double)size);
        indicator.setMinWidth((double)size);
        indicator.setPrefSize((double)size, (double)size);
        indicator.setMaxHeight((double)size);
        indicator.setMaxWidth((double)size);
        indicator.setStyle("-fx-progress-color: black;");
        StackPane pane = new StackPane();
        pane.setAlignment(Pos.CENTER);
        pane.setStyle("-fx-background-color: transparent;");
        pane.getChildren().add((Object)indicator);
        return pane;
    }

    private void showMessage(String msg) {
        this.grid.setDisable(true);
        if (this.dialog == null) {
            this.createDialog();
        }
        this.messageText.setText(msg);
        this.dialog.show();
    }

    private void createDialog() {
        JFXDialogLayout dialogLayout = new JFXDialogLayout();
        this.dialog = new JFXDialog(this.stackPane, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER, false);
        Consumer<Event> closer = event -> {
            this.grid.setDisable(false);
            this.dialog.close();
            this.focusPassword();
        };
        this.dialog.setOnKeyReleased(event -> {
            KeyCode code = event.getCode();
            if (code == KeyCode.ESCAPE) {
                closer.accept(event);
            }
        });
        this.dialog.setDisable(false);
        HBox box = new HBox(20.0);
        box.setAlignment(Pos.CENTER_RIGHT);
        this.messageText = new Label("");
        box.getChildren().add((Object)this.messageText);
        this.messageText.getStylesheets().add((Object)this.cssUrl);
        this.messageText.getStyleClass().add((Object)"message");
        ExtendedKey closeKey = this.generator.createCloseKey();
        closeKey.setAction((EventHandler<ActionEvent>)((EventHandler)closer::accept));
        box.getChildren().add((Object)closeKey.getButton());
        dialogLayout.setBody(new Node[]{box});
        this.dialog.setOpacity(0.0);
        this.dialog.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.dialog.setStyle("-fx-background-color: TRANSPARENT; -fx-background-radius: 25pt; -fx-border-radius: 15; ");
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        this.generator.getCloseKey().setAction((EventHandler<ActionEvent>)((EventHandler)event -> this.close()));
    }

    private void close() {
        log.info((Object)"keyboard close");
        this.closeDialogs();
        Platform.runLater(() -> ((Stage)this.stage).close());
        this.onCLose.run();
    }

    public StackPane getStackPane() {
        return this.stackPane;
    }

    public void setStackPane(StackPane stackPane) {
        this.stackPane = stackPane;
    }

    public GridPane getGrid() {
        return this.grid;
    }

    public void setGrid(GridPane grid) {
        this.grid = grid;
    }

    public GridPane getKeyGrid() {
        return this.keyGrid;
    }

    public void setKeyGrid(GridPane keyGrid) {
        this.keyGrid = keyGrid;
    }

    public HBox getTopKeyBox() {
        return this.topKeyBox;
    }

    public void setTopKeyBox(HBox topKeyBox) {
        this.topKeyBox = topKeyBox;
    }

    public HBox getCenterKeyBox() {
        return this.centerKeyBox;
    }

    public void setCenterKeyBox(HBox centerKeyBox) {
        this.centerKeyBox = centerKeyBox;
    }

    public HBox getBottomKeyBox() {
        return this.bottomKeyBox;
    }

    public void setBottomKeyBox(HBox bottomKeyBox) {
        this.bottomKeyBox = bottomKeyBox;
    }

    @Override
    public boolean onSwitchCase() {
        if (this.letters) {
            this.upperCase = !this.upperCase;
        }
        return this.upperCase;
    }

    @Override
    public boolean onSwitchLettersAndNumbers() {
        this.letters = false;
        return this.letters;
    }

    public void setConfig(KeyBoardConfig conf) {
        this.conf = conf;
        this.mainTitleLabel.setText(conf.getString("keyboard.title", new Object[0]));
        this.generator.getActionKey().setText(conf.getString("keyboard.accept", new Object[0]));
        this.passLabel.setText(conf.getTextConf().getPassLabel());
        this.passwordField.setPromptText(conf.getTextConf().getPassFieldPrompt());
        if (!conf.isShowCenterPanel()) {
            RowConstraints row = (RowConstraints)this.grid.getRowConstraints().get(3);
            row.setMaxHeight(0.0);
            row.setMinHeight(0.0);
            row.setPrefHeight(0.0);
            this.centerPanel.setVisible(false);
        } else {
            int finalCert;
            RowConstraints row = (RowConstraints)this.grid.getRowConstraints().get(3);
            row.setMinHeight(170.0);
            row.setPrefHeight(170.0);
            this.centerPanel.setVisible(true);
            X509Certificate[] chain = conf.getCertificates();
            if (conf.isShowCenterPanel() && chain != null && (finalCert = CertUtils.getFinalCert((X509Certificate[])chain)) != -1) {
                X509Certificate cert = chain[finalCert];
                this.centerText.setText(this.generateText(cert));
            }
        }
    }

    private String generateText(X509Certificate cert) {
        DatosPersonales dp = new DatosPersonales(cert.getSubjectX500Principal());
        Object cn = dp.getCN();
        if (cn == null) {
            cn = dp.getGIVENNAME();
            cn = cn == null ? dp.getSURNAME() : (String)cn + dp.getSURNAME();
        }
        String type = dp.getOU();
        String nameLabel = this.conf.getTextConf().getCertNameLabel();
        return nameLabel + "\n" + (String)cn + "\n" + type;
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setOnClose(Runnable exec) {
        this.onCLose = exec;
    }

    public void setResetPasswordEventHandler(Consumer<Void> resetPasswordEventHandler) {
        this.resetPasswordEventHandler = resetPasswordEventHandler;
        this.generator.getReturnKey().getButton().setDisable(resetPasswordEventHandler == null);
    }

    public LoginResult<RESULT> getResult() {
        return this.result;
    }

    public void setKeyBoardBehaviour(KeyBoardBehaviour<RESULT> keyBoardBehaviour) {
        this.keyBoardBehaviour = keyBoardBehaviour;
    }

    public void clear() {
        this.result = null;
        this.setTitle("");
        this.passwordField.clear();
        this.showPassword = false;
        this.closeDialogs();
        this.grid.setDisable(false);
        this.stackPane.getChildren().remove((Object)this.progress);
    }

    private void closeDialogs() {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.grid.setDisable(false);
            this.dialog.close();
            this.passwordField.setText("");
            this.focusPassword();
        }
        if (this.helpDialog != null && this.helpDialog.isVisible()) {
            this.helpDialog.close();
        }
    }
}

