/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.ui.keyboard.KeyBoardConfig;
import com.anf.cryptotoken.ui.keyboard.TimeoutThread;
import com.anf.cryptotoken.ui.keyboard.behaviour.KeyBoardBehaviour;
import com.anf.cryptotoken.ui.keyboard.controller.KeyBoardController;
import com.anf.javafx.wrapper.JavaFxFacade;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class StageHandler {
    private static final Logger log = Logger.getLogger(StageHandler.class);
    private boolean alwaysOnTop = true;
    static final double WIDTH = 741.0;
    static final double HEIGHT = 750.0;
    private double xOffset;
    private double yOffset;
    private Stage primaryStage;
    private static final Background TRANSPARENT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)});
    private URL fxmlResource;
    private FXMLLoader loader = new FXMLLoader();
    private Parent root;
    private Stage stage;
    private Scene scene;
    private TimeoutThread closeTimeout;

    public StageHandler() throws IOException {
        this.fxmlResource = ClassLoader.getSystemClassLoader().getResource("com/anf/cryptotoken/ui/keyboard/views/keyboard.fxml");
        this.loader.setLocation(this.fxmlResource);
        this.closeTimeout = new TimeoutThread("anfct keyboard close", () -> Platform.runLater(() -> {
            if (this.stage != null && this.stage.isShowing()) {
                this.stage.close();
            }
        }));
        this.closeTimeout.start();
    }

    public <RESULT> LoginResult<RESULT> showStage(Stage ps, KeyBoardConfig conf, AtomicReference<Stage> stageContainer, CountDownLatch latch, KeyBoardBehaviour<RESULT> boardBehaviour) {
        try {
            KeyBoardController controller = null;
            this.root = (Parent)this.loader.getRoot();
            if (this.root == null) {
                this.root = (Parent)this.loader.load();
                this.stage = new Stage();
                this.stage.initOwner((Window)ps);
                this.stage.initStyle(StageStyle.TRANSPARENT);
                this.stage.setAlwaysOnTop(this.alwaysOnTop);
                this.stage.centerOnScreen();
                ReadOnlyObjectProperty sceneChaged = this.stage.sceneProperty();
                InvalidationListener mouseDragListener = sceneListener -> {
                    Scene scene = (Scene)sceneChaged.getValue();
                    scene.setOnMousePressed(event -> {
                        this.xOffset = this.stage.getX() - event.getScreenX();
                        this.yOffset = this.stage.getY() - event.getScreenY();
                    });
                    scene.setOnMouseDragged(event -> {
                        this.stage.setX(event.getScreenX() + this.xOffset);
                        this.stage.setY(event.getScreenY() + this.yOffset);
                    });
                    scene.setFill((Paint)Color.TRANSPARENT);
                    scene.getRoot().setStyle("-fx-background-color: rgba(255, 255, 255, 0); -fx-background-radius: 20; -fx-border-radius: 20; ");
                    ((StackPane)scene.getRoot()).setBackground(TRANSPARENT_BACKGROUND);
                    ((StackPane)scene.getRoot()).applyCss();
                    new Thread(() -> Platform.runLater(() -> {
                        this.stage.setOpacity(1.0);
                        this.stage.setMinWidth(scene.getWidth());
                        this.stage.setMinHeight(scene.getHeight());
                    })).start();
                    System.out.println("scene loaded");
                };
                sceneChaged.addListener(mouseDragListener);
                controller = (KeyBoardController)this.loader.getController();
                controller.setStage(this.stage);
                this.scene = new Scene(this.root, 741.0, 750.0);
                this.stage.setScene(this.scene);
                this.stage.setResizable(true);
            } else {
                controller = (KeyBoardController)this.loader.getController();
                controller.clear();
            }
            stageContainer.set(this.stage);
            controller.setConfig(conf);
            controller.setTitle(conf.getTitle());
            controller.setOnClose(() -> latch.countDown());
            controller.setKeyBoardBehaviour(boardBehaviour);
            if (conf.getResetPasswordEventHandler() != null) {
                controller.setResetPasswordEventHandler(conf.getResetPasswordEventHandler());
            }
            this.stage.setTitle(conf.getTitle());
            controller.focusPassword();
            double realW = 741.0;
            double realH = 750.0;
            if (!conf.isShowCenterPanel()) {
                realH -= 170.0;
            }
            this.stage.setHeight(realH);
            this.stage.setWidth(realW);
            this.closeTimeout.setCloseDate(TimeUnit.MINUTES.toSeconds(5L));
            this.stage.showAndWait();
            this.closeTimeout.cancel();
            return boardBehaviour != null ? boardBehaviour.getResult() : null;
        }
        catch (Exception e) {
            log.error((Object)e);
            return new LoginResult(e);
        }
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public <RESULT> LoginResult<RESULT> show(KeyBoardConfig conf, KeyBoardBehaviour<RESULT> boardBehaviour) {
        conf.reset();
        System.gc();
        AtomicReference<LoginResult> result = new AtomicReference<LoginResult>();
        AtomicReference<Object> stageContainer = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        boolean fxThread = Platform.isFxApplicationThread();
        if (this.primaryStage != null) {
            if (fxThread) {
                result.set(this.showStage(this.primaryStage, conf, stageContainer, latch, boardBehaviour));
            } else {
                Platform.runLater(() -> {
                    result.set(this.showStage(this.primaryStage, conf, stageContainer, latch, boardBehaviour));
                    latch.countDown();
                });
                try {
                    latch.await(5L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                if (result.get() == null) {
                    result.set(new LoginResult(new TimeoutException()));
                }
            }
        } else {
            result.set((LoginResult)JavaFxFacade.execute((boolean)false, primaryStageArg -> {
                primaryStageArg.setAlwaysOnTop(this.alwaysOnTop);
                return this.showStage((Stage)primaryStageArg, conf, (AtomicReference<Stage>)stageContainer, latch, boardBehaviour);
            }));
        }
        if (boardBehaviour != null && boardBehaviour.restartOnClose()) {
            return this.show(conf, boardBehaviour);
        }
        return boardBehaviour != null ? boardBehaviour.getResult() : null;
    }
}

