/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.keyboard;

import com.anf.cryptotoken.ui.keyboard.KeyBoardLang;

public class KeyBoardTextConfig {
    private String passLabel;
    private String passFieldPrompt;
    private String passDontMatch;
    private String passEmpty;
    private String passLength;
    private String passInvalid;
    private String certNameLabel;
    private String help;

    public KeyBoardTextConfig() {
        this.passLabel = "PIN:";
        this.passFieldPrompt = "PIN";
        this.passDontMatch = "los passwords no coinciden";
        this.passEmpty = "debe introducir un password";
        this.passLength = "el pass debe tener 8 digitos";
        this.passInvalid = "el pass es invalido";
        this.certNameLabel = "Titular del certificado:";
    }

    public KeyBoardTextConfig(String passLabel, String passFieldPrompt, String passDontMatch, String passEmpty, String passLength, String passInvalid, String certNameLabel, String help) {
        this.passLabel = passLabel;
        this.passFieldPrompt = passFieldPrompt;
        this.passDontMatch = passDontMatch;
        this.passEmpty = passEmpty;
        this.passLength = passLength;
        this.passInvalid = passInvalid;
        this.certNameLabel = certNameLabel;
        this.help = help;
    }

    public static KeyBoardTextConfig createPINConfig(KeyBoardLang lang) {
        return new KeyBoardTextConfig(lang.getString("246", new Object[0]), lang.getString("247", new Object[0]), lang.getString("PINnoMatch", new Object[0]), lang.getString("PINempty", new Object[0]), lang.getString("PINlength", new Object[0]), lang.getString("PINinvalid", new Object[0]), lang.getString("titular", new Object[0]), lang.getString("default.pin.help", new Object[0]));
    }

    public static KeyBoardTextConfig createPUKConfig(KeyBoardLang lang) {
        return new KeyBoardTextConfig(lang.getString("246-PUK", new Object[0]), lang.getString("247-PUK", new Object[0]), lang.getString("PUKnoMatch", new Object[0]), lang.getString("PUKempty", new Object[0]), lang.getString("PUKlength", new Object[0]), lang.getString("PUKinvalid", new Object[0]), lang.getString("titular", new Object[0]), lang.getString("default.puk.help", new Object[0]));
    }

    public static KeyBoardTextConfig createSMSConfig(KeyBoardLang lang) {
        return new KeyBoardTextConfig(lang.getString("sms", new Object[0]), lang.getString("smscode", new Object[0]), lang.getString("PINnoMatch", new Object[0]), lang.getString("PINempty", new Object[0]), lang.getString("PINlength", new Object[0]), lang.getString("PINinvalid", new Object[0]), lang.getString("titular", new Object[0]), lang.getString("default.sms.help", new Object[0]));
    }

    public String getPassLabel() {
        return this.passLabel;
    }

    public String getPassFieldPrompt() {
        return this.passFieldPrompt;
    }

    public String getPassDontMatch() {
        return this.passDontMatch;
    }

    public String getPassEmpty() {
        return this.passEmpty;
    }

    public String getPassLength(int minLength) {
        return String.format(this.passLength, minLength);
    }

    public String getPassInvalid(int minLength) {
        return String.format(this.passInvalid, minLength);
    }

    public String getCertNameLabel() {
        return this.certNameLabel;
    }

    public void setCertNameLabel(String certNameLabel) {
        this.certNameLabel = certNameLabel;
    }

    public String getHelp() {
        return this.help;
    }

    public String getPassLength() {
        return this.passLength;
    }

    public void setPassLength(String passLength) {
        this.passLength = passLength;
    }

    public String getPassInvalid() {
        return this.passInvalid;
    }

    public void setPassInvalid(String passInvalid) {
        this.passInvalid = passInvalid;
    }

    public void setPassLabel(String passLabel) {
        this.passLabel = passLabel;
    }

    public void setPassFieldPrompt(String passFieldPrompt) {
        this.passFieldPrompt = passFieldPrompt;
    }

    public void setPassDontMatch(String passDontMatch) {
        this.passDontMatch = passDontMatch;
    }

    public void setPassEmpty(String passEmpty) {
        this.passEmpty = passEmpty;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void clear() {
        this.certNameLabel = "";
        this.help = "";
        this.passDontMatch = "";
        this.passEmpty = "";
        this.passFieldPrompt = "";
        this.passInvalid = "";
        this.passLabel = "";
        this.passLength = "";
    }
}

