/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ui.image;

import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.util.LinkedList;
import java.util.TreeSet;

public class ControlImages
extends Component
implements Runnable {
    private static final Logger log = Logger.getLogger(ControlImages.class);
    Image defImg = this.loadImage("icon_anf.png", this);
    String waitDir = "teclado/";
    LinkedList<String> waitList = new LinkedList();
    public static volatile boolean end = false;
    static final int MAX = 500;
    private static String[] names = new String[0];
    TreeSet<String> onlyInCache = new TreeSet();
    public LinkedList<Pair> cache = new LinkedList();
    private static ControlImages instance;

    private ControlImages() {
        Thread thread = new Thread((Runnable)this, "ANFCT Images");
        thread.setDaemon(true);
        thread.start();
        for (String name : names) {
            this.cache.add(new Pair(name, this.getImage(name, this)));
        }
    }

    public static ControlImages get() {
        if (instance == null) {
            instance = new ControlImages();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name, Component cmp) {
        Image ii;
        Image img = null;
        img = ii = this.getCachedImage(name);
        boolean n = false;
        if (img != null) {
            n = true;
            return img;
        }
        boolean b = false;
        ControlImages controlImages = this;
        synchronized (controlImages) {
            b = this.onlyInCache.isEmpty() || this.onlyInCache.contains(name);
        }
        if (b) {
            img = this.loadImage(name, this);
        }
        controlImages = this;
        synchronized (controlImages) {
            boolean bl = b = this.onlyInCache.isEmpty() || this.onlyInCache.contains(name);
            if (b && this.getCachedImage(name) == null) {
                if (this.cache.size() > 500) {
                    this.cache.removeFirst();
                }
                this.cache.addLast(new Pair(name, img));
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCachedImage(String name) {
        if (this.cache != null) {
            ControlImages controlImages = this;
            synchronized (controlImages) {
                for (Pair p : this.cache) {
                    if (!p.name.equals(name)) continue;
                    return p.img;
                }
            }
        }
        return null;
    }

    public Image loadImage(String name, Component cmp) {
        URL fileLoc = Thread.currentThread().getContextClassLoader().getResource("images/" + name);
        Image img = cmp.getToolkit().createImage(fileLoc);
        MediaTracker tracker = new MediaTracker(cmp);
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
            if (tracker.isErrorAny()) {
                log.info((Object)(Confis.get().getString("250", new Object[0]) + name));
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!end && !end && Thread.activeCount() > 2) {
            while (!this.waitList.isEmpty()) {
                String src;
                ControlImages controlImages = this;
                synchronized (controlImages) {
                    src = this.waitList.removeFirst();
                }
                log.info((Object)(Confis.get().getString("251", new Object[0]) + src));
                Image img = this.loadImage(src, this);
                ControlImages controlImages2 = this;
                synchronized (controlImages2) {
                    if (this.cache.size() > 500) {
                        this.cache.removeFirst();
                    }
                    this.cache.addLast(new Pair(src, img));
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    public Image getDefImg() {
        return this.defImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ControlImages controlImages = this;
        synchronized (controlImages) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOnlyInCache() {
        ControlImages controlImages = this;
        synchronized (controlImages) {
            this.onlyInCache.clear();
        }
    }

    static class Pair {
        String name;
        Image img = null;

        public Pair(String name, Image img) {
            this.name = name;
            this.img = img;
        }

        public String toString() {
            return this.name;
        }
    }
}

