/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.WindowsCertUtilException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ui.tray.TrayIconNotificationHandler;
import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class WindowsCertUtil {
    private static final Logger log = Logger.getLogger(WindowsCertUtil.class);
    public static final int ON_USB_EXTRACTION = 0;
    public static final int ON_WINDOWS_LOAD = 1;

    public static void eraseAsyncMiddlewareSmartCardCertificates(List<X509Certificate> removeCerts, int processType, boolean forced) {
        Thread daemon = new Thread(() -> WindowsCertUtil.deleteWrongWindowsCerts(removeCerts, processType, forced), "WINDOWS-STORE-UPDATE");
        daemon.setDaemon(true);
        daemon.start();
    }

    public static void eraseMiddlewareSmartCardCertificates(boolean forced) {
        WindowsCertUtil.deleteWrongWindowsCerts(null, 1, forced);
    }

    private static void deleteWrongWindowsCerts(List<X509Certificate> removeCerts, int processType, boolean forced) {
        WindowsCertUtil.listWindowsCerts(processType, true, forced, cert -> {
            boolean checkHash = WindowsCertUtil.findMatch(cert.hash, removeCerts);
            if (checkHash || cert.anf && (forced && (cert.error || cert.smartCard) || cert.error && cert.smartCard)) {
                try {
                    log.info((Object)("cert con error: " + cert.cn));
                    log.info((Object)("cert con hash : " + cert.hash));
                    String execute = WindowsCertUtil.execute("certutil -delstore -user -Silent \"My\" \"" + cert.hash + "\"", null);
                    log.info((Object)execute);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            return false;
        });
    }

    private static String listWindowsCerts(int processType, boolean forced, Object object) {
        return null;
    }

    public static void listWindowsCerts() {
        WindowsCertUtil.listWindowsCerts(1, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listWindowsCerts(int processType, boolean showTrayIcon, boolean forced, Function<CertLines, Boolean> certAction) {
        long startTime = System.nanoTime();
        TrayIconNotificationHandler icon = null;
        if (showTrayIcon) {
            icon = WindowsCertUtil.getTrayIcon(processType);
        }
        try (LockerImpl locker = LockerImpl.get((String)"windows");){
            if (showTrayIcon) {
                icon.displayTray();
            }
            String command = "certutil -v -store -privateKey -Silent -user \"My\"";
            List<String> lines = WindowsCertUtil.executeGetLines(command);
            ArrayList<CertLines> certs = new ArrayList<CertLines>();
            CertLines current = null;
            for (int i = 0; i < lines.size(); ++i) {
                if (lines.get(i).trim().startsWith("================")) {
                    if (current != null) {
                        certs.add(current);
                    }
                    current = new CertLines();
                }
                if (current == null) continue;
                current.lines.add(lines.get(i));
            }
            if (current != null) {
                certs.add(current);
            }
            int[] c = new int[]{0};
            certs.forEach(cert -> {
                boolean anf = false;
                boolean err = false;
                boolean smartcard = false;
                String cn = null;
                String hash = null;
                String alias = null;
                int li = 0;
                for (String l : cert.lines) {
                    if (l.contains("anf.es")) {
                        anf = true;
                    } else if (WindowsCertUtil.testWrongCipherTest(l)) {
                        err = true;
                    } else {
                        String pattern = "CN=";
                        String trim = l.trim();
                        if (l.contains(pattern)) {
                            cn = trim.substring(trim.indexOf(pattern) + pattern.length());
                        } else if (l.contains("Microsoft Base Smart Card Crypto Provider")) {
                            smartcard = true;
                        } else if (l.toUpperCase().contains("CERT_FRIENDLY_NAME_PROP_ID") && li + 1 < cert.lines.size()) {
                            String next = cert.lines.get(li + 1);
                            alias = next.trim();
                        } else {
                            String low = trim.toUpperCase();
                            if (low.contains("CERT_SHA1_HASH_PROP_ID") && li + 1 < cert.lines.size()) {
                                String next = cert.lines.get(li + 1);
                                hash = next.trim();
                            }
                        }
                    }
                    if (anf && err && smartcard) break;
                    ++li;
                }
                cert.cn = cn;
                cert.hash = hash;
                cert.smartCard = smartcard;
                cert.error = err;
                cert.anf = anf;
                cert.alias = alias;
                if (certAction != null && ((Boolean)certAction.apply((CertLines)cert)).booleanValue()) {
                    c[0] = c[0] + 1;
                }
            });
            System.out.println("certificados con problema:" + c[0]);
            if (showTrayIcon) {
                String end = Confis.get().getString("end-windows-update-message", new Object[0]);
                icon.setMessage(end);
                icon.displayTray();
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        finally {
            log.info((Object)("procesados los certificados de windows en " + (double)(System.nanoTime() - startTime) / 1000000.0 + " ms"));
        }
    }

    private static boolean findMatch(String hash, List<X509Certificate> removeCerts) {
        if (removeCerts != null && !removeCerts.isEmpty() && hash != null) {
            try {
                byte[] matchHash = Hex.decode((String)hash);
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                if (removeCerts != null) {
                    for (X509Certificate cert : removeCerts) {
                        try {
                            byte[] encoded = cert.getEncoded();
                            byte[] certHash = digest.digest(encoded);
                            if (!Arrays.areEqual((byte[])matchHash, (byte[])certHash)) continue;
                            return true;
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    private static TrayIconNotificationHandler getTrayIcon(int processType) {
        Confis cfg = Confis.get();
        String title = cfg.getString("anfac", new Object[0]);
        String start = "";
        switch (processType) {
            case 0: {
                start = cfg.getString("start-windows-usb-extract-message", new Object[0]);
                break;
            }
            case 1: {
                start = cfg.getString("start-windows-update-message", new Object[0]);
            }
        }
        return new TrayIconNotificationHandler("ANF AC", "", title, start, TrayIcon.MessageType.INFO);
    }

    private static boolean testWrongCipherTest(String line) {
        Locale locale = Locale.getDefault();
        switch (locale.getLanguage()) {
            case "es": {
                return line.toLowerCase().contains("Prueba de cifrado err".toLowerCase()) || line.toLowerCase().contains("Falta el conjunto de claves almacenado".toLowerCase());
            }
            case "en": {
                return line.toLowerCase().contains("Encryption test FAILED".toLowerCase()) || line.toLowerCase().contains("The stored keyset is missing".toLowerCase());
            }
            case "fr": {
                return line.toLowerCase().contains("test de chiffrement".toLowerCase()) && line.toLowerCase().contains("mauvais".toLowerCase()) || line.toLowerCase().contains("Le jeu de cl\u00e9s stock\u00e9 est manquant".toLowerCase());
            }
            case "de": {
                return line.toLowerCase().contains("Verschl\u00fcsselungstest".toLowerCase()) && line.toLowerCase().contains("Falsch".toLowerCase()) || line.toLowerCase().contains("Der gespeicherte Schl\u00fcsselsatz fehlt".toLowerCase());
            }
            case "it": {
                return line.toLowerCase().contains("Test di crittografia".toLowerCase()) && line.toLowerCase().contains("errato".toLowerCase()) || line.toLowerCase().contains("Manca il set di chiavi memorizzato".toLowerCase());
            }
        }
        return false;
    }

    private static List<String> executeGetLines(String command) throws IOException, InterruptedException {
        ArrayList<String> lines = new ArrayList<String>();
        WindowsCertUtil.execute(command, line -> lines.add((String)line));
        return lines;
    }

    private static <R> String execute(String command, Consumer<String> onLineRead) throws IOException, InterruptedException {
        StringBuffer sb = new StringBuffer();
        Process p = Runtime.getRuntime().exec(command);
        InputStream stream = p.getInputStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, Charset.forName("ISO-8859-1")));
        boolean exited = false;
        int attempts = 0;
        while (true) {
            String line;
            if ((line = input.readLine()) != null) {
                sb.append(line).append("\n");
                if (onLineRead == null) continue;
                onLineRead.accept(line);
                continue;
            }
            exited = p.waitFor(3L, TimeUnit.SECONDS);
            if (!exited) {
                ++attempts;
            }
            if (exited || attempts >= 10) break;
        }
        input.close();
        String out = sb.toString();
        return out;
    }

    public static void main(String[] args) {
        WindowsCertUtil.listWindowsCerts();
    }

    public static void importUserCertificate(X509Certificate cert) {
        File tmp = new File(Files.anf(), cert.getSerialNumber().toString() + ".cer");
        try {
            try (FileOutputStream out = new FileOutputStream(tmp);){
                IOUtils.write((byte[])cert.getEncoded(), (OutputStream)out);
            }
            String output = WindowsCertUtil.execute("certutil.exe -addstore -f \"MY\" \"" + tmp.getCanonicalPath() + "\"", null);
            if (output.contains("error")) {
                throw new IOException(output);
            }
        }
        catch (Exception e) {
            throw new WindowsCertUtilException((Throwable)e);
        }
        finally {
            tmp.delete();
        }
    }

    public static void checkIfDisconnectedSmartCardCertificates(boolean showTrayIcon) {
        AtomicInteger count = new AtomicInteger(0);
        WindowsCertUtil.listWindowsCerts(1, showTrayIcon, false, cert -> {
            if (cert.anf && cert.error && cert.smartCard) {
                count.incrementAndGet();
                return true;
            }
            return false;
        });
        if (count.get() > 0) {
            throw new ANFCertificateException("ERR_SCARD_DISCONNECTED_CERTIFICATE");
        }
    }

    public static List<String> filterAliases(Enumeration<String> aliases) {
        TreeSet<String> aliasSet = new TreeSet<String>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            aliasSet.add(alias);
        }
        ArrayList<String> filtered = new ArrayList<String>();
        WindowsCertUtil.listWindowsCerts(1, false, false, cert -> {
            if (!cert.smartCard) {
                if (cert.alias != null && aliasSet.contains(cert.alias)) {
                    return filtered.add(cert.alias);
                }
                if (cert.cn != null && aliasSet.contains(cert.cn)) {
                    return filtered.add(cert.cn);
                }
            }
            return false;
        });
        return filtered;
    }

    static class CertLines {
        public boolean anf;
        public boolean error;
        List<String> lines = new ArrayList<String>();
        String cn;
        String hash;
        boolean smartCard;
        public String alias;

        CertLines() {
        }
    }
}

