/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cryptotoken.api.tkmanager.exception.WindowsCertUtilException;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.utils.Crypt32;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.tkmanager.utils.WindowCertFunctions;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.sun.jna.platform.win32.WinCrypt;
import java.io.IOException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.encoders.Hex;

public class WindowsCertChecker {
    public static final int CERT_FRIENDLY_NAME_PROP_ID = 11;
    private static final Logger log = Logger.getLogger(WindowsCertChecker.class);

    public static int removeDisconnectedWindowsCertificates() throws IOException {
        return WindowsCertChecker.removeDisconnectedWindowsCertificates(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeDisconnectedWindowsCertificates(Set<String> serials, boolean deleteSmartCardCerts) throws IOException {
        int deleted = 0;
        try (LockerImpl locker = WindowsCertChecker.getLocker().acquireLock();){
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            WinCrypt.HCERTSTORE certStore = WindowCertFunctions.openCertStore();
            try {
                WinCrypt.CERT_CONTEXT.ByReference signCertContext = null;
                while ((signCertContext = WindowsCertChecker.readNextSignCertContext(certStore, signCertContext)) != null) {
                    WinCrypt.CRYPT_KEY_PROV_INFO provider;
                    boolean smartCardProvider;
                    String serialNumber;
                    boolean delete = true;
                    if (serials != null && !serials.isEmpty() && serials.contains(serialNumber = WindowCertFunctions.getSerialNumber(signCertContext)) && WindowCertFunctions.delete(signCertContext)) {
                        log.info((Object)("eliminado cert con serial " + serialNumber));
                        ++deleted;
                        signCertContext = null;
                        delete = false;
                    }
                    if (!deleteSmartCardCerts || !delete || !(smartCardProvider = WindowsCertChecker.isSmartCardProvider(provider = WindowCertFunctions.getProvider(signCertContext)))) continue;
                    boolean result = WindowCertFunctions.sign(null, signCertContext);
                    log.info((Object)(" result of windows signature:" + result));
                    if (result) continue;
                    log.info((Object)"deleting windows certificate");
                    if (!WindowCertFunctions.delete(signCertContext)) continue;
                    ++deleted;
                    signCertContext = null;
                }
            }
            finally {
                WindowCertFunctions.closeCertStore(certStore);
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return deleted;
    }

    private static WinCrypt.CERT_CONTEXT.ByReference readNextSignCertContext(WinCrypt.HCERTSTORE certStore, WinCrypt.CERT_CONTEXT.ByReference signCertContext) {
        try {
            return Crypt32.INSTANCE.CertEnumCertificatesInStore(certStore, signCertContext);
        }
        catch (Throwable e) {
            log.info((Object)"reintentando lectura de proximo SignCertContext");
            return Crypt32.INSTANCE.CertEnumCertificatesInStore(certStore, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> filterWindowsCertificates(Set<String> aliases, boolean includeCSPAlias, boolean removeDisconnected) throws IOException {
        TreeSet<String> filtered = new TreeSet<String>();
        try (LockerImpl locker = WindowsCertChecker.getLocker().acquireLock();){
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            WinCrypt.HCERTSTORE certStore = WindowCertFunctions.openCertStore();
            try {
                WinCrypt.CERT_CONTEXT.ByReference signCertContext = null;
                while ((signCertContext = WindowsCertChecker.readNextSignCertContext(certStore, signCertContext)) != null) {
                    WinCrypt.CRYPT_KEY_PROV_INFO provider = WindowCertFunctions.getProvider(signCertContext);
                    boolean smartCardProvider = WindowsCertChecker.isSmartCardProvider(provider);
                    String alias = null;
                    if (smartCardProvider) {
                        alias = provider.pwszContainerName;
                    }
                    if (alias == null) {
                        alias = WindowCertFunctions.getProperty(signCertContext, 11);
                    }
                    if (alias != null && filtered.contains(alias)) continue;
                    log.info((Object)("probando windows alias: " + alias));
                    boolean result = !smartCardProvider || WindowCertFunctions.sign(alias, signCertContext);
                    log.info((Object)(" result of windows signature:" + result + " " + alias));
                    if (result) {
                        X500Name name;
                        boolean accepted = false;
                        boolean useCN = false;
                        log.info((Object)(" alias:" + alias));
                        if (alias != null && (!smartCardProvider || includeCSPAlias) && (aliases == null || aliases.isEmpty() || aliases.contains(alias))) {
                            accepted = filtered.add(alias);
                        } else if (smartCardProvider) {
                            if (includeCSPAlias) {
                                useCN = true;
                            }
                        } else if (alias == null) {
                            useCN = true;
                            log.info((Object)"usando CN porque no tiene alias");
                        }
                        if (useCN && (name = WindowCertFunctions.getSubject(signCertContext)) != null) {
                            DatosPersonales dp = new DatosPersonales(name);
                            String cn = dp.getCN();
                            log.info((Object)(" alias cn:" + cn));
                            if (cn != null && (aliases == null || aliases.isEmpty() || aliases.contains(cn))) {
                                accepted = filtered.add(cn);
                            }
                        }
                        if (accepted) continue;
                        log.info((Object)("alias ignored: " + alias + " provider: " + (provider != null ? provider.pwszProvName : "")));
                        continue;
                    }
                    if (removeDisconnected) {
                        if (!smartCardProvider) continue;
                        if (WindowCertFunctions.delete(signCertContext)) {
                            signCertContext = null;
                            continue;
                        }
                        throw new WindowsCertUtilException("ERR_DISCONNECTED_SMART_CARD");
                    }
                    throw new WindowsCertUtilException("ERR_DISCONNECTED_SMART_CARD");
                }
            }
            finally {
                WindowCertFunctions.closeCertStore(certStore);
            }
        }
        return filtered;
    }

    private static boolean isSmartCardProvider(WinCrypt.CRYPT_KEY_PROV_INFO provider) {
        if (provider == null || provider.pwszProvName == null) {
            return false;
        }
        if (provider.pwszProvName.contains("Smart Card")) {
            return true;
        }
        return !provider.pwszProvName.contains("Microsoft") || !provider.pwszProvName.contains("Cryptographic Provider") && !provider.pwszProvName.contains("Key Storage Provider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> testListCerts() throws IOException {
        TreeSet<String> filtered = new TreeSet<String>();
        try (LockerImpl locker = WindowsCertChecker.getLocker().acquireLock();){
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            WinCrypt.HCERTSTORE certStore = WindowCertFunctions.openCertStore();
            try {
                WinCrypt.CERT_CONTEXT.ByReference signCertContext = null;
                while ((signCertContext = WindowsCertChecker.readNextSignCertContext(certStore, signCertContext)) != null) {
                    X509Certificate[] chain = WindowCertFunctions.getCertChain(signCertContext);
                    for (int i = 0; i < chain.length; ++i) {
                        System.out.println(chain[i].getSerialNumber());
                    }
                    try {
                        byte[] data = "test".getBytes();
                        byte[] encrypt = WindowCertFunctions.encrypt(signCertContext, data);
                        System.out.println(Hex.toHexString((byte[])encrypt));
                        String id = PKCSObjectIdentifiers.sha256WithRSAEncryption.getId();
                        byte[] signedData = WindowCertFunctions.sign(signCertContext, id, data);
                        CMSSignedData cms = new CMSSignedData(signedData);
                        signedData = ((SignerInformation)cms.getSignerInfos().iterator().next()).getSignature();
                        UtilsPki.verifyData(data, signedData, chain[0].getPublicKey(), "SHA256withRSA", Security.getProvider("BC"));
                    }
                    catch (IOException | SignatureException | CMSException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                WindowCertFunctions.closeCertStore(certStore);
            }
        }
        return filtered;
    }

    public static void main(String[] args) throws Throwable {
        AgregarProveedor.agregarBouncyCastleProvider();
        List<String> list = Arrays.asList(new String[0]);
        while (true) {
            try {
                WindowsCertChecker.removeDisconnectedWindowsCertificates();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            finally {
                TimeUnit.SECONDS.sleep(2L);
                continue;
            }
            break;
        }
    }

    public static LockerImpl getLocker() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > 2) {
            System.out.println("trying acquire lock from " + stack[2].getClassName() + ":" + stack[2].getMethodName());
        }
        return LockerImpl.get((String)"windows.store");
    }
}

