/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.utils.Crypt32;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Crypt32Util;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinCrypt;
import com.sun.jna.platform.win32.WinCryptUtil;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;

public class WindowCertFunctions {
    private static final Logger log = Logger.getLogger(WindowCertFunctions.class);
    private static final int CRYPT_SILENT = 64;
    public static final String message1String = "test";
    public static final Memory signChallenge = new Memory((long)(("test".length() + 1) * Native.WCHAR_SIZE));

    public static boolean delete(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            boolean bl = Crypt32.INSTANCE.CertDeleteCertificateFromStore(signCertContext);
            return bl;
        }
    }

    public static WinCrypt.HCERTSTORE openCertStore() throws IOException {
        WinCrypt.HCERTSTORE certStore = null;
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            System.out.println("abriendo windows cert store");
            certStore = Crypt32.INSTANCE.CertOpenSystemStore(Pointer.NULL, "MY");
            System.out.println("windows cert store abierta");
        }
        return certStore;
    }

    public static void closeCertStore(WinCrypt.HCERTSTORE certStore) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            Crypt32.INSTANCE.CertCloseStore(certStore, 0);
        }
    }

    public static void closeCertContextList(List<WinCrypt.CERT_CONTEXT.ByReference> contextList) {
        if (contextList != null) {
            for (WinCrypt.CERT_CONTEXT.ByReference certContext : contextList) {
                try {
                    Crypt32.INSTANCE.CertFreeCertificateContext((WinCrypt.CERT_CONTEXT)certContext);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public static List<WinCrypt.CERT_CONTEXT.ByReference> listCertContexts(WinCrypt.HCERTSTORE certStore) {
        WinCrypt.CERT_CONTEXT.ByReference prev = null;
        boolean end = false;
        ArrayList<WinCrypt.CERT_CONTEXT.ByReference> contextList = new ArrayList<WinCrypt.CERT_CONTEXT.ByReference>();
        while (!end) {
            try {
                WinCrypt.CERT_CONTEXT.ByReference signCertContext = WindowCertFunctions.getCertContext(certStore, prev);
                end = signCertContext == null;
                if (end) continue;
                prev = signCertContext;
                contextList.add(signCertContext);
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
        return contextList;
    }

    public static WinCrypt.CERT_CONTEXT.ByReference getCertContext(WinCrypt.HCERTSTORE certStore, WinCrypt.CERT_CONTEXT.ByReference prev) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.CERT_CONTEXT.ByReference signCertContext = null;
            Pointer searchCriteria = new WTypes.LPWSTR("a").getPointer();
            WinCrypt.CERT_CONTEXT.ByReference byReference = signCertContext = Crypt32.INSTANCE.CertFindCertificateInStore(certStore, 65537, 0, 524295, searchCriteria, (WinCrypt.CERT_CONTEXT)prev);
            return byReference;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean sign(String alias, WinCrypt.CERT_CONTEXT.ByReference signCertContextTestSign) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] sign(WinCrypt.CERT_CONTEXT.ByReference signCertContextTestSign, String hashAlgorithm, byte[] data) throws IOException, SignatureException {
        WinCryptUtil.MANAGED_CRYPT_SIGN_MESSAGE_PARA sigParams = new WinCryptUtil.MANAGED_CRYPT_SIGN_MESSAGE_PARA();
        sigParams.dwMsgEncodingType = 65537;
        sigParams.pSigningCert = signCertContextTestSign;
        sigParams.HashAlgorithm.pszObjId = hashAlgorithm;
        sigParams.HashAlgorithm.Parameters.cbData = 0;
        sigParams.cMsgCert = 1;
        sigParams.rgpMsgCert = signCertContextTestSign.getPointer();
        sigParams.cAuthAttr = 0;
        sigParams.dwInnerContentType = 0;
        sigParams.cMsgCrl = 0;
        sigParams.cUnauthAttr = 0;
        sigParams.dwFlags = 0;
        sigParams.pvHashAuxInfo = null;
        sigParams.rgAuthAttr = null;
        sigParams.setRgpMsgCert(new WinCrypt.CERT_CONTEXT[]{signCertContextTestSign});
        sigParams.dwFlags = 64;
        Memory signChallenge = new Memory((long)data.length);
        signChallenge.write(0L, data, 0, data.length);
        Memory signedDataPointer = new Memory(10240L);
        Pointer[] rgpbToBeSigned = new Pointer[]{signChallenge};
        int[] rgcbToBeSigned = new int[]{(int)signChallenge.size()};
        IntByReference pcbSignedBlob1 = new IntByReference(0);
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            boolean result = Crypt32.INSTANCE.CryptSignMessage((WinCrypt.CRYPT_SIGN_MESSAGE_PARA)sigParams, false, rgpbToBeSigned.length, rgpbToBeSigned, rgcbToBeSigned, Pointer.NULL, pcbSignedBlob1);
            if (result) {
                result = Crypt32.INSTANCE.CryptSignMessage((WinCrypt.CRYPT_SIGN_MESSAGE_PARA)sigParams, false, rgpbToBeSigned.length, rgpbToBeSigned, rgcbToBeSigned, (Pointer)signedDataPointer, pcbSignedBlob1);
                byte[] signedData = new byte[pcbSignedBlob1.getValue()];
                signedDataPointer.read(0L, signedData, 0, signedData.length);
                byte[] byArray = signedData;
                return byArray;
            }
            throw new SignatureException("ERR_WINDOWS_SIGN");
        }
    }

    public static byte[] encrypt(WinCrypt.CERT_CONTEXT.ByReference signCertContextTestSign, byte[] data) throws IOException, SignatureException {
        WinCrypt.DATA_BLOB outDataPointer = new WinCrypt.DATA_BLOB();
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.DATA_BLOB pDataIn = new WinCrypt.DATA_BLOB(data);
            boolean result = Crypt32.INSTANCE.CryptProtectData(pDataIn, null, null, Pointer.NULL, null, 0, outDataPointer);
            if (result) {
                byte[] encrypted = new byte[outDataPointer.cbData];
                outDataPointer.pbData.read(0L, encrypted, 0, encrypted.length);
                byte[] byArray = encrypted;
                return byArray;
            }
            throw new SignatureException("ERR_WINDOWS_ENCRYPT");
        }
    }

    public static byte[] decrypt(WinCrypt.CERT_CONTEXT.ByReference signCertContextTestSign, byte[] data) throws IOException, SignatureException {
        WinCrypt.DATA_BLOB outDataPointer = new WinCrypt.DATA_BLOB();
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.DATA_BLOB pDataIn = new WinCrypt.DATA_BLOB(data);
            boolean result = Crypt32.INSTANCE.CryptUnprotectData(pDataIn, null, null, Pointer.NULL, null, 0, outDataPointer);
            if (result) {
                byte[] encrypted = new byte[outDataPointer.cbData];
                outDataPointer.pbData.read(0L, encrypted, 0, encrypted.length);
                byte[] byArray = encrypted;
                return byArray;
            }
            throw new SignatureException("ERR_WINDOWS_ENCRYPT");
        }
    }

    public static X509Certificate[] getCertChain(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.CERT_CHAIN_ELEMENT[] element = WindowCertFunctions.getCertChainElements(signCertContext);
            if (element.length > 0) {
                X509Certificate[] chain = new X509Certificate[element.length];
                for (int i = 0; i < chain.length; ++i) {
                    WinCrypt.CERT_CHAIN_ELEMENT certElem = element[i];
                    chain[i] = WindowCertFunctions.getCert(certElem);
                }
                X509Certificate[] x509CertificateArray = chain;
                return x509CertificateArray;
            }
        }
        return null;
    }

    private static X509Certificate getCert(WinCrypt.CERT_CHAIN_ELEMENT certElem) {
        byte[] encoded = new byte[certElem.pCertContext.cbCertEncoded];
        certElem.pCertContext.pbCertEncoded.read(0L, encoded, 0, encoded.length);
        X509Certificate cert = CertUtils.getCert((InputStream)new ByteArrayInputStream(encoded));
        return cert;
    }

    public static WinCrypt.CERT_CHAIN_ELEMENT[] getCertChainElements(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.CERT_CHAIN_PARA pChainPara = new WinCrypt.CERT_CHAIN_PARA();
            pChainPara.cbSize = pChainPara.size();
            pChainPara.RequestedUsage.dwType = 0;
            pChainPara.RequestedUsage.Usage.cUsageIdentifier = 0;
            pChainPara.RequestedUsage.Usage.rgpszUsageIdentifier = null;
            PointerByReference pbr = new PointerByReference();
            boolean status = Crypt32.INSTANCE.CertGetCertificateChain(null, (WinCrypt.CERT_CONTEXT)signCertContext, null, null, pChainPara, 0, null, pbr);
            WinCrypt.CERT_CHAIN_CONTEXT pChainContext = (WinCrypt.CERT_CHAIN_CONTEXT)Structure.newInstance(WinCrypt.CERT_CHAIN_CONTEXT.class, (Pointer)pbr.getValue());
            pChainContext.read();
            if (pChainContext.cChain > 0) {
                WinCrypt.CERT_CHAIN_ELEMENT[] chain;
                Pointer[] chainPointers = new Pointer[pChainContext.cChain];
                pChainContext.rgpChain.read(0L, chainPointers, 0, chainPointers.length);
                WinCrypt.CERT_SIMPLE_CHAIN csc = (WinCrypt.CERT_SIMPLE_CHAIN)Structure.newInstance(WinCrypt.CERT_SIMPLE_CHAIN.class, (Pointer)chainPointers[0]);
                csc.read();
                WinCrypt.CERT_CHAIN_ELEMENT[] cERT_CHAIN_ELEMENTArray = chain = csc.getRgpElement();
                return cERT_CHAIN_ELEMENTArray;
            }
        }
        return null;
    }

    public static X500Name getSubject(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.CERT_CHAIN_ELEMENT[] element = WindowCertFunctions.getCertChainElements(signCertContext);
            if (element.length > 0) {
                X500Name name;
                WinCrypt.CERT_CHAIN_ELEMENT certElem = element[0];
                WinCrypt.DATA_BLOB subject = certElem.pCertContext.pCertInfo.Subject;
                String subjectName = Crypt32Util.CertNameToStr((int)1, (int)2, (WinCrypt.DATA_BLOB)subject);
                X500Name x500Name = name = new X500Name(subjectName);
                return x500Name;
            }
        }
        return null;
    }

    public static String getSerialNumber(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            WinCrypt.CERT_CHAIN_ELEMENT[] element = WindowCertFunctions.getCertChainElements(signCertContext);
            if (element.length > 0) {
                WinCrypt.CERT_CHAIN_ELEMENT certElem = element[0];
                String string = WindowCertFunctions.getCert(certElem).getSerialNumber().toString();
                return string;
            }
        }
        return null;
    }

    public static void listCertProperties(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        int dwPropId = 0;
        while ((dwPropId = Crypt32.INSTANCE.CertEnumCertificateContextProperties((WinCrypt.CERT_CONTEXT)signCertContext, dwPropId)) > 0) {
            if (dwPropId != 11) continue;
            String string = WindowCertFunctions.getProperty(signCertContext, dwPropId);
        }
    }

    public static String getProperty(WinCrypt.CERT_CONTEXT.ByReference signCertContext, int propId) throws IOException {
        String property = null;
        WinCrypt.DATA_BLOB ref = new WinCrypt.DATA_BLOB();
        WinDef.DWORDByReference intByRef = new WinDef.DWORDByReference();
        WinDef.DWORD dwPropId = new WinDef.DWORD((long)propId);
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            Memory propertyMemory;
            if (Crypt32.INSTANCE.CertGetCertificateContextProperty((WinCrypt.CERT_CONTEXT)signCertContext, dwPropId, null, intByRef) && Crypt32.INSTANCE.CertGetCertificateContextProperty((WinCrypt.CERT_CONTEXT)signCertContext, dwPropId, (Pointer)(propertyMemory = new Memory((long)((intByRef.getValue().intValue() + 1) * Native.WCHAR_SIZE))), intByRef)) {
                property = propertyMemory.getWideString(0L);
            }
            String string = property;
            return string;
        }
    }

    public static WinCrypt.CRYPT_KEY_PROV_INFO getProvider(WinCrypt.CERT_CONTEXT.ByReference signCertContext) throws IOException {
        WinDef.DWORDByReference intByRef = new WinDef.DWORDByReference();
        int propId = 2;
        WinDef.DWORD dwPropId = new WinDef.DWORD((long)propId);
        try (LockerImpl locker = WindowCertFunctions.getLocker().acquireLock();){
            Memory propertyMemory;
            if (Crypt32.INSTANCE.CertGetCertificateContextProperty((WinCrypt.CERT_CONTEXT)signCertContext, dwPropId, null, intByRef) && Crypt32.INSTANCE.CertGetCertificateContextProperty((WinCrypt.CERT_CONTEXT)signCertContext, dwPropId, (Pointer)(propertyMemory = new Memory((long)((intByRef.getValue().intValue() + 1) * Native.WCHAR_SIZE))), intByRef)) {
                WinCrypt.CRYPT_KEY_PROV_INFO prop = (WinCrypt.CRYPT_KEY_PROV_INFO)Structure.newInstance(WinCrypt.CRYPT_KEY_PROV_INFO.class, (Pointer)propertyMemory);
                prop.read();
                WinCrypt.CRYPT_KEY_PROV_INFO cRYPT_KEY_PROV_INFO = prop;
                return cRYPT_KEY_PROV_INFO;
            }
        }
        return null;
    }

    public static LockerImpl getLocker() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > 2) {
            System.out.println("trying acquire lock from " + stack[2].getClassName() + ":" + stack[2].getMethodName());
        }
        return LockerImpl.get((String)"windows.store");
    }

    private static /* synthetic */ Boolean lambda$sign$0(String alias, WinCryptUtil.MANAGED_CRYPT_SIGN_MESSAGE_PARA sigParams, Pointer[] rgpbToBeSigned, int[] rgcbToBeSigned, IntByReference pcbSignedBlob1) throws Exception {
        log.info((Object)("start CryptSignMessage alias " + alias));
        boolean result = Crypt32.INSTANCE.CryptSignMessage((WinCrypt.CRYPT_SIGN_MESSAGE_PARA)sigParams, false, rgpbToBeSigned.length, rgpbToBeSigned, rgcbToBeSigned, Pointer.NULL, pcbSignedBlob1);
        log.info((Object)("end CryptSignMessage alias " + alias + " result " + result));
        return result;
    }

    static {
        signChallenge.setWideString(0L, message1String);
    }
}

