/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.cryptotoken.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;

public class SunPKCS11Patch {
    private static final Logger log = Logger.getLogger(SunPKCS11Patch.class);

    public static void addAliasesToPKCS11Providers() {
        try {
            Method addAliasMethod = Provider.Service.class.getDeclaredMethod("addAlias", String.class);
            addAliasMethod.setAccessible(true);
            Method putServiceMethod = Provider.class.getDeclaredMethod("putService", Provider.Service.class);
            putServiceMethod.setAccessible(true);
            Provider[] providers = Security.getProviders();
            for (int i = 0; i < providers.length; ++i) {
                Provider prov = providers[i];
                SunPKCS11Patch.addAliasesToPKCS11Provider(addAliasMethod, putServiceMethod, prov);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addAliasesToPKCS11Provider(Provider prov) {
        try {
            Method addAliasMethod = Provider.Service.class.getDeclaredMethod("addAlias", String.class);
            addAliasMethod.setAccessible(true);
            Method putServiceMethod = Provider.class.getDeclaredMethod("putService", Provider.Service.class);
            putServiceMethod.setAccessible(true);
            SunPKCS11Patch.addAliasesToPKCS11Provider(addAliasMethod, putServiceMethod, prov);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addAliasesToPKCS11Provider(Method addAliasMethod, Method putServiceMethod, Provider prov) throws IllegalAccessException, InvocationTargetException {
        if (prov.getName().startsWith("SunPKCS11-")) {
            try {
                Provider.Service serv = prov.getService("KeyAgreement", "DH");
                if (serv != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.3.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.3.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyFactory", "DSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.10040.4.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.10040.4.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyFactory", "RSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyFactory", "DH")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.3.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.3.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyGenerator", "DES")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.3.14.3.2.7");
                    addAliasMethod.invoke((Object)serv, "OID.1.3.14.3.2.7");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyPairGenerator", "DSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.10040.4.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.10040.4.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyPairGenerator", "RSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1");
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("KeyPairGenerator", "DH")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.3.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.3.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Mac", "HmacSHA1")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.2.7");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.2.7");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Mac", "HmacMD5")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.3.6.1.5.5.8.1.1");
                    addAliasMethod.invoke((Object)serv, "OID.1.3.6.1.5.5.8.1.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "MD2")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.2.2");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.2.2");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "MD5")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.2.5");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.2.5");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "SHA1")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.3.14.3.2.26");
                    addAliasMethod.invoke((Object)serv, "OID.1.3.14.3.2.26");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "SHA-256")) != null) {
                    addAliasMethod.invoke((Object)serv, "2.16.840.1.101.3.4.2.1");
                    addAliasMethod.invoke((Object)serv, "OID.2.16.840.1.101.3.4.2.1");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "SHA-384")) != null) {
                    addAliasMethod.invoke((Object)serv, "2.16.840.1.101.3.4.2.2");
                    addAliasMethod.invoke((Object)serv, "OID.2.16.840.1.101.3.4.2.2");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("MessageDigest", "SHA-512")) != null) {
                    addAliasMethod.invoke((Object)serv, "2.16.840.1.101.3.4.2.3");
                    addAliasMethod.invoke((Object)serv, "OID.2.16.840.1.101.3.4.2.3");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "DSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.10040.4.3");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.10040.4.3");
                    addAliasMethod.invoke((Object)serv, "1.3.14.3.2.13");
                    addAliasMethod.invoke((Object)serv, "OID.1.3.14.3.2.13");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "SHA1withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.5");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.5");
                    addAliasMethod.invoke((Object)serv, "1.3.14.3.2.29");
                    addAliasMethod.invoke((Object)serv, "OID.1.3.14.3.2.29");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "SHA256withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.11");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.11");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "SHA384withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.12");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.12");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "SHA512withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.13");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.13");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "MD2withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.2");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.2");
                    putServiceMethod.invoke((Object)prov, serv);
                }
                if ((serv = prov.getService("Signature", "MD5withRSA")) != null) {
                    addAliasMethod.invoke((Object)serv, "1.2.840.113549.1.1.4");
                    addAliasMethod.invoke((Object)serv, "OID.1.2.840.113549.1.1.4");
                    putServiceMethod.invoke((Object)prov, serv);
                }
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
    }
}

