/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class PfxGenerator {
    BouncyCastleProvider prov = new BouncyCastleProvider();

    public PfxGenerator() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        }
        if (provider instanceof BouncyCastleProvider) {
            BouncyCastleProvider p;
            this.prov = p = (BouncyCastleProvider)provider;
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException, CertificateException, KeyStoreException, IOException {
        PfxGenerator gen = new PfxGenerator();
        KeyPair keyPair = gen.generateKeyPair();
        X509Certificate cert = gen.generateCert(keyPair);
        File pfxFile = new File(FileUtils.getTempDirectory(), "self-signed-" + cert.getSerialNumber() + ".pfx");
        gen.generatePfx(keyPair.getPrivate(), cert, pfxFile, "1234");
        System.out.println(pfxFile);
    }

    public File generateTempPfx(PrivateKey key, X509Certificate cert, String pin) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        File pfxFile = new File(FileUtils.getTempDirectory(), "self-signed-" + cert.getSerialNumber() + ".pfx");
        this.generatePfx(key, cert, pfxFile, pin);
        return pfxFile;
    }

    public void generatePfx(PrivateKey key, X509Certificate cert, File pfxFile, String pin) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(null, pin.toCharArray());
        store.setKeyEntry("" + System.nanoTime(), key, pin.toCharArray(), new Certificate[]{cert});
        try (FileOutputStream stream = new FileOutputStream(pfxFile);){
            store.store(stream, pin.toCharArray());
        }
    }

    public X509Certificate generateCert(KeyPair keyPair) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateException, OperatorCreationException {
        X500Name name = new X500Name("CN=TEST,C=ES");
        Calendar cal = Calendar.getInstance();
        Date issue = cal.getTime();
        cal.add(1, 1);
        Date expiration = cal.getTime();
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(name, new BigInteger("" + System.nanoTime()), issue, expiration, name, info);
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256withRSA").setProvider((Provider)this.prov).build(keyPair.getPrivate());
        X509CertificateHolder certificateHolder = certificateBuilder.build(sigGen);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        return cert;
    }

    public KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }
}

