/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.utils;

import com.anf.firmas.jni.InitANFP11;
import com.anf.utils.SerialUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class HardDiskSerialNumberChanger {
    private String exeName = "VolumeId.exe";
    private String exePath = "";
    private String unit = "";

    public HardDiskSerialNumberChanger(String unit) throws IOException {
        this.exePath = new File("").getCanonicalPath();
        this.unit = unit;
    }

    public HardDiskSerialNumberChanger(String exePath, String exeName, String unit) throws IOException {
        this.exePath = exePath;
        this.exeName = exeName;
        this.unit = unit;
    }

    public HardDiskSerialNumberChanger(String exeName, String unit) throws IOException {
        this.exeName = exeName;
        this.unit = unit;
    }

    public void setExeName(String exeName) {
        this.exeName = exeName;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getExeName() {
        return this.exeName;
    }

    public String getExePath() {
        return this.exePath;
    }

    public boolean changeTo(String uuid) throws Throwable {
        return this.changeTo(this.unit, uuid);
    }

    public boolean changeTo(String unit, String uuid) throws Throwable {
        if (uuid != null && unit != null) {
            String serialNumber = SerialUtils.getUSBSerialNumber((String)unit);
            if (serialNumber == null) {
                throw new Exception("no se puede obtener el numero de serie de la unidad " + unit);
            }
            String command = "cmd /c \"" + new File(this.exePath, this.exeName).getCanonicalPath() + "\" -nobanner -accepteula " + unit + " " + uuid;
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor(1L, TimeUnit.MINUTES);
            String error = this.getErrorStream(p);
            if (!error.isEmpty()) {
                throw new Exception(error);
            }
            return p.exitValue() == 0;
        }
        return false;
    }

    private String getErrorStream(Process p) throws IOException {
        InputStream e = p.getErrorStream();
        int available = e.available();
        byte[] arr = new byte[available];
        e.read(arr, 0, available);
        String error = new String(arr);
        return error;
    }

    private String getInputStream(Process p) throws IOException {
        InputStream e = p.getInputStream();
        int available = e.available();
        byte[] arr = new byte[available];
        e.read(arr, 0, available);
        String error = new String(arr);
        return error;
    }

    public static void main(String[] args) throws Throwable {
        while (true) {
            boolean formatSlot = InitANFP11.get().formatSlot(0);
            System.out.println("slot formateado " + formatSlot);
            Thread.sleep(15000L);
            long t1 = System.nanoTime();
            String serialWindows = SerialUtils.getUSBSerialNumber((String)"H:\\");
            HardDiskSerialNumberChanger test = new HardDiskSerialNumberChanger("H:");
            Object randSerial = (int)(Math.random() * 1000.0) + 1000 + "-" + ((int)(Math.random() * 1000.0) + 1000);
            randSerial = ((String)randSerial).toUpperCase();
            System.out.println("cambiando a " + (String)randSerial);
            boolean changeTo = test.changeTo((String)randSerial);
            System.out.println(changeTo);
            System.out.println("tiempo dedicado a cambiar el numero de serie:" + (double)(System.nanoTime() - t1) / 1000000.0 + " milisegundos");
        }
    }
}

