/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;

public class CriticalAccesStore {
    private static final Logger log = Logger.getLogger(CriticalAccesStore.class);
    private File storePath;
    private KeyStore keystore;
    private char[] password;

    public CriticalAccesStore(File storePath, char[] password) {
        log.info((Object)("storePath:" + storePath.getAbsolutePath()));
        log.info((Object)("password" + new String(password)));
        try {
            this.storePath = storePath;
            this.password = password;
            this.keystore = KeyStore.getInstance("UBER", "BC");
            if (storePath.exists()) {
                RandomAccessFile randFile = new RandomAccessFile(storePath, "r");
                randFile.seek(12600L);
                int storeLength = randFile.readInt();
                if (storeLength == 0) {
                    this.keystore.load(null, null);
                } else {
                    byte[] data = new byte[storeLength];
                    randFile.readFully(data);
                    ByteArrayInputStream dataInput = new ByteArrayInputStream(data);
                    this.keystore.load(dataInput, password);
                }
                randFile.close();
            } else {
                this.keystore.load(null, null);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            log.error((Object)ex);
        }
    }

    public File getStorePath() {
        return this.storePath;
    }

    public void setStorePath(File storePath) {
        this.storePath = storePath;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public String toString() {
        return "CriticalAccesStore{storePath=" + this.storePath + ", keystore=" + this.keystore + ", password=" + this.password + "}";
    }
}

