/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token.detect.impl;

import com.anf.cryptotoken.api.thread.AsyncExecutor;
import com.anf.cryptotoken.json.TrayIconUserLogin;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.TrayIconClient;
import com.anf.cryptotoken.server.TrayIconNotificationWebSocketClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class TrayIconChangeDetector
implements AsyncExecutor {
    private static final Logger log = Logger.getLogger(TrayIconChangeDetector.class);
    private TrayIconUserLogin login = null;
    Thread thread;
    int sleepSeconds = 10;
    private boolean running = false;
    private boolean constantUpdate = false;
    private TrayIconNotificationWebSocketClient notificationClient;
    private Consumer<Void> onDisconnect = ignore -> {
        this.constantUpdate = true;
        this.startConstantDetect();
        executorService.execute(() -> {
            this.login = null;
            this.onUpdate(null);
        });
    };

    public void start() {
        try {
            log.info((Object)"tray icon change detector start");
            this.notificationClient = new TrayIconNotificationWebSocketClient(user -> this.onUpdate((String)user));
            this.constantUpdate = !this.notificationClient.connect(this.onDisconnect);
        }
        catch (Throwable e) {
            log.error((Object)"no esta corriendo el tray icon o no es la ultima version con websocket", e);
            this.constantUpdate = true;
        }
        this.startConstantDetect();
    }

    private void startConstantDetect() {
        if (this.constantUpdate) {
            this.thread = new Thread(this::updateChequer, "Tray Icon Service ANFCT");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChequer() {
        this.running = true;
        while (this.running) {
            try {
                boolean trayIconRunning;
                boolean update = false;
                TrayIconUserLogin newLogin = TrayIconClient.loginToLocalAuthServer();
                boolean bl = trayIconRunning = newLogin != null;
                if (trayIconRunning) {
                    newLogin = this.tryConnectWebSocket();
                }
                if (newLogin != null && newLogin.getUserId() != null && newLogin.getUserPassword() != null && (this.login == null || this.login.getUserId() == null || this.login.getUserPassword() == null)) {
                    update = true;
                } else if (!(this.login != null && this.login.IsLogin || newLogin != null && newLogin.isLogin())) {
                    update = false;
                } else if (!(newLogin == null || newLogin.getUserId() != null && this.login.getUserId().equals(newLogin.getUserId()) || newLogin.getUserPassword() != null && this.login.getUserPassword().equals(newLogin.getUserPassword()))) {
                    update = true;
                }
                if (!update) continue;
                this.login = newLogin;
                log.info((Object)("se ha actualizado las credenciales de centralizados con usuario " + this.login.getUserId()));
                this.onUpdate(this.login.getUserId());
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            finally {
                try {
                    if (!this.running) continue;
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private TrayIconUserLogin tryConnectWebSocket() {
        TrayIconUserLogin newLogin = null;
        try {
            log.info((Object)"intentando conectar por websocket");
            if (this.notificationClient.connect(this.onDisconnect)) {
                this.running = false;
                newLogin = TrayIconClient.loginToLocalAuthServer();
            }
        }
        catch (Throwable e1) {
            log.error((Object)"no esta corriendo el tray icon o no es la ultima version con websocket", e1);
        }
        return newLogin;
    }

    public abstract void onUpdate(String var1);
}

