/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token.detect.impl;

import com.anf.cryptotoken.api.token.SmartCardInfo;
import com.anf.cryptotoken.tkmanager.token.detect.ConstantUpdateHandler;
import com.anf.cryptotoken.tkmanager.token.detect.TokenDetector;
import com.anf.cryptotoken.tkmanager.token.detect.TokenDetectorClient;
import com.anf.cryptotoken.tkmanager.token.detect.impl.CardDetector;
import com.anf.cryptotoken.tkmanager.token.detect.impl.ConstantUpdater;
import com.anf.cryptotoken.tkmanager.token.detect.impl.TrayIconChangeDetector;
import com.anf.cryptotoken.tkmanager.token.detect.impl.USBDetector;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBControllerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TokenDetectorImpl
implements TokenDetector {
    private USBDetector usbd = new USBDetector(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetectUSB(List<File> usbs) {
            Object object = LOCK_USB;
            synchronized (object) {
                for (TokenDetectorClient tokenDetectorClient : clients) {
                    tokenDetectorClient.onUsbDetect(usbs);
                }
            }
        }
    };
    private CardDetector cardDetector = new CardDetector(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCardDetect(List<SmartCardInfo> cards) {
            Object object = LOCK_CARD;
            synchronized (object) {
                for (TokenDetectorClient tokenDetectorClient : clients) {
                    tokenDetectorClient.onCardDetect(cards);
                }
            }
        }
    };
    private TrayIconChangeDetector trayIconDetector = new TrayIconChangeDetector(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdate(String user) {
            Object object = LOCK_CENTRAL;
            synchronized (object) {
                for (TokenDetectorClient tokenDetectorClient : clients) {
                    tokenDetectorClient.onCentralCertDetect(user);
                }
            }
        }
    };
    private ConstantUpdater constantUpdater;
    private boolean constantDetect = false;
    private boolean usbDetect = false;
    private boolean cardDetect = false;
    private boolean trayIconDetect = false;
    private static List<TokenDetectorClient> clients = new ArrayList<TokenDetectorClient>();
    private static Object LOCK_USB = new Object();
    private static Object LOCK_CARD = new Object();
    private static Object LOCK_CENTRAL = new Object();

    @Override
    public void setConstantDetect(boolean constantDetect, ConstantUpdateHandler handler) {
        this.constantUpdater = new ConstantUpdater(handler);
        this.constantDetect = constantDetect;
        this.constantUpdater.setUpdate(constantDetect);
    }

    @Override
    public boolean isConstantDetect() {
        return this.constantDetect;
    }

    @Override
    public boolean isUpdating() {
        return this.constantDetect && this.constantUpdater.isUpdate();
    }

    @Override
    public void configure(boolean constantDetect, boolean usbDetect, boolean cardDetect, boolean trayIconDetect) {
        this.constantDetect = constantDetect;
        this.usbDetect = usbDetect;
        this.cardDetect = cardDetect;
        this.trayIconDetect = trayIconDetect;
    }

    @Override
    public void start() {
        this.startTrayIconDetect();
        if (!this.constantDetect) {
            this.startUsbDetect();
            this.startCardDetect();
        } else {
            this.constantUpdater.start();
        }
    }

    @Override
    public void startCardDetect() {
        if (this.cardDetect) {
            this.cardDetector.start();
        }
    }

    @Override
    public void startUsbDetect() {
        if (this.usbDetect) {
            this.usbd.start();
        }
    }

    @Override
    public void startTrayIconDetect() {
        if (this.trayIconDetect) {
            this.trayIconDetector.start();
        }
    }

    @Override
    public void stop() {
        if (!this.constantDetect) {
            this.usbd.stop();
            this.cardDetector.stop();
        } else {
            this.constantUpdater.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClient(TokenDetectorClient client) {
        Object object = LOCK_USB;
        synchronized (object) {
            Object object2 = LOCK_CARD;
            synchronized (object2) {
                clients.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClient(TokenDetectorClient client) {
        Object object = LOCK_USB;
        synchronized (object) {
            Object object2 = LOCK_CARD;
            synchronized (object2) {
                clients.remove(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRootClient(TokenDetectorClient client) {
        Object object = LOCK_USB;
        synchronized (object) {
            Object object2 = LOCK_CARD;
            synchronized (object2) {
                clients.add(0, client);
            }
        }
    }

    public static void main(String[] args) {
        new TokenDetectorImpl().start();
        System.out.println();
    }

    @Override
    public ArrayList<USB> listUSBs() {
        ArrayList usbs = new ArrayList();
        usbs = USBControllerFactory.getUSBController().getUSBUnits();
        return usbs;
    }

    @Override
    public CardDetector getCardDetector() {
        return this.cardDetector;
    }
}

