/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token.detect.impl;

import com.anf.cryptotoken.api.token.SmartCardInfo;
import com.anf.cryptotoken.config.AtrObject;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.jna.smartcardio.CardExceptionWrapper;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.tools.SCardServiceHandler;
import com.anf.jna.smartcardio.tools.SmartCardListService;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public abstract class CardDetector {
    private static final Logger log = LogManager.getLogger(CardDetector.class);
    public static final String protocol = "*";
    private List<SmartCardInfo> cardsConnected = null;
    private static final LockerImpl locker = LockerImpl.get((String)"smartCardDetector");
    private Thread thread;
    public static boolean detectHSMVault = true;
    private static Set<String> acceptedAtrs = new TreeSet<String>();
    private static Set<String> invalidAtrs = new TreeSet<String>();
    public boolean restartScardService = "true".equals(System.getProperty("restart.scard", "false"));
    private SmartCardListService cardListService;

    public void start() {
        this.thread = new Thread("Card Detector Service ANFCT"){

            @Override
            public void run() {
                try {
                    CardDetector.this.cardListService = new SmartCardListService();
                    while (true) {
                        CardDetector.this.cardDetectLoop();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return;
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cardDetectLoop() {
        List cards = null;
        try {
            block15: {
                try (LockerImpl lock = CardDetector.acquireLock();){
                    try {
                        if (SCardServiceHandler.isRunning()) {
                            log.debug("listando terminales de smart card");
                            cards = this.cardListService.listCards(this::checkCardATR, name -> !name.contains("ANF AC Token eSign"));
                            log.debug("smart cards: " + cards.size());
                            break block15;
                        }
                        if (this.restartScardService) {
                            this.startSCardService();
                            break block15;
                        }
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (CardExceptionWrapper e) {
                        this.handleCardError(e);
                    }
                    catch (Throwable e) {
                        log.error((Object)e);
                    }
                }
            }
            if (cards != null) {
                this.dispatchChange(this.transform(cards));
            }
        }
        catch (Throwable throwable) {
            if (cards != null) {
                this.dispatchChange(this.transform(cards));
            }
            this.cardListService.waitForChange();
            throw throwable;
        }
        this.cardListService.waitForChange();
    }

    private int startSCardService() {
        try (LockerImpl lock = CardDetector.acquireLock();){
            int n = SCardServiceHandler.start();
            return n;
        }
    }

    private List<SmartCardInfo> transform(List<JnaCard> cards) {
        return cards.stream().map(card -> new SmartCardInfo(Hex.toHexString((byte[])card.getATRWrapper().getBytes()), Confis.get().getAtrObject(card.getATRWrapper().getBytes()).getName())).toList();
    }

    private void handleCardError(CardExceptionWrapper e) {
        String error = e.getMessage();
        if (error != null && error.contains("SCARD_E_NO_READERS_AVAILABLE")) {
            log.debug("no hay lectores conectados");
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private void dispatchChange(List<SmartCardInfo> cards) {
        if (cards != null && (this.cardsConnected == null || this.cardsConnected.size() != cards.size())) {
            this.cardsConnected = cards;
            log.debug("tarjetas conectadas: {}", (Object)this.cardsConnected.size());
            this.cardsConnected.forEach(card -> log.debug("tarjeta conectada: {}", card));
            this.onCardDetect(this.cardsConnected);
        }
    }

    public boolean isCardConnected(PKCS11Type type) {
        return this.cardsConnected != null && this.cardsConnected.stream().anyMatch(card -> card.getName().equals(type.name()));
    }

    public static LockerImpl acquireLock() {
        return locker.acquireLock();
    }

    public abstract void onCardDetect(List<SmartCardInfo> var1);

    public void stop() {
        this.thread.interrupt();
    }

    private static boolean isHSM(AtrObject atrObj) {
        return atrObj.getName().contains("VaultIC");
    }

    private boolean checkCardATR(byte[] atr) {
        boolean accepted = false;
        if (atr != null) {
            String atrString = Hex.toHexString((byte[])atr);
            if (acceptedAtrs.contains(atrString)) {
                accepted = true;
            } else if (invalidAtrs.contains(atrString)) {
                accepted = false;
            } else {
                AtrObject atrObj = Confis.get().getAtrObject(atr);
                boolean bl = accepted = atrObj != null && (detectHSMVault && CardDetector.isHSM(atrObj) || !CardDetector.isHSM(atrObj));
                if (accepted) {
                    log.debug("aceptada tarjeta con ATR: {}", (Object)Hex.toHexString((byte[])atr));
                    acceptedAtrs.add(atrString);
                } else {
                    invalidAtrs.add(atrString);
                    log.debug("no se acepta la tarjeta con ATR: {}", (Object)Hex.toHexString((byte[])atr));
                }
            }
        }
        return accepted;
    }
}

