/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token;

import com.anf.cryptotoken.config.DvcType;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.token.ANFToken;
import com.anf.cryptotoken.tkmanager.token.ANFTokenANFP11;
import com.anf.cryptotoken.tkmanager.token.ANFTokenBit4Id;
import com.anf.cryptotoken.tkmanager.token.ANFTokenStandard;
import com.anf.cryptotoken.tkmanager.token.ANFTokenVault;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import java.io.IOException;

public class ANFTokenFactory {
    public static ANFToken getToken(PKCS11Type type, CK_TOKEN_INFO tinfo, long slot) throws IOException {
        switch (type) {
            case VAULT_HSM: {
                return new ANFTokenVault(tinfo);
            }
            case ANFP11: {
                return new ANFTokenANFP11(tinfo, slot);
            }
            case Bit4id: {
                return new ANFTokenBit4Id(tinfo, slot);
            }
            case ST: {
                return new ANFTokenBit4Id(tinfo, slot);
            }
            case SafeNet: {
                return new ANFTokenStandard(DvcType.SafeNet, tinfo, slot);
            }
            case DNI: {
                return new ANFTokenStandard(DvcType.DNI, tinfo, slot);
            }
            case IDEMIA: {
                return new ANFTokenStandard(DvcType.IDEMIA, tinfo, slot);
            }
        }
        return null;
    }
}

