/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.token;

import com.anf.cryptotoken.config.AtrObject;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.config.DvcType;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.token.ANFTokenAbstract;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.JnaCardChannel;
import com.anf.jna.smartcardio.impl.STCardTools;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import java.io.IOException;
import java.math.BigInteger;
import java.util.function.Predicate;
import org.bouncycastle.util.encoders.Hex;

public class ANFTokenBit4Id
extends ANFTokenAbstract {
    private static final Logger log = Logger.getLogger(ANFTokenBit4Id.class);

    public ANFTokenBit4Id(CK_TOKEN_INFO tinfo, long slot) throws IOException {
        super(DvcType.Bit4id, tinfo, null, null);
        this.slot = slot;
        this.serialNumber = new String(tinfo.getSerialNumber()).trim();
        try {
            new BigInteger(this.serialNumber, 10);
        }
        catch (Exception e) {
            try {
                this.serialNumber = new BigInteger(this.serialNumber, 16).toString();
            }
            catch (Exception e1) {
                this.serialNumber = Hex.toHexString((byte[])tinfo.getSerialNumber()).trim();
            }
        }
    }

    @Override
    public String getTokenPkcs11() {
        return this.atr.getPkcs11();
    }

    @Override
    public String getTokenSerialNumber() {
        if (this.serialNumber == null) {
            this.serialNumber = this.getSerialNumber();
        }
        return this.serialNumber;
    }

    private String getSerialNumber() {
        try {
            return STCardTools.getSerialNumber((JnaCardChannel)this.cardChannel);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static AtrObject getAtrObject(byte[] atr) throws IOException {
        return Confis.get().getAtrObject(atr);
    }

    public void resetCard() throws Exception {
        STCardTools.resetCard((JnaCard)STCardTools.getCard((String)this.serialNumber, atr -> {
            try {
                return ANFTokenBit4Id.getAtrObject(atr).getName().equals("ST");
            }
            catch (IOException e) {
                log.error((Object)"error obteniendo atr", (Throwable)e);
                return false;
            }
        }));
    }

    public byte[] readFile(String pIN) throws Exception {
        return STCardTools.readFile((String)this.serialNumber, this.atrFilter(), (String)pIN);
    }

    public void writeFile(byte[] data, String pIN) throws Exception {
        STCardTools.writeFile((String)this.serialNumber, this.atrFilter(), (byte[])data, (String)pIN);
    }

    private Predicate<byte[]> atrFilter() {
        return atr -> {
            try {
                return ANFTokenBit4Id.getAtrObject(atr).getName().equals("ST");
            }
            catch (IOException e) {
                log.error((Object)"error obteniendo el atr object", (Throwable)e);
                return false;
            }
        };
    }
}

