/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager.advanced;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.PKCS11RuntimeException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CKRException;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.Functions;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.P11JNA;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.jna.PKCS11Impl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.util.Arrays;

public class P11JNATester {
    private static final Logger log = Logger.getLogger(P11JNATester.class);
    String dllName;
    PKCS11Type type;
    boolean initialized = false;

    public P11JNATester(String dllName, PKCS11Type type) {
        this.dllName = dllName;
        this.type = type;
    }

    public void closeAllSesions(long slotID) {
        log.info((Object)("closeAllSessions slot:" + slotID));
        this.getC().CloseAllSessions(slotID);
    }

    public void initialize() {
        long err = 0L;
        log.info((Object)("start initialize(" + this.initialized + ")"));
        if (!(PKCS11Type.VAULT_HSM != this.type && PKCS11Type.SafeNet != this.type && PKCS11Type.Bit4id != this.type && PKCS11Type.ST != this.type && PKCS11Type.ANFP11 != this.type || this.initialized)) {
            err = this.getC().Initialize();
            this.initialized = 0L == err;
        }
        log.info((Object)("end initialize(" + this.initialized + ")"));
    }

    public void finalize() {
        long err = 0L;
        log.info((Object)("start finalize(" + this.initialized + ")"));
        if ((PKCS11Type.VAULT_HSM == this.type || PKCS11Type.SafeNet == this.type || PKCS11Type.Bit4id == this.type || PKCS11Type.ST == this.type || PKCS11Type.ANFP11 == this.type) && this.initialized && 0L == (err = this.getC().Finalize())) {
            this.initialized = false;
        }
        log.info((Object)("end finalize(" + this.initialized + ")"));
    }

    public void initToken(long slot, String manufPIN, String soPINman, String soPINdef, String defLabel) throws IOException, PKCS11Exception {
        this.initialize();
        long flags = 0L;
        flags |= 4L;
        flags |= 2L;
        long closeAllSessions = this.getC().CloseAllSessions(slot);
        long r = this.C_InitToken(slot, manufPIN, defLabel);
        if (r == 0L) {
            log.info((Object)"C_InitToken OK");
            LongRef sh = new LongRef();
            r = this.getC().OpenSession(slot, flags, null, null, sh);
            if (r == 0L) {
                log.info((Object)"OpenSession OK");
                r = this.C_Login(soPINman, 0L, sh);
                if (r == 0L) {
                    log.info((Object)"C_Login CKU_SO OK");
                    r = this.C_SetPIN(soPINman, soPINdef, sh);
                    if (r == 0L) {
                        log.info((Object)"C_SetPIN OK");
                        r = this.C_Logout(sh);
                        if (r == 0L) {
                            log.info((Object)"C_Logout OK");
                            r = this.C_Login(soPINdef, 0L, sh);
                            if (r == 0L) {
                                log.info((Object)"C_Login CKU_SO OK");
                                r = this.C_Logout(sh);
                            }
                        }
                    }
                }
            }
        }
        if (r != 0L) {
            throw new CKRException(r);
        }
    }

    private long validate(long result) throws PKCS11Exception {
        if (0L != result) {
            throw new PKCS11Exception(result);
        }
        return result;
    }

    public Map<String, X509Certificate> readCertificateObjects(long slot, CK_ATTRIBUTE[] ckatr, ObjectRead objectReader) throws IOException, PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)1L), new CK_ATTRIBUTE(1L, (Object)true)};
        TreeMap<String, X509Certificate> certs = new TreeMap<String, X509Certificate>();
        this.readObjects(slot, attributes, ckatr, objectReader);
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrivateObjects(long slot, String pin, CK_ATTRIBUTE[] template, CK_ATTRIBUTE[] read, ObjectRead objectReader) {
        log.info((Object)("readPrivateObjects slot:" + slot));
        LongRef sessionRef = new LongRef();
        this.createSession(slot, sessionRef);
        long session = sessionRef.value;
        this.validate(this.getC().Login(session, 1L, pin.getBytes()));
        try {
            this.readObjectsSession(session, template, read, objectReader);
        }
        finally {
            this.validate(this.getC().Logout(session));
            this.validate(this.getC().CloseSession(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObjects(long slot, CK_ATTRIBUTE[] template, CK_ATTRIBUTE[] read, ObjectRead objectReader) {
        log.info((Object)("readObjects slot:" + slot));
        LongRef sessionRef = new LongRef();
        this.createSession(slot, sessionRef);
        long session = sessionRef.value;
        try {
            this.readObjectsSession(session, template, read, objectReader);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            this.getC().CloseSession(session);
        }
    }

    private void readObjectsSession(long session, CK_ATTRIBUTE[] template, CK_ATTRIBUTE[] read, ObjectRead objectReader) {
        this.validate(this.getC().FindObjectsInit(session, template));
        long[] objects = new long[100];
        LongRef count = new LongRef();
        while (0L == this.validate(this.getC().FindObjects(session, objects, count)) && count.value > 0L) {
            try {
                boolean end = false;
                for (int i = 0; !end && i < objects.length && (long)i < count.value; ++i) {
                    this.validate(this.getC().GetAttributeValue(session, objects[i], read));
                    if (objectReader.readObject(session, objects[i], read)) continue;
                    end = true;
                }
                if (!end) continue;
                break;
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() != 18L) {
                    throw e;
                }
                log.warn((Object)e);
            }
        }
        this.validate(this.getC().FindObjectsFinal(session));
    }

    public Map<String, X509Certificate[]> getCertificateChains(long slot) throws IOException, PKCS11Exception {
        log.info((Object)("getCertificates slot:" + slot));
        TreeMap<String, X509Certificate> certMap = new TreeMap<String, X509Certificate>();
        ArrayList nonFinalCerts = new ArrayList();
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L), new CK_ATTRIBUTE(258L)};
        this.readCertificateObjects(slot, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null) {
                String alias = ckatr[0].getValueStr();
                ckatr = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                log.info((Object)("leyendo CKA_VALUE de alias " + alias));
                long time = System.nanoTime();
                this.validate(this.getC().GetAttributeValue(session.longValue(), object.longValue(), ckatr));
                log.info((Object)("tiempo leyendo CKA_VALUE de alias " + alias + ": " + (double)(System.nanoTime() - time) / 1000000.0));
                X509Certificate x509certificate = this.generateCertificate(ckatr[0].pValue);
                if (x509certificate != null && x509certificate.getBasicConstraints() == -1) {
                    certMap.put(alias, x509certificate);
                } else {
                    nonFinalCerts.add(x509certificate);
                }
            }
            return true;
        });
        TreeMap<String, X509Certificate[]> chains = new TreeMap<String, X509Certificate[]>();
        certMap.forEach((alias, cert) -> {
            X509Certificate[] chain = this.buildChain(nonFinalCerts, (X509Certificate)cert);
            chains.put((String)alias, chain);
        });
        return chains;
    }

    private X509Certificate[] buildChain(List<X509Certificate> notFinalCertificates, X509Certificate cert) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        while (cert != null) {
            certs.add(cert);
            boolean f = false;
            for (X509Certificate cur : notFinalCertificates) {
                if (cur != cert && CertUtils.isIssuer((X509Certificate)cert, (X509Certificate)cur)) {
                    cert = cur;
                    f = true;
                }
                if (!f) continue;
                break;
            }
            if (f) continue;
            cert = null;
        }
        X509Certificate[] chain = new X509Certificate[certs.size()];
        certs.toArray(chain);
        return chain;
    }

    public Map<String, X509Certificate> getCertificates(long slot) throws IOException, PKCS11Exception {
        log.info((Object)("getCertificates slot:" + slot));
        TreeMap<String, X509Certificate> certs = new TreeMap<String, X509Certificate>();
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L), new CK_ATTRIBUTE(258L)};
        this.readCertificateObjects(slot, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null && ckatr[1].pValue != null) {
                String alias = ckatr[0].getValueStr();
                ckatr = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                this.validate(this.getC().GetAttributeValue(session.longValue(), object.longValue(), ckatr));
                X509Certificate x509certificate = this.generateCertificate(ckatr[0].pValue);
                if (x509certificate != null && x509certificate.getBasicConstraints() == -1) {
                    certs.put(alias, x509certificate);
                }
            }
            return true;
        });
        return certs;
    }

    public List<X509Certificate> getNotFinalCertificates(long slot) throws IOException, PKCS11Exception {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        this.readCertificateObjects(slot, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null) {
                ckatr = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                this.validate(this.getC().GetAttributeValue(session.longValue(), object.longValue(), ckatr));
                X509Certificate x509certificate = this.generateCertificate(ckatr[0].pValue);
                if (x509certificate != null && x509certificate.getBasicConstraints() != -1) {
                    certs.add(x509certificate);
                }
            }
            return true;
        });
        return certs;
    }

    private X509Certificate generateCertificate(byte[] certValue) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(certValue);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)cf.generateCertificate(is);
        }
        catch (Exception ce) {
            log.warn((Object)"no se pudo generar el certificado del pkcs11 por el ATTR VALUE", (Throwable)ce);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockPIN(long slot, char[] puk) {
        LongRef sh = new LongRef();
        this.createSession(slot, sh);
        try {
            long res = this.C_Login(new String(puk), 0L, sh);
            if (res == 0L) {
                res = this.C_Logout(sh);
                boolean bl = res == 0L;
                return bl;
            }
        }
        finally {
            this.C_CloseSession(sh);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUserPIN(long slot, String soPINdef, String defPIN) {
        log.info((Object)("initUserPIN slot:" + slot));
        LongRef sh = new LongRef();
        this.initialize();
        long flags = 0L;
        flags |= 4L;
        long p11 = this.getC().OpenSession(slot, flags |= 2L, null, null, sh);
        if (p11 == 0L) {
            try {
                long r = this.C_Login(soPINdef, 0L, sh);
                if (r == 0L) {
                    r = this.C_InitPIN(defPIN, sh);
                    if (r == 0L) {
                        r = this.C_Logout(sh);
                        if (r == 0L) {
                            r = this.C_Login(defPIN, 1L, sh);
                            if (r == 0L) {
                                r = this.C_Logout(sh);
                            } else {
                                System.out.println();
                            }
                        } else {
                            System.out.println();
                        }
                    } else {
                        System.out.println();
                    }
                } else {
                    System.out.println();
                }
                if (r != 0L) {
                    throw new CKRException(r);
                }
            }
            finally {
                this.getC().CloseSession(sh.value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized(long slot, String soPINdef, PKCS11Type pkcs11Type) throws IOException, PKCS11Exception {
        Map<String, X509Certificate> certs = null;
        boolean hayCertificados = false;
        log.info((Object)("isInitialized:" + slot + " " + pkcs11Type));
        if (pkcs11Type != PKCS11Type.ANFP11) {
            certs = this.getCertificates(slot);
            boolean bl = hayCertificados = certs != null && !certs.isEmpty();
            if (hayCertificados) {
                log.info((Object)("certs in slot:" + slot + " length:" + certs.size()));
            } else {
                log.info((Object)("no certs in slot:" + slot));
            }
        }
        if (!hayCertificados) {
            LongRef sh = new LongRef();
            log.info((Object)("no certs, so call createSession in slot:" + slot));
            this.createSession(slot, sh);
            try {
                log.info((Object)("C_Login(" + sh.value + ",CKU_SO)"));
                this.getC().Login(sh.value, 0L, soPINdef.getBytes());
                log.info((Object)("C_Logout(" + sh.value + ")"));
                this.getC().Logout(sh.value);
                log.info((Object)"token not initialized. return false");
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.error((Object)"failed to log as CKU_SO. it means token is initialized");
                boolean bl = true;
                return bl;
            }
            finally {
                this.C_CloseSession(sh);
            }
        }
        log.info((Object)("isInitialized returns hayCertificados:" + hayCertificados));
        return hayCertificados;
    }

    public void createSession(long slot, LongRef sh) {
        log.info((Object)("start createSession() slot:" + slot));
        long flags = 0L;
        flags |= 4L;
        flags |= 2L;
        try {
            if (sh == null) {
                sh = new LongRef();
            }
            long res = this.C_OpenSession(slot, flags, sh);
            log.info((Object)("createSession() slot:" + slot + " return " + res));
            if (res != 0L) {
                throw new PKCS11Exception(res);
            }
        }
        catch (PKCS11Exception e) {
            log.error((Object)e);
            throw new PKCS11RuntimeException((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void resetToken(long slot, String soPIN, String defPIN, String defLabel) throws IOException, PKCS11Exception {
        this.initialize();
        long flags = 0L;
        flags |= 4L;
        flags |= 2L;
        long r = this.C_InitToken(slot, soPIN, defLabel);
        if (r == 0L) {
            LongRef sh = new LongRef();
            r = this.getC().OpenSession(slot, flags, null, null, sh);
            if (r == 0L && (r = this.C_Login(soPIN, 0L, sh)) == 0L && (r = this.C_InitPIN(defPIN, sh)) == 0L && (r = this.C_Logout(sh)) == 0L) {
                this.getC().CloseSession(sh.value);
            }
        }
        if (r != 0L) {
            throw new CKRException(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePIN(long slot, String oldPIN, String newPIN) throws IOException, PKCS11Exception {
        this.initialize();
        long flags = 0L;
        flags |= 4L;
        flags |= 2L;
        LongRef sh = new LongRef();
        try {
            CK_TOKEN_INFO tokenInfo = new CK_TOKEN_INFO();
            this.getC().GetTokenInfo(slot, tokenInfo);
            long r = 0L;
            if ((tokenInfo.getFlags() & 4L) != 0L) {
                r = this.getC().OpenSession(slot, flags, null, null, sh);
                if (r == 0L) {
                    if ((tokenInfo.getFlags() & 0x100L) != 0L) {
                        r = this.C_Login(null, 1L, sh);
                        if (r == 0L) {
                            r = this.C_SetPIN(null, null, sh);
                        }
                    } else {
                        r = this.C_Login(oldPIN, 1L, sh);
                        if (r == 0L) {
                            r = this.C_SetPIN(oldPIN, newPIN, sh);
                            this.C_Logout(sh);
                        }
                    }
                }
                if (r != 0L) {
                    throw new CKRException(r);
                }
            } else {
                log.info((Object)Confis.get().getString("24", new Object[0]));
            }
        }
        finally {
            this.getC().CloseSession(sh.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCertificate(long slot, String alias, X509Certificate cert) throws CertificateEncodingException, IOException, PKCS11Exception {
        LongRef ref = new LongRef();
        LongRef sh = new LongRef();
        this.createSession(slot, sh);
        try {
            ArrayList<CK_ATTRIBUTE> attrs = new ArrayList<CK_ATTRIBUTE>();
            attrs.add(new CK_ATTRIBUTE(1L, (Object)true));
            attrs.add(new CK_ATTRIBUTE(0L, (Object)1L));
            attrs.add(new CK_ATTRIBUTE(128L, (Object)0L));
            attrs.add(new CK_ATTRIBUTE(257L, (Object)cert.getSubjectX500Principal().getEncoded()));
            attrs.add(new CK_ATTRIBUTE(129L, (Object)cert.getIssuerX500Principal().getEncoded()));
            attrs.add(new CK_ATTRIBUTE(130L, (Object)cert.getSerialNumber().toByteArray()));
            attrs.add(new CK_ATTRIBUTE(17L, (Object)cert.getEncoded()));
            if (alias != null) {
                attrs.add(new CK_ATTRIBUTE(3L, (Object)alias));
                attrs.add(new CK_ATTRIBUTE(258L, (Object)alias));
            } else {
                attrs.add(new CK_ATTRIBUTE(258L, (Object)this.getID(cert.getSubjectX500Principal().getName("CANONICAL"), cert)));
            }
            CK_ATTRIBUTE[] templ = new CK_ATTRIBUTE[attrs.size()];
            attrs.toArray(templ);
            long r = this.C_CreateObject(ref, templ, sh);
            if (r != 0L) {
                throw new CKRException(r);
            }
        }
        finally {
            this.C_CloseSession(sh);
        }
    }

    public KeyPair generateKeyPair(long slot, long session, int keySize, String alias) {
        String label = "VaultIC Label";
        CKM mechanism = new CKM(0L);
        LongRef publicKey = new LongRef();
        LongRef privateKey = new LongRef();
        CK_ATTRIBUTE[] publicKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, (Object)alias), new CK_ATTRIBUTE(1L, (Object)true), new CK_ATTRIBUTE(266L, (Object)true), new CK_ATTRIBUTE(289L, (Object)keySize), new CK_ATTRIBUTE(290L, (Object)RSAKeyGenParameterSpec.F4)};
        CK_ATTRIBUTE[] privateKeyTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, (Object)alias), new CK_ATTRIBUTE(1L, (Object)true), new CK_ATTRIBUTE(2L, (Object)true), new CK_ATTRIBUTE(258L, (Object)alias), new CK_ATTRIBUTE(259L, (Object)true), new CK_ATTRIBUTE(264L, (Object)true), new CK_ATTRIBUTE(356L, (Object)true), new CK_ATTRIBUTE(357L, (Object)true)};
        this.validate(this.getC().GenerateKeyPair(session, mechanism, publicKeyTemplate, privateKeyTemplate, publicKey, privateKey));
        System.out.println("public key: " + publicKey.value + " private key: " + privateKey.value);
        return null;
    }

    public List<String> getPrivateKeyIDs(long slot) throws IOException, PKCS11Exception {
        log.info((Object)("getPrivateKeyIDs slot:" + slot));
        ArrayList<String> pkIds = new ArrayList<String>();
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)3L), new CK_ATTRIBUTE(1L, (Object)true)};
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.readObjects(slot, attributes, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null) {
                String cka_id = new String(Base64.getEncoder().encode(ckatr[0].pValue));
                pkIds.add(cka_id);
            }
            return true;
        });
        return pkIds;
    }

    public List<String> getPrivateKeysLength(long slot) throws IOException, PKCS11Exception {
        ArrayList<String> pkIds = new ArrayList<String>();
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)3L), new CK_ATTRIBUTE(1L, (Object)true)};
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L), new CK_ATTRIBUTE(288L)};
        this.readObjects(slot, attributes, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null && ckatr[1].pValue != null) {
                String cka_id = new String(Base64.getEncoder().encode(ckatr[0].pValue));
                pkIds.add(cka_id);
                BigInteger bi = new BigInteger(ckatr[1].pValue);
                int bitLength = bi.bitLength();
                log.info((Object)(bitLength + " " + cka_id + " " + Functions.toHexString((byte[])ckatr[1].pValue)));
            }
            return true;
        });
        return pkIds;
    }

    public void findPrivateKeyWithLabel(long slot, String label, String pin, ObjectRead reader) throws IOException, PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)3L), new CK_ATTRIBUTE(1L, (Object)true)};
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L), new CK_ATTRIBUTE(3L)};
        this.readPrivateObjects(slot, pin, attributes, ckatrx, (session, object, ckatr) -> {
            boolean next = true;
            for (CK_ATTRIBUTE atr : ckatrx) {
                if (atr.pValue == null || !atr.getValueStr().equals(label)) continue;
                next = reader.readObject(session, object, ckatrx);
                break;
            }
            return next;
        });
    }

    private String findCertId(long slot, String label) {
        AtomicReference id = new AtomicReference();
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)1L), new CK_ATTRIBUTE(1L, (Object)true)};
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L), new CK_ATTRIBUTE(3L)};
        this.readObjects(slot, attributes, ckatrx, (session, object, ckatr) -> {
            boolean next = true;
            if (ckatrx[1].pValue != null && ckatrx[1].getValueStr().equals(label)) {
                id.set(ckatrx[0].getValueStr());
                next = false;
            }
            return next;
        });
        return (String)id.get();
    }

    private String getID(String paramString, X509Certificate paramX509Certificate) {
        X500Principal localX500Principal = paramX509Certificate.getIssuerX500Principal();
        BigInteger localBigInteger = paramX509Certificate.getSerialNumber();
        return paramString + "/" + localX500Principal.getName("CANONICAL") + "/" + localBigInteger.toString();
    }

    public PKCS11Impl getC() {
        return P11JNA.getPKCS11Impl((String)this.dllName);
    }

    public long C_Logout(LongRef sh) {
        return this.getC().Logout(sh.value);
    }

    private long C_SetPIN(String soPINman, String soPINdef, LongRef sh) {
        return this.getC().SetPIN(sh.value, soPINman == null ? null : soPINman.getBytes(), soPINdef == null ? null : soPINdef.getBytes());
    }

    public long C_Login(String soPINman, long user, LongRef sh) {
        log.info((Object)"start C_Login");
        long login = this.getC().Login(sh.value, user, soPINman == null ? null : soPINman.getBytes());
        log.info((Object)("end C_Login: " + login));
        return login;
    }

    private long C_OpenSession(long slot, long flags, LongRef sh) {
        log.info((Object)("C_OpenSession slot:" + slot + ", flags: " + flags));
        long result = this.getC().OpenSession(slot, flags, null, null, sh);
        log.info((Object)("C_OpenSession returns session id: " + sh.value + " in slot " + slot + ", flags: " + flags));
        return result;
    }

    private long C_InitToken(long slot, String manufPIN, String defLabel) {
        return this.getC().InitToken(slot, manufPIN.getBytes(), defLabel.getBytes());
    }

    private long C_CreateObject(LongRef ref, CK_ATTRIBUTE[] templ, LongRef sh) {
        return this.getC().CreateObject(sh.value, templ, ref);
    }

    public long C_CloseSession(LongRef sh) {
        if (sh != null) {
            log.info((Object)("C_CloseSession:" + sh.value));
            return this.getC().CloseSession(sh.value);
        }
        return 0L;
    }

    private long C_InitPIN(String defPIN, LongRef sh) {
        return this.getC().InitPIN(sh.value, defPIN.getBytes());
    }

    public boolean verifyData(byte[] data, byte[] signedData, String alias, String sign_ALG, Provider provider) {
        return false;
    }

    public void deleteKey(long slot, long id) throws IOException, PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, (Object)3L)};
        CK_ATTRIBUTE[] ckatrx = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.readObjects(slot, attributes, ckatrx, (session, object, ckatr) -> {
            if (ckatr[0].pValue != null) {
                String cka_id = new String(Base64.getEncoder().encode(ckatr[0].pValue));
                log.info((Object)("destroy private key " + cka_id));
                this.getC().DestroyObject(session.longValue(), object.longValue());
                return true;
            }
            return false;
        });
    }

    public byte[] generateSecretKey(long slot, int byteLength) {
        try {
            LongRef sh = new LongRef();
            this.createSession(slot, sh);
            byte[] random = new byte[byteLength];
            this.getC().GenerateRandom(sh.value, random);
            return random;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public byte[] sign(long slot, byte[] data, String signAlgorithm, String alias, String pin) throws PKCS11Exception {
        AtomicReference signedData = new AtomicReference();
        PKCS11Impl nativeController = this.getC();
        try {
            byte[] dataToSign = this.prepareDataToSign(data, signAlgorithm);
            this.findPrivateKeyWithLabel(slot, alias, pin, (session, object, attrs) -> {
                long keyId = object;
                CKM mechanism = new CKM(1L);
                this.validate(nativeController.SignInit(session.longValue(), mechanism, keyId));
                byte[] buffer = new byte[4096];
                LongRef signLen = new LongRef();
                signLen.value = buffer.length;
                this.validate(nativeController.Sign(session.longValue(), dataToSign, buffer, signLen));
                signedData.set(Arrays.copyOf((byte[])buffer, (int)((int)signLen.value)));
                return false;
            });
            if (signedData.get() == null) {
                throw new PKCS11Exception(96L);
            }
        }
        catch (Exception e) {
            throw new PKCS11Exception(6L, (Throwable)e);
        }
        return (byte[])signedData.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] prepareDataToSign(byte[] data, String signAlgorithm) throws Exception, NoSuchAlgorithmException {
        String alg = null;
        byte[] header = null;
        switch (signAlgorithm) {
            case "NONEwithRSA": {
                header = null;
                break;
            }
            case "SHA1withRSA": {
                header = TKManager.SHA1Header;
                alg = "SHA-1";
                break;
            }
            case "SHA224withRSA": {
                header = TKManager.SHA224Header;
                alg = "SHA-224";
                break;
            }
            case "SHA256withRSA": {
                header = TKManager.SHA256Header;
                alg = "SHA-256";
                break;
            }
            case "SHA384withRSA": {
                header = TKManager.SHA384Header;
                alg = "SHA-384";
                break;
            }
            case "SHA512withRSA": {
                header = TKManager.SHA512Header;
                alg = "SHA-512";
                break;
            }
            default: {
                throw new Exception("ERR_ALG_NOT_SUPPORTED:" + signAlgorithm);
            }
        }
        byte[] dataToSign = null;
        if (header == null) return data;
        if (alg == null) throw new Exception("ERR_ALG_NOT_SUPPORTED:" + signAlgorithm);
        byte[] digest = MessageDigest.getInstance(alg).digest(data);
        dataToSign = new byte[header.length + digest.length];
        System.arraycopy(header, 0, dataToSign, 0, header.length);
        System.arraycopy(digest, 0, dataToSign, header.length, digest.length);
        return dataToSign;
    }

    public CK_SLOT_INFO GetSlotInfo(long slot) {
        CK_SLOT_INFO slotInfo = new CK_SLOT_INFO();
        this.validate(this.getC().GetSlotInfo(slot, slotInfo));
        return slotInfo;
    }

    public void CloseSession(LongRef sh) {
        this.validate(this.C_CloseSession(sh));
    }

    public long[] GetSlotList(boolean tokenPresent) {
        LongRef count = new LongRef();
        this.validate(this.getC().GetSlotList(tokenPresent, null, count));
        long[] slots = new long[(int)count.value];
        if (count.value > 0L) {
            this.validate(this.getC().GetSlotList(tokenPresent, slots, count));
        }
        return slots;
    }

    public CK_SLOT_INFO getSlotInfo(long slot) {
        CK_SLOT_INFO info = new CK_SLOT_INFO();
        this.validate(this.getC().GetSlotInfo(slot, info));
        return info;
    }

    public CK_TOKEN_INFO getTokenInfo(long slot) {
        CK_TOKEN_INFO info = new CK_TOKEN_INFO();
        this.validate(this.getC().GetTokenInfo(slot, info));
        return info;
    }

    static interface ObjectRead {
        public boolean readObject(Long var1, Long var2, CK_ATTRIBUTE[] var3) throws PKCS11Exception;
    }
}

