/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.KeyPairException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.controller.impl.AuthHandlerImpl;
import com.anf.cryptotoken.tkmanager.token.detect.impl.CardDetector;
import com.anf.cryptotoken.tkmanager.utils.WindowsCertChecker;
import com.anf.cryptotoken.tkmanager.utils.WindowsCertUtil;
import com.anf.utils.OSUtils;
import com.anf.utils.SerialUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;

public final class TKManagerWindows
extends TKManagerAbstract {
    private static final Logger log = Logger.getLogger(TKManagerWindows.class);
    private static TKManagerWindows windows = null;
    private static Provider providerMSCAPI;
    private String serialNumber;
    private Set<String> currentAliases;

    public static TKManagerAbstract get() {
        if (windows == null && OSUtils.isWindows()) {
            windows = new TKManagerWindows();
        }
        return windows;
    }

    private TKManagerWindows() {
        this.reload(true);
    }

    @Override
    public void reloadToken() {
        this.reload(false);
    }

    private void reload(boolean showTrayIcon) {
        try (LockerImpl locker = this.getLocker().acquireLock();
             LockerImpl certPropSvc = LockerImpl.get((String)"certpropsvc").acquireLock();
             LockerImpl smartCardLock = CardDetector.acquireLock();){
            boolean reload = false;
            try {
                Set<String> filteredAliases = WindowsCertChecker.filterWindowsCertificates(null, false, true);
                if (this.currentAliases != null) {
                    for (String alias : filteredAliases) {
                        if (this.currentAliases.contains(alias)) continue;
                        log.info((Object)("hay que recargar windows porque hay al menos un alias nuevo:" + alias));
                        reload = true;
                        break;
                    }
                    if (!reload) {
                        for (String alias : this.currentAliases) {
                            if (filteredAliases.contains(alias)) continue;
                            log.info((Object)("hay que recargar windows porque hay al menos un alias que ya no esta:" + alias));
                            reload = true;
                            break;
                        }
                    }
                } else {
                    this.currentAliases = filteredAliases;
                    reload = true;
                }
                log.info((Object)("check reload windows:" + reload));
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            if (reload) {
                this.store = KeyStore.getInstance("Windows-MY", providerMSCAPI);
                this.store.load(null, null);
                Enumeration<String> windowsAliases = this.store.aliases();
                TreeSet<String> set = new TreeSet<String>(Collections.list(windowsAliases));
                TreeSet<String> delete = new TreeSet<String>();
                for (String alias : this.currentAliases) {
                    if (set.contains(alias)) continue;
                    delete.add(alias);
                }
                log.error((Object)("aliases no validos de windows: " + delete));
                for (String alias : delete) {
                    this.currentAliases.remove(alias);
                }
                log.info((Object)("aliases filtrados de windows: " + this.currentAliases));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ANFKeyStoreException("ERR_WINDOWS_LOAD", (Throwable)e);
        }
    }

    @Override
    public void resetToken() {
        this.reloadToken();
    }

    @Override
    public String getSerialNumberToken() {
        if (this.serialNumber == null) {
            String serial = "0000000000000000";
            try {
                serial = SerialUtils.getComputerSerialNumber();
            }
            catch (RuntimeException e) {
                log.error((Object)e);
            }
            this.serialNumber = serial;
            log.info((Object)("WINDOWS SERIAL NUMBER:" + this.serialNumber));
        }
        return this.serialNumber;
    }

    private byte[] transformDataToSign(byte[] data, String signAlgorithm) {
        byte[] dataToSign = null;
        block3 : switch (signAlgorithm) {
            case "NONEwithRSA": {
                for (int i = 0; i < SIGN_ALG.length; ++i) {
                    byte[] header = HEADERS[i];
                    if (!Arrays.equals(header, Arrays.copyOf(data, header.length))) continue;
                    dataToSign = Arrays.copyOfRange(data, header.length, data.length);
                    break block3;
                }
                break;
            }
            default: {
                dataToSign = data;
            }
        }
        return dataToSign;
    }

    public static byte[] encodeRSADigest(String digestAlgorithm, byte[] digest) {
        try {
            AlgorithmIdentifier oid = new DefaultDigestAlgorithmIdentifierFinder().find(digestAlgorithm);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(oid.getAlgorithm());
            DigestInfo digestInfo = new DigestInfo(algId, digest);
            return digestInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    public void saveKeyPairInStore(String alias, X509Certificate[] certChain, PrivateKey privKey, int keySize) {
        try {
            Certificate[] chain = CertUtils.sortChain((X509Certificate[])certChain);
            this.store.setKeyEntry(alias, privKey, null, chain);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    @Override
    public Enumeration<String> getAlias() {
        log.debug((Object)("getAlias current: " + this.currentAliases));
        return Collections.enumeration(this.currentAliases);
    }

    @Override
    public String getPrPath() {
        throw new UnsupportedOperationException("getPrPath is not supported");
    }

    public LockerImpl getLocker() {
        return LockerImpl.get((String)"windows.store");
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.store.getKey(alias, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ANFPrivateKeyException();
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        try {
            return this.store.getCertificate(alias).getPublicKey();
        }
        catch (KeyStoreException e) {
            throw new ANFCertificateException();
        }
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", Security.getProvider("BC"));
            kpg.initialize(keySize);
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairException((Throwable)e);
        }
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        String alias = null;
        if (data != null && data.length > 0) {
            alias = data[0].toString();
        }
        return new AuthHandlerImpl(this, alias);
    }

    @Override
    public void removeCertificate(String alias) throws Throwable {
        super.removeCertificate(alias);
        this.saveStore();
    }

    @Override
    protected void removeCertificateForced(String alias) {
        super.removeCertificateForced(alias);
        this.saveStore();
    }

    @Override
    public void saveStore() {
        try {
            this.store.store(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ANFKeyStoreException("ERR_SAVE_STORE", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "Windows";
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + alias + Confis.get().getString("importAliasWin", new Object[0]);
        return title;
    }

    @Override
    protected X509Certificate generateAutosignedCertificate(X509v3CertificateBuilder certGen, PrivateKey privateKey) {
        Provider prov = Security.getProvider("BC");
        return this.generateAutosignedCertificate(certGen, privateKey);
    }

    protected byte[] generateCertificate(String alias, KeyPair kp, X509v3CertificateBuilder certGen, ASN1Set attributes, String signAlias, int keySize, String signAlg) {
        X509Certificate autoSignedCertifcate = null;
        autoSignedCertifcate = this.generateAutosignedCertificate(certGen, kp.getPrivate());
        this.saveKeyPairInStore(alias, new X509Certificate[]{autoSignedCertifcate}, kp.getPrivate(), keySize);
        byte[] csr = this.createPKCS10(attributes, signAlg, autoSignedCertifcate.getSubjectX500Principal(), autoSignedCertifcate.getPublicKey(), Security.getProvider("BC"), kp.getPrivate());
        return csr;
    }

    @Override
    protected boolean supportPUK() {
        return false;
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
        int finalCert = CertUtils.getFinalCert((X509Certificate[])certs);
        if (finalCert != -1) {
            X509Certificate cert = certs[finalCert];
            WindowsCertUtil.importUserCertificate(cert);
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) throws PINLOCKEDException {
        throw new UnsupportedOperationException("ERR_WINDOWS_STORE_IMPORT_NOT_AVAILABLE");
    }

    @Override
    public boolean changePIN(String alias) {
        throw new UnsupportedOperationException("ERR_WINDOWS_STORE_CHANGE_PIN_NOT_AVAILABLE");
    }

    @Override
    public boolean changePIN(String alias, char[] old, char[] newPIN, char[] newPuk) {
        throw new UnsupportedOperationException("ERR_WINDOWS_STORE_CHANGE_PIN_NOT_AVAILABLE");
    }

    static {
        if (OSUtils.isWindows()) {
            try {
                providerMSCAPI = Security.getProvider("SunMSCAPI");
                Security.addProvider(providerMSCAPI);
                AgregarProveedor.agregarBouncyCastleProvider();
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }
}

