/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerPKCS11;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.pkcs11.jna.P11Manager;
import java.io.IOException;
import java.security.KeyStoreException;

public final class TKManagerVaultP11
extends TKManagerPKCS11 {
    private static final Logger log = Logger.getLogger(TKManagerVaultP11.class);
    public static int MAX__ONLY_1024_CERTS = 6;
    public static int MAX__ONLY_2048_CERTS = 3;
    public static int MAX__COMBINED_1024_CERTS = 3;
    public static int MAX__COMBINED_2048_CERTS = 3;

    protected TKManagerVaultP11(P11Manager p11, long slot) throws KeyStoreException, IOException {
        super(p11, slot);
        this.MAX_PIN = 3;
        this.MAX_PUK = 1;
    }

    @Override
    protected PKCS11Type getType() {
        return PKCS11Type.VAULT_HSM;
    }

    public void setLetterUnit(String unit) {
        this.usb = USBFactory.newUSB((String)unit, (String)this.getSerialNumberToken());
    }

    public boolean canGenerateCertificateCount(int count1024, int count2048) {
        this.initUserToken();
        int[] c = this.getCertificateCounts();
        if (count2048 == 0) {
            if (c[1] == 0) {
                return c[0] + count1024 <= MAX__ONLY_1024_CERTS;
            }
        } else if (count1024 == 0 && c[0] == 0) {
            return c[1] + count2048 <= MAX__ONLY_2048_CERTS;
        }
        return c[0] + count1024 <= MAX__COMBINED_1024_CERTS && c[1] + count2048 <= MAX__COMBINED_2048_CERTS;
    }

    @Override
    protected String getLockString() {
        return "hsm";
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return ProfilePolicy.isQSCD((ProfilePolicy)profile);
    }

    @Override
    public boolean isHSM() {
        return true;
    }
}

