/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerPKCS11;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.token.ANFTokenBit4Id;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.pkcs11.jna.P11Manager;
import java.io.IOException;
import java.security.KeyStoreException;

public class TKManagerST
extends TKManagerPKCS11 {
    private static final Logger log = Logger.getLogger(TKManagerST.class);

    protected TKManagerST(P11Manager p11, long slot) throws KeyStoreException, IOException {
        super(p11, slot);
        this.MAX_PIN = 3;
        this.MAX_PUK = 1;
    }

    @Override
    protected boolean importCA() {
        return true;
    }

    @Override
    protected PKCS11Type getType() {
        return PKCS11Type.ST;
    }

    public void writeFile(byte[] data) {
        String title = Confis.get().getString("cardWritePIN", new Object[0]);
        try {
            String id = this.getSerialNumberToken() + "-write-pin";
            String PIN = new String(KeyBoardHandler.getPassword(id, title, false, false, this.getAuthHandler(new Object[0])));
            this.writeFile(data, PIN);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void resetCard() throws Exception {
        ((ANFTokenBit4Id)this.token).resetCard();
    }

    private void writeFile(byte[] data, String PIN) throws Exception {
        ((ANFTokenBit4Id)this.token).writeFile(data, PIN);
    }

    public byte[] readFile() {
        String title = Confis.get().getString("cardReadPIN", new Object[0]);
        try {
            String id = this.getSerialNumberToken() + "-read-pin";
            String PIN = new String(KeyBoardHandler.getPassword(id, title, false, false, this.getAuthHandler(new Object[0])));
            return this.readFile(PIN);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private byte[] readFile(String PIN) throws Exception {
        return ((ANFTokenBit4Id)this.token).readFile(PIN);
    }

    @Override
    protected String getLockString() {
        return "st";
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        return null;
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return ProfilePolicy.isQSCD((ProfilePolicy)profile);
    }
}

