/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.io.exception.LockException;
import com.anf.cryptotoken.api.sign.exception.ANFVerifySignatureException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFLoginException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.KeyPairException;
import com.anf.cryptotoken.api.tkmanager.exception.KeySizeException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.exception.PINNotInitialized;
import com.anf.cryptotoken.api.tkmanager.exception.PKCS11ProviderException;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerANFP11;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.controller.impl.AuthHandlerImpl;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.dto.PrivateKeyLogin;
import com.anf.cryptotoken.tkmanager.params.UnlockPINParamsImpl;
import com.anf.cryptotoken.tkmanager.token.ANFToken;
import com.anf.cryptotoken.tkmanager.token.ANFTokenFactory;
import com.anf.cryptotoken.tkmanager.token.PKCS11TokenInfo;
import com.anf.cryptotoken.tkmanager.token.detect.impl.CardDetector;
import com.anf.cryptotoken.tkmanager.utils.Utils;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.provider.JNAProvider;
import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.trust.certs.CertResourceHandler;
import java.awt.HeadlessException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.util.Arrays;

public abstract class TKManagerPKCS11
extends TKManagerAbstract {
    private static final Logger log = Logger.getLogger(TKManagerPKCS11.class);
    protected ANFToken token;
    protected String dll;
    protected long slot = -1L;
    protected boolean initChecked = false;
    protected JNAProvider provider;

    protected TKManagerPKCS11(P11Manager p11, long slot, boolean loadStore) throws KeyStoreException, IOException {
        this.dll = p11.getDllModule();
        this.slot = slot;
        this.token = ANFTokenFactory.getToken(this.getType(), p11.getTokenInfo(slot), slot);
        if (loadStore) {
            try (Locker locker = this.getLocker().acquireLock();
                 LockerImpl smartCardLock = CardDetector.acquireLock();){
                this.provider = new JNAProvider(p11, slot);
                this.store = KeyStore.getInstance("PKCS11", (Provider)this.provider);
                this.store.load(null, null);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new KeyStoreException(e);
            }
        }
    }

    protected TKManagerPKCS11(P11Manager p11, long slot) throws KeyStoreException, IOException {
        this(p11, slot, true);
    }

    protected JNAToken getToken() {
        return this.getP11Provider().getToken();
    }

    public AuthInfoImpl getCounterInfo() {
        return null;
    }

    @Override
    public AuthInfoImpl getCounterInfo(String alias) {
        AuthInfoImpl counterInfo = this.getCounterInfo();
        if (counterInfo == null) {
            counterInfo = new AuthInfoImpl(0, 0, null, null, this.MAX_PIN, this.MAX_PUK);
        }
        return counterInfo;
    }

    public int onPINLocked(AuthInfoImpl auth, char[] pin) {
        while (auth.getPinCounter() >= this.MAX_PIN && auth.getPukCounter() < this.MAX_PUK) {
            boolean unlock = this.unlockPIN(new UnlockPINParamsImpl(null, null, pin, null));
            auth = this.getCounterInfo();
            if (!unlock) {
                if (pin == null) {
                    String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                    if (auth.getPukCounter() < this.MAX_PUK) {
                        Object pukErrMsg = Confis.get().getString("pukFailed", new Object[0]);
                        if (auth.getPukCounter() == this.MAX_PUK - 1) {
                            String lastAttempt = Confis.get().getString("LAST_TRY", new Object[0]);
                            pukErrMsg = (String)pukErrMsg + ". " + lastAttempt;
                        }
                        KeyBoardHandler.msg(pukErrMsg, errorTitle, 2);
                    } else {
                        KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                    }
                }
                if (auth.getPinCounter() < this.MAX_PIN || auth.getPukCounter() < this.MAX_PUK) continue;
                throw new PINLOCKEDException(false);
            }
            if (pin == null) {
                this.initUserToken();
            }
            return 0;
        }
        throw new PINLOCKEDException(false);
    }

    @Override
    public boolean unlockPIN(UnlockPINParams params) {
        char[] newPin;
        char[] puk = params.getPuk();
        String id = this.getPukId(params.getSerial(), params.getAlias()) + "-unlock-pin";
        if (puk == null) {
            String unlockPin = Confis.get().getString("inputPINCert", this.getName() + " - " + this.getSerialNumberToken());
            KeyBoardHandler.remove(id);
            puk = KeyBoardHandler.getPassword(id, unlockPin, false, true, null);
        }
        if ((newPin = params.getNewPin()) == null) {
            String newPinTitle = Confis.get().getString("newPin", new Object[0]);
            newPin = KeyBoardHandler.getPassword(id, newPinTitle, false, true, null);
        }
        if (puk != null) {
            boolean unlockPIN = this.getP11().unlockPIN(this.slot, new String(puk), new String(newPin));
            if (unlockPIN) {
                this.initChecked = false;
            }
            return unlockPIN;
        }
        return false;
    }

    public void logoutPKCS11() throws NOPINException, PINLOCKEDException {
        this.initUserToken();
        try {
            Locker locker = this.getLocker().acquireLock();
            if (locker != null) {
                locker.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getPrPath() {
        return this.getProviderPath();
    }

    private String getProviderPath() {
        return Utils.getAbsFilePath(this.getPKCS11Module());
    }

    public String getPKCS11Module() {
        return this.dll;
    }

    @Override
    public void reloadToken() {
    }

    @Override
    public String getSerialNumberToken() {
        return this.token.getTokenSerialNumber();
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) throws KeyStoreException {
        KeyPair kp;
        this.initUserToken();
        try {
            kp = this.generateKeyPairImpl(keySize);
        }
        catch (Throwable e) {
            throw new KeyStoreException(e);
        }
        return kp;
    }

    protected KeyPair generateKeyPairImpl(int keySize) throws Throwable {
        KeyPair kp = null;
        int c = 10;
        while (true) {
            if (c-- == 0) {
                throw new KeyPairException("No se pudo generar el par de llaves");
            }
            this.login(new LoginAction(this.store), null);
            try (Locker locker = this.getLocker().acquireLock();){
                LockerImpl smartCardLock = CardDetector.acquireLock();
                try {
                    JNAPrivateKey privateKey;
                    KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", this.getProvider());
                    RSAKeyGenParameterSpec specs = new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4);
                    kpg.initialize(specs);
                    log.info((Object)("Generando par de llaves con tamano " + keySize + " en el dispositivo tipo " + this.getType() + " con numero de serie " + this.getSerialNumberToken()));
                    kp = kpg.genKeyPair();
                    log.info((Object)"Generado el par de llaves!");
                    PrivateKey pk = kp.getPrivate();
                    String pkstr = pk.toString();
                    log.info((Object)pkstr);
                    if (pk instanceof JNAPrivateKey && (privateKey = (JNAPrivateKey)pk).getKeySize() != keySize) {
                        try {
                            X509Certificate cert = CertResourceHandler.readFromJar((String)"ANF_Global_Root_CA_SHA256.cer");
                            if (cert == null) continue;
                            String alias = "temp" + Math.random() * 10000.0;
                            this.store.setKeyEntry(alias, pk, null, new X509Certificate[]{cert});
                            this.store.deleteEntry(alias);
                        }
                        catch (Exception e2) {
                            log.error((Object)e2);
                        }
                        continue;
                    }
                    log.info((Object)("Par de llaves de tamano " + keySize + " generadas con RSA"));
                    break;
                }
                finally {
                    if (smartCardLock == null) continue;
                    smartCardLock.close();
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                log.error((Object)e);
            }
        }
        return kp;
    }

    @Override
    public byte[] generateRequest(String alias, X500Name x500Name, BigInteger serial, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlg) {
        this.initUserToken();
        if (alias == null) {
            alias = this.getNewValidAlias(x500Name);
        }
        int attempts = 5;
        while (attempts-- > 0) {
            KeyPair kp = null;
            try {
                if (this.store.containsAlias(alias)) {
                    kp = this.getKeyPair(alias);
                } else {
                    boolean generated = true;
                    int c = 0;
                    while (generated) {
                        try {
                            kp = this.generateKeyPair(keySize);
                            generated = false;
                        }
                        catch (Exception ex) {
                            ++c;
                            log.error((Object)ex);
                        }
                        if (c != 10) continue;
                        throw new Exception(Confis.get().getString("25", new Object[0]));
                    }
                }
                if (kp == null) continue;
                try {
                    JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(x500Name, serial, notBefore, notAfter, x500Name, kp.getPublic());
                    return this.generateCertificate(alias, kp, (X509v3CertificateBuilder)certGen, attributes, keySize, signAlg);
                }
                catch (KeySizeException e) {
                    log.error((Object)e);
                }
            }
            catch (Exception e) {
                throw new ANFKeyStoreException((Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] generateCertificate(String alias, KeyPair kp, X509v3CertificateBuilder certGen, ASN1Set attributes, int keySize, String signAlg) {
        this.initUserToken();
        X509Certificate autoSignedCertifcate = null;
        try (Locker locker = this.getLocker().acquireLock();){
            byte[] byArray;
            block14: {
                LockerImpl smartCardLock = CardDetector.acquireLock();
                try {
                    autoSignedCertifcate = this.generateAutosignedCertificate(certGen, kp.getPrivate());
                    this.saveKeyPairInStore(alias, new X509Certificate[]{autoSignedCertifcate}, kp.getPrivate(), keySize);
                    PrivateKey privateKey = kp.getPrivate();
                    byArray = this.createPKCS10(attributes, signAlg, autoSignedCertifcate.getSubjectX500Principal(), autoSignedCertifcate.getPublicKey(), this.store.getProvider(), privateKey);
                    if (smartCardLock == null) break block14;
                }
                catch (Throwable throwable) {
                    if (smartCardLock != null) {
                        try {
                            smartCardLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                smartCardLock.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new LockException((Throwable)e);
        }
    }

    public void saveKeyPairInStore(String alias, X509Certificate[] certChain, PrivateKey privKey, int keySize) {
        this.initUserToken();
        try (Locker locker = this.getLocker().acquireLock();){
            int max = 1;
            while (max-- > 0) {
                try {
                    Certificate[] chain = CertUtils.sortChain((X509Certificate[])certChain);
                    this.store.setKeyEntry(alias, privKey, null, chain);
                    if (privKey instanceof JNAPrivateKey) {
                        JNAPrivateKey jnaKey = (JNAPrivateKey)privKey;
                        Key key = this.store.getKey(alias, null);
                        log.info((Object)("passed:" + privKey));
                        log.info((Object)("imported:" + key));
                        if (jnaKey.getKeySize() != keySize) {
                            this.store.deleteEntry(alias);
                            throw new KeySizeException(Confis.get().getString("keySize", new Object[0]) + key.toString());
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        }
        catch (IOException e) {
            throw new LockException((Throwable)e);
        }
    }

    @Override
    public KeyStore getKeyStore() {
        return this.store;
    }

    @Override
    public synchronized Enumeration<String> getAlias() {
        try {
            return this.store.aliases();
        }
        catch (KeyStoreException e) {
            log.error((Object)"error listando aliases", (Throwable)e);
            return Collections.emptyEnumeration();
        }
    }

    @Override
    public synchronized X509Certificate getCertificate(String alias) {
        try {
            return (X509Certificate)this.store.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)("error cargando el certificado del alias " + alias), (Throwable)e);
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Certificate[] certs = null;
        try {
            certs = this.store.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)("error cargando los certificados del alias " + alias), (Throwable)e);
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] chain = CertUtils.toX509((Certificate[])certs);
        chain = CertUtils.fillChain((X509Certificate[])chain);
        return chain;
    }

    @Override
    public Provider getProvider() {
        return this.getP11Provider();
    }

    protected JNAProvider getP11Provider() {
        return this.provider;
    }

    private X509Certificate[] buildChain(List<X509Certificate> notFinalCertificates, X509Certificate cert) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        while (cert != null) {
            certs.add(cert);
            boolean f = false;
            for (X509Certificate cur : notFinalCertificates) {
                if (cur != cert && CertUtils.isIssuer((X509Certificate)cert, (X509Certificate)cur)) {
                    cert = cur;
                    f = true;
                }
                if (!f) continue;
                break;
            }
            if (f) continue;
            cert = null;
        }
        X509Certificate[] chain = new X509Certificate[certs.size()];
        certs.toArray(chain);
        return chain;
    }

    @Override
    public synchronized boolean containsAlias(String alias) {
        try {
            return this.store.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)("error containsAlias " + alias), (Throwable)e);
            return false;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias, char[] pin) {
        PrivateKey privateKey;
        block8: {
            log.info((Object)("getPrivateKey with pin(alias:" + alias + ") slot:" + this.slot + " " + this.getName()));
            this.initUserToken();
            Locker locker = this.getLocker().acquireLock();
            try {
                log.info((Object)("store:" + this.store));
                this.login(new LoginAction(this.store), pin);
                Key key = this.store.getKey(alias, null);
                log.info((Object)("key:" + key));
                PrivateKey privateKey2 = privateKey = key != null ? (PrivateKey)key : null;
                if (locker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        try {
                            locker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new ANFPrivateKeyException(e);
                }
            }
            locker.close();
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        log.info((Object)("getPrivateKey(alias:" + alias + ") slot:" + this.slot + " " + this.getName()));
        this.initUserToken();
        try {
            log.info((Object)("store:" + this.store));
            this.login(new LoginAction(this.store), null);
            Key key = this.store.getKey(alias, null);
            log.info((Object)("key:" + key));
            return key != null ? (PrivateKey)key : null;
        }
        catch (Throwable e) {
            throw new ANFPrivateKeyException(e);
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        PublicKey pubkey = this.getCertificate(alias).getPublicKey();
        return pubkey;
    }

    @Override
    public byte[] encryptData(String alias, byte[] data, String algorithm) {
        return UtilsPki.cipherData(data, Security.getProvider("BC"), this.getPublicKey(alias), algorithm);
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm) {
        return this.decryptData(alias, encryptedData, algorithm, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        try (Locker locker = this.getLocker().acquireLock();){
            Key key = this.store.getKey(alias, pin);
            if (!(key instanceof PrivateKey)) return null;
            PrivateKey privKey = (PrivateKey)key;
            byte[] byArray = UtilsPki.decipherData(encryptedData, this.store.getProvider(), privKey, algorithm);
            return byArray;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)e);
        }
        return null;
    }

    protected abstract String getLockString();

    public static Locker getLocker(PKCS11Type type) {
        return LockerImpl.get((String)type.name());
    }

    @Override
    public Locker getLocker() {
        return LockerImpl.get((String)this.getLockString());
    }

    protected abstract PKCS11Type getType();

    @Override
    public String getName() {
        switch (this.getType()) {
            case VAULT_HSM: {
                return "Vault";
            }
            case ANFP11: {
                return "ANF";
            }
            case Bit4id: {
                return "Bit4id";
            }
            case SafeNet: {
                return "SafeNet";
            }
            case ST: {
                return "ST";
            }
            case DNI: {
                return "DNIe";
            }
            case IDEMIA: {
                return "IDEMIA";
            }
        }
        return Confis.get().getString("unknown", new Object[0]);
    }

    public void initToken() {
        this.getP11().initToken(this.slot, this.token.getPINManufacturer(), this.token.getPINSOManufacturer(), this.token.getPINSODefault(), this.token.getLabelToken());
    }

    public void initUserToken() {
        try {
            this.initUserToken(null);
        }
        catch (PINLOCKEDException e1) {
            if (e1.isPuk()) {
                String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                throw e1;
            }
        }
        catch (PINNotInitialized e1) {
            try {
                this.getP11().unlockPIN(this.slot, this.token.getPINSODefault(), new String(this.getInitPIN()));
                log.info((Object)"initUserToken finish with initChecked = true");
                this.initChecked = true;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public boolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        try (Locker locker = this.getLocker().acquireLock();){
            this.initChecked = false;
            this.getP11().unlockPIN(this.slot, this.token.getPINSODefault(), new String(pinArray));
            this.initChecked = false;
        }
        catch (IOException e) {
            throw new LockException((Throwable)e);
        }
        return true;
    }

    public P11Manager getP11() {
        return this.getP11Provider().getToken().p11();
    }

    public void initUserToken(char[] pin) throws NOPINException, PINLOCKEDException, PINNotInitialized {
        if (!this.initChecked) {
            log.info((Object)("initUserToken " + this.slot + " " + this.getName()));
            try (Locker locker = this.getLocker().acquireLock();){
                AuthInfoImpl auth = this.getCounterInfo();
                if (auth != null && auth.getPinCounter() >= this.MAX_PIN) {
                    if (auth.getPukCounter() >= this.MAX_PUK) {
                        throw new PINLOCKEDException(false);
                    }
                    throw new PINLOCKEDException(true);
                }
                log.info((Object)"initUserToken finish with initChecked = true");
                this.initChecked = true;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (PKCS11Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected char[] getInitPIN() throws NOPINException {
        String devType = this.getName();
        String title = null;
        title = this.getUSB() == null ? Confis.get().getString("initPINserial", devType, this.getSerialNumberToken()) : Confis.get().getString("initPINusb", devType, Character.valueOf(this.getUSB().getLetter()));
        String id = devType + "-" + this.getSerialNumberToken();
        return KeyBoardHandler.getPassword(id, title, true, false, this.getAuthHandler(new Object[0]));
    }

    @Override
    public void resetToken() throws NOPINException, PINLOCKEDException {
        this.initUserToken();
        try {
            Locker locker = this.getLocker().acquireLock();
            try {
                char[] password;
                this.logoutPKCS11();
                String title = Confis.get().getString("52", new Object[0]) + this.slot;
                try {
                    String id = this.getSerialNumberToken() + "-reset-token";
                    password = KeyBoardHandler.getPassword(id, title, true, false, this.getAuthHandler(new Object[0]));
                }
                catch (NOPINException e) {
                    KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                    if (locker != null) {
                        locker.close();
                    }
                    return;
                }
                this.getP11().initToken(this.slot, this.token.getPINSODefault(), new String(password), new String(password), this.token.getLabelToken());
                this.initChecked = false;
            }
            finally {
                if (locker != null) {
                    try {
                        locker.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changePIN(String alias) throws NOPINException, PINLOCKEDException {
        this.initUserToken();
        try (Locker locker = this.getLocker().acquireLock();){
            String id = this.slot + "-" + this.getKeyBoardId(alias) + "-old-pin";
            char[] old = KeyBoardHandler.getPassword(id, Confis.get().getString("53", new Object[0]) + this.slot + Confis.get().getString("54", new Object[0]) + this.getSerialNumberToken() + Confis.get().getString("55", new Object[0]), false, false, this.getAuthHandler(alias));
            id = this.slot + "-" + this.getKeyBoardId(alias) + "-new-pin";
            char[] newPIN = KeyBoardHandler.getPassword(id, Confis.get().getString("53", new Object[0]) + this.slot + Confis.get().getString("54", new Object[0]) + this.getSerialNumberToken() + Confis.get().getString("56", new Object[0]), true, false, this.getAuthHandler(alias));
            try {
                this.getP11().changePIN(this.slot, new String(old), new String(newPIN));
                Arrays.fill((char[])newPIN, (char)' ');
                this.initChecked = false;
                boolean bl = true;
                return bl;
            }
            catch (PKCS11Exception e) {
                boolean bl2;
                block11: {
                    KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                    bl2 = false;
                    if (locker == null) break block11;
                    locker.close();
                }
                return bl2;
            }
        }
        catch (HeadlessException | IOException e2) {
            log.error((Object)e2);
            return false;
        }
    }

    @Override
    public TokenInfo getTokenInfo() {
        return new PKCS11TokenInfo(this.getP11TokenInfo());
    }

    public CK_TOKEN_INFO getP11TokenInfo() {
        if (this.slot != -1L) {
            CK_TOKEN_INFO cK_TOKEN_INFO;
            block9: {
                Locker locker = TKManagerPKCS11.getLocker(this.getType()).acquireLock();
                try {
                    cK_TOKEN_INFO = this.getP11Provider().getToken().p11().getTokenInfo(this.slot);
                    if (locker == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (locker != null) {
                            try {
                                locker.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                locker.close();
            }
            return cK_TOKEN_INFO;
        }
        return null;
    }

    public CK_SLOT_INFO getSlotInfo(PKCS11Type type) {
        if (this.slot != -1L) {
            CK_SLOT_INFO cK_SLOT_INFO;
            block9: {
                Locker locker = TKManagerPKCS11.getLocker(type).acquireLock();
                try {
                    cK_SLOT_INFO = this.getP11().getSlotInfo(this.slot);
                    if (locker == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (locker != null) {
                            try {
                                locker.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
                locker.close();
            }
            return cK_SLOT_INFO;
        }
        return null;
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    protected void login(LoginAction act, char[] pin) throws Throwable {
        String serial = this.getSerialNumberToken();
        log.info((Object)("getKeyStorePKCS11 slot:" + this.slot + " serial:" + serial));
        this.initUserToken();
        if (act == null) {
            act = new LoginAction(this.store);
        }
        if (pin != null) {
            act.apply(new PrivateKeyLogin(pin));
        } else {
            AuthInfoImpl auth = this.getCounterInfo();
            if (auth != null && auth.getPinCounter() >= this.MAX_PIN) {
                if (auth.getPukCounter() >= this.MAX_PUK) {
                    String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                    KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                    throw new PINLOCKEDException(false);
                }
                this.onPINLocked(auth, null);
            }
            String title = this.getKeyBoardTitleForLoadKeyStore(serial);
            String id = serial;
            if (this.onIncorrectPIN != null) {
                this.onIncorrectPIN.setShowMessages(true);
            }
            KeyBoardHandler.checkPassword(id, title, act, false, false, this.getAuthHandler(new Object[0]), null, this.getStartCounter(), this.MAX_PIN, this.onIncorrectPIN);
        }
    }

    private String getKeyBoardTitleForLoadKeyStore(String serial) {
        String title = Confis.get().getString("accessStorePKCS11", new Object[0]) + " " + this.deviceType() + " " + this.getName() + " ";
        title = this.getUSB() == null ? title + Confis.get().getString("withSerial", new Object[0]) + serial : title + Confis.get().getString("ofDevice", new Object[0]) + this.getUSB().getLetter();
        return title;
    }

    protected String deviceType() {
        return "HSM";
    }

    private void checkInitStateOnError() {
        AuthInfoImpl auth;
        if (this instanceof TKManagerANFP11 && (auth = this.getCounterInfo()).getPinCounter() == 0 && auth.getPukCounter() == 0) {
            this.initChecked = false;
            throw new PINNotInitialized();
        }
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    @Override
    public void saveStore() {
    }

    @Override
    public boolean verifyData(String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        boolean bl;
        block8: {
            Locker locker = this.getLocker().acquireLock();
            try {
                bl = UtilsPki.verifyData(data, signedData, this.getPublicKey(alias), signAlgorithm, Security.getProvider("BC"));
                if (locker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        try {
                            locker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new ANFVerifySignatureException(e);
                }
            }
            locker.close();
        }
        return bl;
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
        this.initUserToken();
        try {
            Certificate[] chain = this.buildImportChain(certs);
            log.info((Object)("import key cert:" + alias));
            this.login(new LoginAction(this.store), null);
            try (Locker locker = this.getLocker().acquireLock();
                 LockerImpl smartCardLock = CardDetector.acquireLock();){
                PrivateKey key = (PrivateKey)this.store.getKey(alias, null);
                if (key == null) {
                    throw new KeyStoreException("no se puede obtener la llave privada a partir del PIN introducido");
                }
                this.store.setKeyEntry(alias, key, null, chain);
            }
        }
        catch (PKCS11Exception e) {
            log.error((Object)e);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    private X509Certificate[] buildImportChain(X509Certificate[] certs) {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        X509Certificate cert = certs[CertUtils.getFinalCert((X509Certificate[])certs)];
        certList.add(cert);
        X509Certificate issuerCA = null;
        do {
            if ((issuerCA = CertUtils.getIssuerCertificate((X509Certificate)cert)) == null) {
                issuerCA = CertUtils.getIssuerCertificate((X509Certificate[])certs, (X509Certificate)cert);
            }
            if (this.importCA() && issuerCA != null) {
                certList.add(issuerCA);
            }
            cert = issuerCA;
        } while (issuerCA != null && !CertUtils.isSelfSigned((X509Certificate)issuerCA));
        return certList.toArray(new X509Certificate[0]);
    }

    protected boolean importCA() {
        return false;
    }

    @Override
    public void removeCertificate(String alias) throws Throwable {
        this.initUserToken();
        log.info((Object)(Confis.get().getString("61", new Object[0]) + alias));
        this.login(new LoginAction(this.store), null);
        try (Locker locker = this.getLocker().acquireLock();
             LockerImpl smartCardLock = CardDetector.acquireLock();){
            Key key = this.store.getKey(alias, null);
            if (key != null) {
                this.store.deleteEntry(alias);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    @Override
    protected void removeCertificateForced(String alias) {
        super.removeCertificateForced(alias);
    }

    @Override
    public char[] getPIN(String alias) {
        char[] password = null;
        try {
            X509Certificate cert = this.getCertificate(alias);
            if (cert != null) {
                String id = this.getKeyBoardId(alias);
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("26", new Object[0]) + new DatosPersonales(cert.getSubjectX500Principal()).getCN(), false, false, this.getAuthHandler(alias));
                Key key = this.store.getKey(alias, password);
                if (key != null) {
                    return password;
                }
            }
        }
        catch (Throwable e) {
            throw new PKCS11ProviderException(e);
        }
        return null;
    }

    public long getSlot() {
        return this.slot;
    }

    @Override
    public SecretKey generateSecretKey(int byteLength) throws NOPINException, PINLOCKEDException {
        this.initUserToken();
        try {
            byte[] key = this.getP11().generateSecretKey(this.slot, byteLength);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            return skeySpec;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) {
        return null;
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        String alias = null;
        if (data != null && data.length > 0) {
            alias = data[0].toString();
        }
        return new AuthHandlerImpl(this, alias);
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + Confis.get().getString("importAliasP11", new Object[0]) + this.getName();
        return title;
    }

    @Override
    protected boolean supportPUK() {
        return false;
    }

    @Override
    public boolean isHSM() {
        return true;
    }

    protected final class LoginAction
    implements LoginActionGeneric<KeyStore> {
        private KeyStore loginStore;

        public LoginAction(KeyStore loginStore) {
            this.loginStore = loginStore;
        }

        @Override
        public LoginResult<KeyStore> apply(PrivateKeyLogin login) {
            char[] pass = login.getPin();
            try (Locker locker = TKManagerPKCS11.this.getLocker().acquireLock();
                 LockerImpl smartCardLock = CardDetector.acquireLock();){
                log.info((Object)"antes de hacer login PKCS11");
                this.loginStore.load(null, pass);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new ANFLoginException((Throwable)e);
            }
            log.info((Object)"login PKCS11 OK");
            return new LoginResult<KeyStore>(this.loginStore);
        }
    }

    protected static interface LoginActionGeneric<R>
    extends Function<PrivateKeyLogin, LoginResult<R>> {
    }
}

