/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.PKCS11Type;
import com.anf.cryptotoken.tkmanager.TKManagerPKCS11;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.token.detect.impl.CardDetector;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.provider.JNAProvider;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class TKManagerDNI
extends TKManagerPKCS11 {
    private static final Logger log = Logger.getLogger(TKManagerDNI.class);
    private P11Manager p11;
    private Map<String, X509Certificate[]> certMap = new TreeMap<String, X509Certificate[]>();
    private boolean loaded = false;

    protected TKManagerDNI(P11Manager p11, long slot) throws KeyStoreException, IOException {
        super(p11, slot, false);
        this.p11 = p11;
        this.MAX_PIN = 3;
        this.MAX_PUK = 1;
    }

    @Override
    public KeyStore getKeyStore() {
        KeyStore store = null;
        try (Locker locker = this.getLocker().acquireLock();
             LockerImpl smartCardLock = CardDetector.acquireLock();){
            store = this.loadStore(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return store;
    }

    private KeyStore loadStore(int retries) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store;
        try {
            log.info((Object)("cargando store del DNI del slot " + this.slot + " intento " + retries));
            JNAProvider provider = new JNAProvider(new P11Manager(this.p11.getDllModule()), this.slot);
            store = KeyStore.getInstance("PKCS11", (Provider)provider);
            store.load(null, null);
        }
        catch (Exception e) {
            if (retries >= 3) {
                throw e;
            }
            log.info((Object)("dio error cargar el store del DNI: " + e.getMessage() + ", esperando unos segundos para reintentar"));
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            store = this.loadStore(retries + 1);
        }
        return store;
    }

    @Override
    public synchronized Enumeration<String> getAlias() {
        if (this.loaded) {
            return Collections.enumeration(this.certMap.keySet());
        }
        return this.useKeyStoreLocking(keyStore -> {
            try {
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate[] certs = keyStore.getCertificateChain(alias);
                    if (certs == null) continue;
                    X509Certificate[] chain = CertUtils.toX509((Certificate[])certs);
                    this.certMap.put(alias, chain);
                }
                this.loaded = true;
                return keyStore.aliases();
            }
            catch (KeyStoreException e) {
                log.error((Object)"error listando aliases", (Throwable)e);
                return Collections.emptyEnumeration();
            }
        });
    }

    @Override
    public synchronized X509Certificate getCertificate(String alias) {
        X509Certificate[] chain = this.certMap.get(alias);
        int finalCert = -1;
        if (chain != null && (finalCert = CertUtils.getFinalCert((X509Certificate[])chain)) != -1) {
            return chain[finalCert];
        }
        return this.useKeyStoreLocking(keyStore -> {
            try {
                return (X509Certificate)keyStore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                log.error((Object)("error al cargar el certificado con alias " + alias), (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] cachedChain = this.certMap.get(alias);
        if (cachedChain != null) {
            return cachedChain;
        }
        return this.useKeyStoreLocking(keyStore -> {
            Certificate[] certs = null;
            try {
                certs = keyStore.getCertificateChain(alias);
            }
            catch (KeyStoreException e) {
                log.error((Object)("error cargando los certificados del alias " + alias), (Throwable)e);
            }
            if (certs == null) {
                return null;
            }
            X509Certificate[] chain = CertUtils.toX509((Certificate[])certs);
            chain = CertUtils.fillChain((X509Certificate[])chain);
            return chain;
        });
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm) {
        return this.signData(alias, data, signAlgorithm, null);
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        return this.useKeyStoreLocking(keyStore -> this.sign(alias, data, signAlgorithm, pin, (KeyStore)keyStore));
    }

    private byte[] sign(String alias, byte[] data, String signAlgorithm, char[] pin, KeyStore keyStore) {
        try {
            this.login(new TKManagerPKCS11.LoginAction(this, keyStore), pin);
            PrivateKey key = (PrivateKey)keyStore.getKey(alias, pin);
            log.info((Object)"llave privada del DNI cargada, firmando...");
            try {
                return UtilsPki.signData(data, key, signAlgorithm, keyStore.getProvider());
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().equals("CKR_USER_NOT_LOGGED_IN")) {
                    return this.sign(alias, data, signAlgorithm, pin, keyStore);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            throw new ANFPrivateKeyException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R useKeyStoreLocking(Function<KeyStore, R> action) {
        try (LockerImpl lock = LockerImpl.lock((String)"dni-pkcs11");){
            R r = action.apply(this.getKeyStore());
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected PKCS11Type getType() {
        return PKCS11Type.DNI;
    }

    @Override
    protected String getLockString() {
        return "dni";
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        return null;
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return ProfilePolicy.isQSCD((ProfilePolicy)profile);
    }

    @Override
    public boolean isHSM() {
        return true;
    }
}

