/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.CriticalAccesNotConnected;
import com.anf.cryptotoken.api.tkmanager.exception.KeyPairException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManagerAbstract;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.controller.impl.AuthHandlerImpl;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBFactory;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.utils.OSUtils;
import com.anf.utils.SerialUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.x500.X500Principal;

public class TKManagerCritAcces
extends TKManagerAbstract {
    private static final Logger log = Logger.getLogger(TKManagerCritAcces.class);
    private static final String KEYSTORE_TYPE = "UBER";
    private String passwordStore = "";
    private File storePath;
    private static final char s = File.separatorChar;
    public static final String PLUGSIGN = "PlugAndSign";
    public static final String CRITICALACCES = "CriticalAcces";
    public static final String DIR = "jre" + s + "bin";
    public static final String FILE = "appmgmts.dll";
    public static final String RUTA_PS = "PlugAndSign" + s + DIR + s + "appmgmts.dll";
    public static final String RUTA_CA = "CriticalAcces" + s + DIR + s + "appmgmts.dll";

    public TKManagerCritAcces(USB usb, File path) throws Exception {
        this.usb = usb;
        this.storePath = path;
        this.passwordStore = usb.getUUID() + "ef5h13tg";
        this.loadStore(usb, path);
    }

    public void importKeyAndCert(File pfx, String pass, X509Certificate cert, String palias) throws NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NOPINException, InterruptedException, Exception {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            FileInputStream in = new FileInputStream(pfx);
            ks.load(in, null);
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Key key = ks.getKey(alias, pass.toCharArray());
                if (key == null || !(key instanceof PrivateKey) || cert == null) continue;
                X509Certificate[] chain = new X509Certificate[]{cert};
                if (!CertUtils.isSelfSigned((X509Certificate)cert)) {
                    chain = CertUtils.buildChain((X509Certificate[])chain);
                }
                String title = this.getImportTitle(palias);
                this.saveKeyPairInStore(title, palias, chain, (PrivateKey)key, -1);
                return;
            }
        }
        catch (CriticalAccesNotConnected | PINLOCKEDException | IOException | IllegalStateException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error((Object)e);
        }
    }

    public TKManagerCritAcces(File mountPoint, String unitUUID) throws Exception {
        this.storePath = new File(mountPoint, RUTA_PS);
        if (this.storePath.getParentFile() != null) {
            this.storePath.getParentFile().mkdirs();
        }
        TKManagerCritAcces.createFile(this.storePath);
        TKManagerCritAcces.copyFile(this.storePath);
        this.usb = USBFactory.newUSB((String)mountPoint.getCanonicalPath(), (String)unitUUID);
        this.passwordStore = this.usb.getUUID() + "ef5h13tg";
        this.store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        this.store.load(null, unitUUID.toCharArray());
    }

    public void exportToJKS(File jks, String uuid, String pass) throws Exception {
        AgregarProveedor.agregarBouncyCastleProvider();
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(null, null);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = store.getCertificateChain(alias);
                Certificate[] chain2 = CertUtils.toX509((Certificate[])chain);
                CertUtils.sortChain((X509Certificate[])chain2);
                PrivateKey pk = this.getPrivateKeyStore(alias);
                store.setKeyEntry(alias, pk, pass.toCharArray(), chain2);
            }
            store.store(new FileOutputStream(jks), uuid.toCharArray());
        }
        catch (NOPINException | PINLOCKEDException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error((Object)e);
        }
    }

    public static USB getUSB(char letter) {
        try {
            String unit = letter + ":" + File.separator;
            String serial = SerialUtils.getSerialNumber((String)unit);
            return USBFactory.newUSB((String)unit, (String)serial);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private static void copyStore(String pass, KeyStore store, KeyStore ps) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                Key key = store.getKey(alias, pass.toCharArray());
                Certificate[] certs = store.getCertificateChain(alias);
                if (key == null || certs == null) continue;
                ps.setKeyEntry(alias, key, pass.toCharArray(), certs);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static void createFile(File f) throws IOException {
        if (!f.exists()) {
            File parent = new File(f.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            f.createNewFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File outf) throws FileNotFoundException, IOException {
        try (FileOutputStream out = new FileOutputStream(outf);){
            SecureRandom sec = new SecureRandom(new byte[]{(byte)System.nanoTime()});
            byte[] buffer = new byte[(int)(164000L + (long)sec.nextInt(1000))];
            sec.nextBytes(buffer);
            out.write(buffer);
        }
    }

    private void loadStore(USB usb, File path) {
        this.usb = usb;
        AgregarProveedor.agregarBouncyCastleProvider();
        String pass = this.passwordStore;
        this.store = this.loadStore(path, pass);
        this.storePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(File path, String pass) {
        try {
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
            if (path.exists()) {
                try (RandomAccessFile randFile = new RandomAccessFile(path, "rw");){
                    randFile.seek(TKManagerCritAcces.getAliasSerialMapPoint());
                    int length = randFile.readInt();
                    if (length > 0 && (long)length < TKManagerCritAcces.getAccessPoint() - TKManagerCritAcces.getAliasSerialMapPoint()) {
                        byte[] aliasSerialMapBytes = new byte[length];
                        randFile.readFully(aliasSerialMapBytes);
                        this.loadAliasSerialMap(aliasSerialMapBytes);
                    } else {
                        log.error((Object)"No se puede leer la informacion de PUK");
                    }
                    randFile.seek(TKManagerCritAcces.getAccessPoint());
                    int storeLength = randFile.readInt();
                    if (storeLength <= 0 || (long)storeLength > randFile.length() - TKManagerCritAcces.getAccessPoint()) {
                        log.error((Object)("no se puede leer el almacen de llaves, storeLength=" + storeLength));
                        throw new KeyStoreException("ERROR:KeyStore can't be read");
                    }
                    byte[] data = new byte[storeLength];
                    randFile.readFully(data);
                    ByteArrayInputStream dataInput = new ByteArrayInputStream(data);
                    store.load(dataInput, pass.toCharArray());
                    log.info((Object)"El almacen de llaves se cargo correctamente");
                    this.updatePUKData(randFile, store, TKManagerCritAcces.getAliasSerialMapPoint());
                }
            } else {
                log.error((Object)("el archivo del store: " + path + " no existe"));
                throw new KeyStoreException("ERROR:KeyStore file doesn't exist");
            }
            return store;
        }
        catch (Exception e) {
            throw new ANFKeyStoreException("ERR_LOAD_STORE", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePUKData(RandomAccessFile randFile, KeyStore store, long point) {
        log.info((Object)"updatePUKData");
        try {
            Enumeration<String> aliases = store.aliases();
            KeyBoardHandler.setCheck(Confis.get().getString("useForAll", new Object[0]));
            String puk = null;
            boolean doUpdate = false;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (this.aliasSerialMap.get(alias) != null) continue;
                log.info((Object)("updatePUKData: el alias:" + alias + " no tiene informacion de PUK"));
                try {
                    Certificate[] certChain = store.getCertificateChain(alias);
                    X509Certificate[] chain = CertUtils.sortChain((X509Certificate[])CertUtils.toX509((Certificate[])certChain));
                    String title = Confis.get().getString("insertPUKofCert", new Object[0]);
                    String serial = chain[CertUtils.getFinalCert((X509Certificate[])chain)].getSerialNumber().toString();
                    if (puk == null || !KeyBoardHandler.isUseCheck()) {
                        String id = this.getPukId(serial, alias);
                        puk = new String(KeyBoardHandler.getPasswordForCertificates(id, chain, title, true, true, this.getAuthHandler(alias)));
                    }
                    this.updateAliasSerialMap(alias, serial, puk, null);
                    if (!KeyBoardHandler.isUseCheck()) {
                        puk = null;
                    }
                    doUpdate = true;
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            if (doUpdate) {
                log.info((Object)"updatePUKData: se actualiza el archivo");
                byte[] saveAliasSerialMap = this.saveAliasSerialMap();
                randFile.seek(point);
                randFile.writeInt(saveAliasSerialMap.length);
                randFile.write(saveAliasSerialMap);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            KeyBoardHandler.setCheck(null);
        }
    }

    public KeyStore extractStore(String alias, char[] pin) throws Exception {
        AgregarProveedor.agregarBouncyCastleProvider();
        try {
            KeyStore st = this.getKeyStore();
            Key key = st.getKey(alias, pin);
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
            Certificate[] chain = st.getCertificateChain(alias);
            store.setKeyEntry(alias, key, pin, chain);
            return store;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public void saveStore() {
        File path = this.storePath;
        KeyStore store = this.store;
        String pass = this.passwordStore;
        this.saveStore(path, store, pass);
    }

    public void saveStore(File path, KeyStore store, String pass) {
        log.info((Object)("TKManagerCritAcces.saveStore(" + path + ")"));
        if (path == null) {
            return;
        }
        String absoluteFile = path.getAbsolutePath();
        File file = new File(absoluteFile);
        long lastModif = file.lastModified();
        try (RandomAccessFile randFile = new RandomAccessFile(absoluteFile, "rw");){
            byte[] saveAliasSerialMap = this.saveAliasSerialMap();
            randFile.seek(TKManagerCritAcces.getAliasSerialMapPoint());
            randFile.writeInt(saveAliasSerialMap.length);
            randFile.write(saveAliasSerialMap);
            byte[] storeData = TKManagerCritAcces.toByteArray(store, pass);
            randFile.seek(TKManagerCritAcces.getAccessPoint());
            randFile.writeInt(storeData.length);
            randFile.write(storeData);
            log.info((Object)("TKManagerCritAcces.saveStore(" + path + ") salvado correctamente"));
        }
        catch (Exception e) {
            throw new ANFKeyStoreException("ERR_SAVE_STORE", (Throwable)e);
        }
        finally {
            file.setLastModified(lastModif);
        }
    }

    public static byte[] toByteArray(KeyStore store, String pass) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        ByteArrayOutputStream storeDataStream = new ByteArrayOutputStream();
        store.store(storeDataStream, pass.toCharArray());
        byte[] storeData = storeDataStream.toByteArray();
        return storeData;
    }

    @Override
    public String getPrPath() {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.getPrivateKeyStore(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logWrongPassError(KeyStore ks, char[] c, String alias) {
        block18: {
            File f = new File(Files.anf(), "wrong_pass.log.txt");
            try (PrintWriter out = null;){
                f.createNewFile();
                out = new PrintWriter(f);
                out.println("serial number is: " + this.getSerialNumberToken());
                out.println("requested alias was: " + new String(c));
                out.println("entered password was: " + new String(c));
                if (ks == null) {
                    out.println("key store is null");
                } else {
                    out.println("---------key store information---------");
                    Enumeration<String> aliases = ks.aliases();
                    out.println("<aliases>");
                    while (aliases.hasMoreElements()) {
                        String aliasi = aliases.nextElement();
                        out.println("<alias " + aliasi + ">");
                        out.println("<certificate>");
                        Certificate[] chain = ks.getCertificateChain(aliasi);
                        X509Certificate[] certs = CertUtils.toX509((Certificate[])chain);
                        for (int i = 0; i < certs.length; ++i) {
                            out.println("<cert " + i + ">");
                            out.println(certs[i].toString());
                            out.println("</cert>");
                        }
                        out.println("</certificate>");
                    }
                    out.println("</aliases>");
                    out.println("---------key store information---------");
                }
                KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
                out.println("load keystore from: " + this.storePath);
                out.println("with store password: " + this.passwordStore);
                if (this.storePath.exists()) {
                    out.println("storePath exists");
                    try (RandomAccessFile randFile = new RandomAccessFile(this.storePath, "rw");){
                        randFile.seek(TKManagerCritAcces.getAccessPoint());
                        int storeLength = randFile.readInt();
                        if (storeLength <= 0 || (long)storeLength > randFile.length() - TKManagerCritAcces.getAccessPoint()) {
                            out.println("ERROR:KeyStore can't be read (storeLength=" + storeLength);
                        } else {
                            byte[] data = new byte[storeLength];
                            randFile.readFully(data);
                            ByteArrayInputStream dataInput = new ByteArrayInputStream(data);
                            store.load(dataInput, this.passwordStore.toCharArray());
                            out.println("---------loaded key store information---------");
                            Enumeration<String> aliases = store.aliases();
                            out.println("<aliases>");
                            while (aliases.hasMoreElements()) {
                                String aliasi = aliases.nextElement();
                                out.println("<alias " + aliasi + ">");
                                out.println("<certificate>");
                                Certificate[] chain = store.getCertificateChain(aliasi);
                                X509Certificate[] certs = CertUtils.toX509((Certificate[])chain);
                                for (int i = 0; i < certs.length; ++i) {
                                    out.println("<cert " + i + ">");
                                    out.println(certs[i].toString());
                                    out.println("</cert>");
                                }
                                out.println("</certificate>");
                            }
                            out.println("</aliases>");
                            out.println("---------loaded key store information---------");
                        }
                        break block18;
                    }
                }
                out.println("storePath NOT exists");
            }
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) {
        try {
            return this.store.getCertificate(alias).getPublicKey();
        }
        catch (Throwable e) {
            throw new ANFCertificateException();
        }
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", this.store.getProvider());
            kpg.initialize(keySize);
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairException((Throwable)e);
        }
    }

    @Override
    protected String getImportTitle(String alias) {
        String title = Confis.get().getString("importAlias", new Object[0]) + Confis.get().getString("importAliasPS", new Object[0]) + this.getUSB().getLetter();
        return title;
    }

    @Override
    public void reloadToken() {
        this.loadStore(this.usb, this.storePath);
    }

    @Override
    public void resetToken() {
        throw new UnsupportedOperationException(Confis.get().getString("30", new Object[0]));
    }

    @Override
    public String getSerialNumberToken() {
        return this.usb != null ? this.usb.getUUID() : null;
    }

    public void export(String alias, String password, File outputFile) throws Exception {
        try {
            PrivateKey privateKey = this.getPrivateKeyStore(alias);
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            Certificate certificate = store.getCertificate(alias);
            X509Certificate mainCert = (X509Certificate)certificate;
            X500Principal datosPersonales = mainCert.getSubjectX500Principal();
            DatosPersonales dpSubject = new DatosPersonales(datosPersonales);
            String cn = dpSubject.getCN();
            Certificate[] cert = new Certificate[]{certificate};
            store.setKeyEntry(cn, privateKey, null, cert);
            FileOutputStream out = new FileOutputStream(outputFile);
            store.store(out, password.toCharArray());
            out.close();
        }
        catch (IOException | NoSuchProviderException | CertificateException ex) {
            log.error((Object)ex);
        }
    }

    public String getPassword() {
        return this.passwordStore;
    }

    public File getStorePath() {
        return this.storePath;
    }

    private static long getAccessPoint() {
        return 12600L;
    }

    private static long getAliasSerialMapPoint() {
        return 5600L;
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    public LockerImpl getLocker() {
        Object id = this.usb.getUUID();
        if (OSUtils.isWindows()) {
            id = "" + this.usb.getLetter();
        }
        return LockerImpl.get((String)("plugandsign-" + (String)id));
    }

    @Override
    public void removeCertificate(String alias) throws Throwable {
        PrivateKey pk = this.getPrivateKey(alias);
        if (pk != null) {
            super.removeCertificate(alias);
            this.saveStore();
        }
    }

    @Override
    public AuthHandler getAuthHandler(Object ... data) {
        String alias = null;
        if (data != null && data.length > 0) {
            alias = data[0].toString();
        }
        return new AuthHandlerImpl(this, alias);
    }

    @Override
    protected boolean supportPUK() {
        return true;
    }
}

