/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.KeyPairException;
import com.anf.cryptotoken.api.tkmanager.exception.PFXStoreException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.pkcs10.PKCS10Creator;
import com.anf.pkcs10.PKCS10CreatorFactory;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public abstract class TKManagerCommon
implements TKManager {
    private static final Logger log = Logger.getLogger(TKManagerCommon.class);
    private PKCS10Creator pkcs10Creator = PKCS10CreatorFactory.defaultPKCS10Creator();
    private String commonKeyBoardId;

    protected abstract String getImportTitle(String var1);

    protected byte[] createPKCS10(ASN1Set attributes, String signAlg, X500Principal subjectX500Principal, PublicKey publicKey, Provider provider, PrivateKey privateKey) {
        return this.pkcs10Creator.createPKCS10(attributes, signAlg, subjectX500Principal, publicKey, provider, privateKey);
    }

    @Override
    public Signature getSignatureInstance(String signAlg) {
        return UtilsPki.getSignature(signAlg, this.getProvider());
    }

    @Override
    public Locker lock() {
        return this.getLocker().acquireLock();
    }

    @Override
    public void unlock(Locker locker) {
        locker.releaseLock();
    }

    @Override
    public List<String> importPFX(File pfx, char[] password) {
        this.checkWriteSupported();
        String id = System.nanoTime() + "-" + pfx.getName() + "-pass";
        ArrayList<String> aliasesOK = new ArrayList<String>();
        try {
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            if (password == null) {
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("PINPFX", new Object[0]), false, false, null);
            }
            store.load(new FileInputStream(pfx), password);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] chain = store.getCertificateChain(alias);
                X509Certificate[] x509 = CertUtils.toX509((Certificate[])chain);
                Key key = store.getKey(alias, password);
                X509Certificate[] cad = x509;
                cad = CertUtils.buildChain((X509Certificate[])cad);
                String temp = alias;
                SecureRandom rand = new SecureRandom(UUID.randomUUID().toString().getBytes());
                int i = 0;
                do {
                    temp = new BigInteger(20, rand).toString();
                    if (i++ <= 10) continue;
                    throw new Exception("ERR_ALIAS_EXISTS");
                } while (this.getKeyStore().containsAlias(temp));
                alias = temp;
                String title = this.getImportTitle(alias);
                this.saveKeyPairInStore(title, alias, cad, (PrivateKey)key, -1);
                aliasesOK.add(alias);
            }
        }
        catch (Exception e) {
            throw new PFXStoreException("ERR_IMPORT_PFX", (Throwable)e);
        }
        finally {
            KeyBoardHandler.remove(id);
        }
        return aliasesOK;
    }

    protected KeyPair createKeyPair(String alias, int keySize) {
        KeyPair kp = null;
        if (this.containsAlias(alias)) {
            kp = this.getKeyPair(alias);
        } else {
            boolean generated = true;
            int c = 0;
            while (generated) {
                try {
                    kp = this.generateKeyPair(keySize);
                    generated = false;
                }
                catch (Exception ex) {
                    ++c;
                    log.error((Object)ex);
                }
                if (c != 10) continue;
                throw new KeyPairException("ERR_KEY_PAIR_GENERATION_FAILED");
            }
        }
        return kp;
    }

    @Override
    public byte[] generateRequest(String alias, X500Name x500Name, BigInteger serial, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlg) {
        byte[] byArray;
        block10: {
            Locker locker = this.getLocker().acquireLock();
            try {
                KeyPair kp;
                if (alias == null) {
                    alias = this.getNewValidAlias(x500Name);
                }
                if ((kp = this.createKeyPair(alias, keySize)) == null) {
                    throw new ANFKeyStoreException("ERR_GENERATE_KEY_PAIR");
                }
                JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(x500Name, serial, notBefore, notAfter, x500Name, kp.getPublic());
                byArray = this.generateCertificate(alias, kp, (X509v3CertificateBuilder)certGen, attributes, keySize, signAlg);
                if (locker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        try {
                            locker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ANFCertificateException("ERR_GENERATE_CSR", (Throwable)e);
                }
            }
            locker.close();
        }
        return byArray;
    }

    protected byte[] generateCertificate(String alias, KeyPair kp, X509v3CertificateBuilder certGen, ASN1Set attributes, int keySize, String signAlg) {
        X509Certificate autoSignedCertifcate = this.generateAutosignedCertificate(certGen, kp.getPrivate());
        String title = this.getCertCreationTitle();
        this.saveKeyPairInStore(title, alias, new X509Certificate[]{autoSignedCertifcate}, kp.getPrivate(), keySize);
        X500Principal subjectX500Principal = autoSignedCertifcate.getSubjectX500Principal();
        PublicKey publicKey = autoSignedCertifcate.getPublicKey();
        PrivateKey privateKey = kp.getPrivate();
        return this.createPKCS10(attributes, signAlg, subjectX500Principal, publicKey, this.getProvider(), privateKey);
    }

    protected X509Certificate generateAutosignedCertificate(X509v3CertificateBuilder certGen, PrivateKey privateKey) {
        X509Certificate cert;
        Provider prov = this.getProvider();
        try {
            Security.addProvider(prov);
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256withRSA").setProvider(prov).build(privateKey);
            cert = new JcaX509CertificateConverter().setProvider(Security.getProvider("BC")).getCertificate(certGen.build(sigGen));
            cert.checkValidity(new Date());
            cert.verify(cert.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | OperatorCreationException e) {
            throw new ANFCertificateException("ERR_GENERATE_SELF_SIGNED_CERT", e);
        }
        return cert;
    }

    protected String getCertCreationTitle() {
        String title = Confis.get().getString("importNewCert", new Object[0]);
        return title;
    }

    protected abstract KeyPair generateKeyPair(int var1) throws KeyStoreException;

    protected abstract void checkWriteSupported();

    public abstract void saveKeyPairInStore(String var1, String var2, X509Certificate[] var3, PrivateKey var4, int var5);

    @Override
    public void setPkcs10Creator(PKCS10Creator pkcs10Creator) {
        this.pkcs10Creator = pkcs10Creator;
    }

    protected String getKeyBoardId(String alias) {
        Object id = this.commonKeyBoardId;
        if (id == null) {
            id = this.getSerialNumberToken() + "-" + alias;
            if (this.getUSB() != null && this.getUSB().getLetter() != '\u0000') {
                id = (String)id + "-" + this.getUSB().getLetter();
            }
        }
        return "pin-" + (String)id;
    }

    protected String getPukId(String serial, String alias) {
        Object id = this.commonKeyBoardId;
        if (id == null) {
            id = serial + "-" + alias;
        }
        return "puk-" + (String)id;
    }

    @Override
    public void setCommonKeyBoardId(String id) {
        this.commonKeyBoardId = id;
    }

    public String getSerialCert(String alias) {
        Certificate[] certificates = this.getCertificateChain(alias);
        X509Certificate[] chain = CertUtils.toX509((Certificate[])certificates);
        chain = CertUtils.sortChain((X509Certificate[])chain);
        BigInteger certSn = chain[CertUtils.getFinalCert((X509Certificate[])chain)].getSerialNumber();
        String serial = certSn.toString();
        return serial;
    }
}

