/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateNotPresent;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.exception.WriteNotSupportedException;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManagerCommon;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.utils.DatosPersonales;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;

public abstract class TKManagerAbstractStore
extends TKManagerCommon {
    private static final Logger log = Logger.getLogger(TKManagerAbstractStore.class);
    protected KeyStore store;
    protected char[] pass;
    private static boolean useAlias = false;

    public void setPass(char[] pass) {
        this.pass = pass;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        try {
            return (X509Certificate)this.store.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new ANFCertificateException((Throwable)e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.getPrivateKey(alias, this.pass);
    }

    @Override
    public PrivateKey getPrivateKey(String alias, char[] pin) {
        try {
            if (alias != null) {
                alias = alias.trim();
            }
            return (PrivateKey)this.store.getKey(alias, pin);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ANFPrivateKeyException((Throwable)e);
        }
    }

    @Override
    public Enumeration<String> getAlias() {
        try {
            return this.getKeyStore().aliases();
        }
        catch (KeyStoreException e) {
            throw new ANFCertificateException("ERR_NO_ALIASES");
        }
    }

    @Override
    public boolean containsAlias(String alias) {
        try {
            return this.store.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certs;
            if (alias != null) {
                alias = alias.trim();
            }
            if ((certs = this.store.getCertificateChain(alias)) != null) {
                return CertUtils.sortChain((X509Certificate[])CertUtils.toX509((Certificate[])certs));
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new ANFCertificateException((Throwable)e);
        }
    }

    @Override
    public Provider getProvider() {
        return this.store.getProvider();
    }

    @Override
    public KeyStore getKeyStore() {
        return this.store;
    }

    public void store(OutputStream out) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.store.store(out, this.pass);
    }

    @Override
    public KeyPair getKeyPair(String alias) {
        try {
            Certificate cert = this.store.getCertificate(alias);
            PublicKey pubkey = cert != null ? cert.getPublicKey() : null;
            return new KeyPair(pubkey, (PrivateKey)this.store.getKey(alias, this.pass));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ANFPrivateKeyException();
        }
    }

    @Override
    public KeyPair getKeyPair(String alias, char[] pin) {
        X509Certificate cert = this.getCertificate(alias);
        PublicKey pubkey = cert != null ? cert.getPublicKey() : null;
        return new KeyPair(pubkey, this.getPrivateKey(alias, pin));
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        return UtilsPki.signData(data, this.getPrivateKey(alias, pin), signAlgorithm, this.store.getProvider());
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm) {
        return UtilsPki.signData(data, this.getPrivateKey(alias), signAlgorithm, this.store.getProvider());
    }

    @Override
    public boolean verifyData(String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        X509Certificate cert = this.getCertificate(alias);
        PublicKey pubKey = cert != null ? cert.getPublicKey() : null;
        return UtilsPki.verifyData(data, signedData, pubKey, signAlgorithm, this.store.getProvider());
    }

    @Override
    public byte[] encryptData(String alias, byte[] data, String algorithm) {
        try {
            Certificate cert = this.store.getCertificate(alias);
            PublicKey pubKey = cert != null ? cert.getPublicKey() : null;
            return UtilsPki.cipherData(data, this.store.getProvider(), pubKey, algorithm);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm) {
        return UtilsPki.decipherData(encryptedData, this.store.getProvider(), this.getPrivateKey(alias), algorithm);
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        return UtilsPki.decipherData(encryptedData, this.store.getProvider(), this.getPrivateKey(alias, pin), algorithm);
    }

    @Override
    public TokenInfo getTokenInfo() {
        return null;
    }

    @Override
    public int[] getCertificateCounts() {
        return new int[]{1000, 1000};
    }

    @Override
    public LinkedList<X509Certificate> getCertificates() {
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        Enumeration<String> listAlias = this.getAlias();
        while (listAlias.hasMoreElements()) {
            String alias = listAlias.nextElement();
            X509Certificate cert = this.getCertificate(alias);
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public SecretKey generateSecretKey(int byteLength) {
        try {
            AgregarProveedor.agregarBouncyCastleProvider();
            Provider provider = Security.getProvider("BC");
            KeyGenerator keygen = KeyGenerator.getInstance("AES", provider);
            keygen.init(byteLength * 8);
            keygen.init(new SecureRandom());
            return keygen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ANFKeyStoreException("ERR_GENERATE_SECRET_KEY", (Throwable)e);
        }
    }

    @Override
    protected KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", this.store.getProvider());
            kpg.initialize(keySize);
            log.info((Object)("generando par de llaves " + keySize + " RSA"));
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
        block5: {
            this.checkWriteSupported();
            try {
                PrivateKey key = (PrivateKey)this.store.getKey(alias, this.pass);
                if (key == null) break block5;
                Certificate[] chain = CertUtils.sortChain((X509Certificate[])certs);
                int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
                if (finalCert != -1) {
                    X509Certificate cert = chain[finalCert];
                    String cn = alias;
                    if (!useAlias) {
                        cn = new DatosPersonales(cert.getSubjectX500Principal()).getCN();
                        cn = cn.replace(" ", "_");
                    }
                    this.store.setKeyEntry(cn, key, this.pass, chain);
                    if (!alias.equals(cn)) {
                        log.info((Object)("eliminando entrada asociada a alias " + alias + ". ahora se usara la entrada asociada al alias " + cn));
                        this.store.deleteEntry(alias);
                    }
                    this.saveStore();
                    break block5;
                }
                throw new ANFCertificateException("ERR_USER_CERT_NOT_PRESENT");
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new ANFKeyStoreException("ERR_IMPORT_CERTIFICATE", (Throwable)e);
            }
        }
    }

    @Override
    public void saveKeyPairInStore(String title, String alias, X509Certificate[] certChain, PrivateKey privKey, int keySize) {
        this.checkWriteSupported();
        Certificate[] chain = CertUtils.sortChain((X509Certificate[])certChain);
        int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (finalCert != -1) {
            X509Certificate cert = chain[finalCert];
            Object cn = alias;
            if (!useAlias) {
                cn = new DatosPersonales(cert.getSubjectX500Principal()).getCN();
                cn = cn == null ? alias : ((String)cn).replace(" ", "_") + "_ID" + alias;
            }
            try {
                this.store.setKeyEntry((String)cn, privKey, this.pass, chain);
                this.saveStore();
            }
            catch (KeyStoreException e) {
                throw new ANFKeyStoreException("ERR_STORE_KEY_PAIR", (Throwable)e);
            }
        } else {
            throw new ANFCertificateNotPresent();
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) throws PINLOCKEDException {
        try {
            this.checkWriteSupported();
            KeyPair kp = this.createKeyPair(alias, keySize);
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(x500Name, serialCert, notBefore, notAfter, x500Name, kp.getPublic());
            X509Certificate cert = this.generateAutosignedCertificate((X509v3CertificateBuilder)certGen, kp.getPrivate());
            String cn = alias;
            if (!useAlias) {
                cn = new DatosPersonales(cert.getSubjectX500Principal()).getCN();
                cn = cn.replace(" ", "_");
            }
            this.store.setKeyEntry(cn, kp.getPrivate(), pass, new X509Certificate[]{cert});
            this.saveStore();
            return cert;
        }
        catch (Exception e) {
            throw new ANFKeyStoreException("ERR_CREATE_KEY_PAIR", (Throwable)e);
        }
    }

    @Override
    public void removeCertificate(String alias) {
        this.checkWriteSupported();
        try {
            this.store.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException("ERR_REMOVE_CERT", (Throwable)e);
        }
        this.saveStore();
    }

    @Override
    protected void checkWriteSupported() {
        if (!this.writeSupported()) {
            throw new WriteNotSupportedException();
        }
    }

    @Override
    public void saveStore() {
    }

    protected abstract boolean writeSupported();

    public static void setUseAlias(boolean useAlias) {
        TKManagerAbstractStore.useAlias = useAlias;
    }

    public static boolean isUseAlias() {
        return useAlias;
    }

    @Override
    public Locker lock() {
        return this.getLocker();
    }

    @Override
    public void unlock(Locker locker) {
    }
}

