/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.tkmanager;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFKeyStoreException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFPrivateKeyException;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.api.tkmanager.exception.PINLOCKEDException;
import com.anf.cryptotoken.api.tkmanager.exception.UnlockPINException;
import com.anf.cryptotoken.api.tkmanager.params.UnlockPINParams;
import com.anf.cryptotoken.api.token.TokenInfo;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.TKManagerCommon;
import com.anf.cryptotoken.tkmanager.TKManagerCritAcces;
import com.anf.cryptotoken.tkmanager.TKManagerSMI;
import com.anf.cryptotoken.tkmanager.controller.AuthHandler;
import com.anf.cryptotoken.tkmanager.dto.LoginResult;
import com.anf.cryptotoken.tkmanager.params.UnlockPINParamsImpl;
import com.anf.cryptotoken.tkmanager.utils.BLOQ_CIPHER_TYPE;
import com.anf.cryptotoken.tkmanager.utils.UtilsPki;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.utils.DatosPersonales;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public abstract class TKManagerAbstract
extends TKManagerCommon {
    private static final Logger log = Logger.getLogger(TKManagerAbstract.class);
    public static final long psFileLength = 164000L;
    protected KeyStore store;
    protected int MAX_PIN = 5;
    protected int MAX_PUK = 10;
    protected AbstractPINAction<Integer, Integer> onIncorrectPIN;
    protected USB usb;
    protected Map<String, AuthInfoImpl> aliasSerialMap = new TreeMap<String, AuthInfoImpl>();

    @Override
    public abstract PrivateKey getPrivateKey(String var1);

    public abstract PublicKey getPublicKey(String var1);

    protected abstract boolean supportPUK();

    @Override
    public void saveKeyPairInStore(String title, String alias, X509Certificate[] certChain, PrivateKey privKey, int keySize) {
        try {
            String id = this.getKeyBoardId(alias);
            Certificate[] chain = CertUtils.sortChain((X509Certificate[])certChain);
            char[] password = KeyBoardHandler.getPasswordForCertificates(id, (X509Certificate[])chain, title, true, false, this.getAuthHandler(alias));
            this.store.setKeyEntry(alias, privKey, password, chain);
            if (this.supportPUK()) {
                try {
                    title = Confis.get().getString("insertPUK", new Object[0]);
                    String serial = ((X509Certificate)chain[CertUtils.getFinalCert((X509Certificate[])chain)]).getSerialNumber().toString();
                    id = this.getPukId(serial, alias);
                    this.updateAliasSerialMap(alias, serial, new String(KeyBoardHandler.getPassword(id, title, true, true, null)), new String(password));
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            this.saveStore();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    @Override
    public void importCertificate(String alias, X509Certificate[] certs) {
        String title = this.getImportTitle(alias);
        String id = this.getKeyBoardId(alias);
        char[] password = KeyBoardHandler.getPasswordForCertificates(id, certs, title, false, false, this.getAuthHandler(alias));
        try {
            PrivateKey key = (PrivateKey)this.store.getKey(alias, password);
            if (key != null) {
                Certificate[] chain = CertUtils.sortChain((X509Certificate[])certs);
                this.store.setKeyEntry(alias, key, password, chain);
                AuthInfoImpl auth = this.aliasSerialMap.get(alias);
                if ((auth == null || auth.getPinEnc() == null) && this.supportPUK()) {
                    try {
                        title = Confis.get().getString("insertPUK", new Object[0]);
                        String serial = certs[CertUtils.getFinalCert((X509Certificate[])certs)].getSerialNumber().toString();
                        id = this.getPukId(serial, alias);
                        this.updateAliasSerialMap(alias, serial, new String(KeyBoardHandler.getPassword(id, title, false, true, null)), new String(password));
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                    }
                }
            } else {
                throw new ANFKeyStoreException("no se puede obtener la llave privada a partir del PIN introducido");
            }
            this.saveStore();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ANFKeyStoreException("ERR_IMPORT_CERTIFICATE", (Throwable)e);
        }
    }

    @Override
    public X509Certificate createCertAndKeyPair(String alias, X500Name x500Name, BigInteger serialCert, Date notBefore, Date notAfter, int keySize, char[] pass) throws PINLOCKEDException {
        try {
            KeyPair kp = this.createKeyPair(alias, keySize);
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(x500Name, serialCert, notBefore, notAfter, x500Name, kp.getPublic());
            X509Certificate cert = this.generateAutosignedCertificate((X509v3CertificateBuilder)certGen, kp.getPrivate());
            this.getKeyStore().setKeyEntry(alias, kp.getPrivate(), pass, new X509Certificate[]{cert});
            if (this.supportPUK()) {
                try {
                    String title = Confis.get().getString("insertPUK", new Object[0]);
                    String serial = cert.getSerialNumber().toString();
                    String id = this.getPukId(serial, alias);
                    this.updateAliasSerialMap(alias, serial, new String(KeyBoardHandler.getPassword(id, title, false, true, null)), new String(pass));
                }
                catch (Exception e1) {
                    log.error((Object)e1);
                }
            }
            this.saveStore();
            return cert;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public boolean changePIN(String alias) {
        X509Certificate[] chain = this.getCertificateChain(alias);
        X509Certificate cert = chain[CertUtils.getFinalCert((X509Certificate[])chain)];
        if (cert != null) {
            String device = this.usb != null ? "" + this.usb.getLetter() : this.getSerialNumberToken();
            try {
                PrivateKey privateKey = this.getPrivateKey(alias);
                if (privateKey == null) {
                    throw new ANFPrivateKeyException("ERR_PRIVATE_KEY_ACCESS");
                }
                Object id = this.getKeyBoardId(alias);
                KeyBoardHandler.remove((String)id);
                char[] newPIN = null;
                id = this.getKeyBoardId(alias) + "new-pin";
                newPIN = KeyBoardHandler.getPasswordForCertificates((String)id, chain, Confis.get().getString("inputPINCert", device), true, false, this.getAuthHandler(alias));
                char[] newPUK = null;
                id = this.getKeyBoardId(alias) + "new-puk";
                newPUK = KeyBoardHandler.getPassword((String)id, Confis.get().getString("insertPUK", new Object[0]), true, true, this.getAuthHandler(alias));
                boolean ok = this.changePin(alias, privateKey, newPIN, newPUK);
                this.saveStore();
                return ok;
            }
            catch (NOPINException e) {
                KeyBoardHandler.msg(Confis.get().getString("33", new Object[0]), Confis.get().getString("34", new Object[0]), 0);
                throw e;
            }
        }
        return false;
    }

    @Override
    public boolean changePIN(String alias, char[] old, char[] newPIN, char[] newPuk) {
        try {
            Key key = this.store.getKey(alias, old);
            return this.changePin(alias, key, newPIN, newPuk);
        }
        catch (Exception e) {
            KeyBoardHandler.msg(Confis.get().getString("39", new Object[0]), Confis.get().getString("ERROR", new Object[0]), 0);
            return false;
        }
    }

    private boolean changePin(String alias, Key key, char[] newPIN, char[] newPuk) {
        try {
            if (key != null) {
                X509Certificate[] x509;
                int finalCert;
                Certificate[] chain = this.store.getCertificateChain(alias);
                this.store.deleteEntry(alias);
                this.store.setKeyEntry(alias, key, newPIN, chain);
                if (this.supportPUK() && (finalCert = CertUtils.getFinalCert((X509Certificate[])(x509 = CertUtils.toX509((Certificate[])chain)))) != -1) {
                    X509Certificate cert = x509[finalCert];
                    this.updateAliasSerialMap(alias, cert.getSerialNumber().toString(), new String(newPuk), new String(newPIN));
                    return true;
                }
            } else {
                String t = Confis.get().getString("37", new Object[0]) + alias;
                KeyBoardHandler.msg(t, Confis.get().getString("ERROR", new Object[0]), 0);
            }
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException("ERR_CHANGE_PIN", (Throwable)e);
        }
        return false;
    }

    public static String getDefaultName() {
        Object name = "";
        name = (String)name + "SERIALNUMBER=1234,";
        name = (String)name + "EMAIL=pepe@pepe.com,";
        name = (String)name + "L=Barcelona,";
        name = (String)name + "ST=Barcelona,";
        name = (String)name + "C=ES,";
        name = (String)name + "CN=Aramis Rodriguez,";
        name = (String)name + "GIVENNAME=Eric";
        name = (String)name + "OU=Certificado Servidor Seguro SSL,";
        name = (String)name + "1.3.6.1.4.1.18838.1.1=X8958075N";
        return name;
    }

    @Override
    public void removeCertificate(String alias) throws Throwable {
        log.info((Object)(Confis.get().getString("61", new Object[0]) + alias));
        try {
            this.getKeyStore().deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException((Throwable)e);
        }
    }

    protected void removeCertificateForced(String alias) {
        try {
            this.getKeyStore().deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException("ERR_DELETE_KEY_FORCED", (Throwable)e);
        }
    }

    @Override
    public Enumeration<String> getAlias() {
        try {
            return this.getKeyStore().aliases();
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException("ERR_NO_ALIASES", (Throwable)e);
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        X509Certificate[] chain = this.getCertificateChain(alias);
        int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
        if (finalCert != -1) {
            return chain[finalCert];
        }
        return null;
    }

    protected PrivateKey getPrivateKeyStore(String alias) {
        try {
            Object title = "";
            Certificate[] certificates = this.getKeyStore().getCertificateChain(alias);
            X509Certificate[] chain = CertUtils.toX509((Certificate[])certificates);
            chain = CertUtils.sortChain((X509Certificate[])chain);
            title = Confis.get().getString("accessKey", new Object[0]);
            title = (String)title + Confis.get().getString("32", new Object[0]);
            title = this.getUSB() != null ? (String)title + this.getUSB().getLetter() + " (" + this.getName() + ")" : (String)title + Confis.get().getString("withSerial", new Object[0]) + this.getSerialNumberToken();
            Function act = login -> {
                String loginAlias = alias;
                char[] pin = login.getPin();
                try {
                    log.info((Object)"getPrivateKey login action acquire lock");
                    try {
                        LoginResult<Key> loginResult;
                        block17: {
                            Locker locker = this.getLocker().acquireLock();
                            try {
                                log.info((Object)"getPrivateKey login action lock acquired");
                                log.info((Object)("getPrivateKey loginStore.getKey alias " + loginAlias));
                                Key pk = this.getKeyStore().getKey(loginAlias, pin);
                                if (pk != null) {
                                    AuthInfoImpl auth = this.resetAliasAuth(loginAlias);
                                    if ((auth == null || auth.getPinEnc() == null) && this.supportPUK()) {
                                        try {
                                            String titlePuk = Confis.get().getString("insertPUK", new Object[0]);
                                            X509Certificate cert = (X509Certificate)this.getKeyStore().getCertificate(loginAlias);
                                            if (cert != null) {
                                                String serial = cert.getSerialNumber().toString();
                                                String id = this.getKeyBoardId(alias);
                                                this.updateAliasSerialMap(loginAlias, serial, new String(KeyBoardHandler.getPassword(id, titlePuk, false, true, null)), new String(pin));
                                            }
                                        }
                                        catch (Exception e1) {
                                            log.error((Object)e1);
                                        }
                                    }
                                    this.saveStore();
                                } else {
                                    log.info((Object)("null private key alias " + loginAlias));
                                }
                                log.info((Object)("return private key alias " + loginAlias));
                                loginResult = new LoginResult<Key>(pk);
                                if (locker == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (locker != null) {
                                    try {
                                        locker.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            locker.close();
                        }
                        return loginResult;
                    }
                    finally {
                        log.info((Object)("getPrivateKey release lock alias " + alias));
                    }
                }
                catch (Throwable e) {
                    this.logWrongPassError(pin, loginAlias);
                    log.error((Object)e);
                    return new LoginResult(e);
                }
            };
            int tries = this.MAX_PIN;
            BigInteger certSn = chain[CertUtils.getFinalCert((X509Certificate[])chain)].getSerialNumber();
            String serialCert = certSn.toString();
            this.onIncorrectPIN = new WrongPINAction(true, alias, serialCert);
            int start = this.getStartPinCounter(alias, serialCert);
            String id = alias + "-" + this.getSerialNumberToken();
            Key pke = (Key)KeyBoardHandler.checkPassword(id, (String)title, act, false, false, this.getAuthHandler(alias), chain, start, tries, this.onIncorrectPIN);
            return pke != null ? (PrivateKey)pke : null;
        }
        catch (NOPINException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ANFPrivateKeyException(e);
        }
    }

    private int getStartPinCounter(String alias, String serialCert) throws IOException {
        int start = 0;
        try (Locker locker = this.getLocker();){
            AuthInfoImpl auth = this.aliasSerialMap.get(alias);
            if (auth != null) {
                if (auth.getPinCounter() >= this.MAX_PIN) {
                    if (auth.getPukCounter() >= this.MAX_PUK) {
                        String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                        KeyBoardHandler.msg(Confis.get().getString("privateKeyAttacked", new Object[0]), errorTitle, 0);
                        throw new PINLOCKEDException(false);
                    }
                    this.onPINLocked(alias, serialCert, auth);
                }
                start = auth.getPinCounter();
            }
        }
        return start;
    }

    @Override
    public PrivateKey getPrivateKey(String alias, char[] pin) {
        try {
            Callable<Key> act = () -> {
                Serializable auth;
                block8: {
                    Locker locker = this.getLocker().acquireLock();
                    try {
                        Key pk = this.getKeyStore().getKey(alias, pin);
                        if (pk != null) {
                            auth = this.resetAliasAuth(alias);
                            this.saveStore();
                        }
                        auth = pk;
                        if (locker == null) break block8;
                    }
                    catch (Throwable e) {
                        try {
                            this.logWrongPassError(pin, alias);
                            log.error((Object)e);
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (locker != null) {
                                try {
                                    locker.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    locker.close();
                }
                return auth;
            };
            this.onIncorrectPIN = new WrongPINAction(false, alias, null);
            int start = 0;
            try (Locker locker = this.getLocker().acquireLock();){
                AuthInfoImpl auth = this.aliasSerialMap.get(alias);
                if (auth != null) {
                    if (auth.getPinCounter() >= this.MAX_PIN) {
                        if (auth.getPukCounter() >= this.MAX_PUK) {
                            throw new PINLOCKEDException(false);
                        }
                        throw new PINLOCKEDException(true);
                    }
                    start = auth.getPinCounter();
                }
            }
            Key pk = null;
            try {
                pk = act.call();
            }
            catch (Exception e) {
                log.error((Object)e);
                throw e;
            }
            finally {
                if (pk == null) {
                    this.onIncorrectPIN.apply(this.getCounterInfo(alias).getPinCounter() + 1);
                    throw new UnrecoverableKeyException("private key unavailable for input pin");
                }
            }
            return pk != null ? (PrivateKey)pk : null;
        }
        catch (Exception e) {
            throw new ANFPrivateKeyException((Throwable)e);
        }
    }

    protected int onPINLocked(String alias, String serial, AuthInfoImpl auth) {
        if (this.supportPUK() && auth.getPinCounter() >= this.MAX_PIN) {
            while (true) {
                if (auth.getPinCounter() >= this.MAX_PIN && auth.getPukCounter() < this.MAX_PUK) {
                    boolean unlock;
                    if (serial == null) {
                        serial = this.getSerialCert(alias);
                    }
                    if (!(unlock = this.unlockPIN(new UnlockPINParamsImpl(alias, serial, null, null)))) {
                        String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                        if (auth.getPukCounter() < this.MAX_PUK) {
                            KeyBoardHandler.msg(Confis.get().getString("pukFailed", new Object[0]), errorTitle, 2);
                        } else {
                            KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                        }
                        if (auth.getPinCounter() < this.MAX_PIN || auth.getPukCounter() < this.MAX_PUK) continue;
                        throw new PINLOCKEDException(false);
                    }
                    return auth.getPinCounter();
                }
                if (auth.getPinCounter() >= this.MAX_PIN) break;
            }
            throw new PINLOCKEDException(false);
        }
        return auth.getPinCounter();
    }

    protected int getStartCounter() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logWrongPassError(char[] c, String alias) {
        File f = new File(Files.anf(), "wrong_pass.log.txt");
        try (PrintWriter out = null;){
            f.createNewFile();
            out = new PrintWriter(f);
            out.println("serial number is: " + this.getSerialNumberToken());
            out.println("requested alias was: " + new String(c));
            out.println("entered password was: " + new String(c));
            out.println("---------key store information---------");
            Enumeration<String> aliases = this.getKeyStore().aliases();
            out.println("<aliases>");
            while (aliases.hasMoreElements()) {
                String aliasi = aliases.nextElement();
                out.println("<alias " + aliasi + ">");
                out.println("<certificate>");
                Certificate[] chain = this.getKeyStore().getCertificateChain(aliasi);
                X509Certificate[] certs = CertUtils.toX509((Certificate[])chain);
                for (int i = 0; i < certs.length; ++i) {
                    out.println("<cert " + i + ">");
                    out.println(certs[i].toString());
                    out.println("</cert>");
                }
                out.println("</certificate>");
            }
            out.println("</aliases>");
            out.println("---------key store information---------");
        }
    }

    protected AuthInfoImpl resetAliasAuth(String alias) {
        AuthInfoImpl auth = this.aliasSerialMap.get(alias);
        if (auth != null) {
            auth.setPinCounter(0);
            auth.setPukCounter(0);
        }
        return auth;
    }

    protected void lockPrivateKey(String alias) throws KeyStoreException {
        KeyPair kp = this.generateKeyPair(1024);
        Certificate[] certificateChain = this.getCertificateChain(alias);
        this.removeCertificateForced(alias);
        try {
            this.getKeyStore().setKeyEntry(alias, kp.getPrivate(), UUID.randomUUID().toString().toCharArray(), certificateChain);
        }
        catch (KeyStoreException e) {
            throw new ANFKeyStoreException("ERR_UPDATE_KEY_ENTRY");
        }
        this.saveStore();
    }

    @Override
    public boolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        return this.unlockPIN(new UnlockPINParamsImpl(alias, certSerialNumber, pukArray, pinArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlockPIN(UnlockPINParams params) {
        boolean unlock;
        block18: {
            unlock = false;
            try {
                String serialEnc;
                String alias = params.getAlias();
                String serial = params.getSerial();
                char[] puk = params.getPuk();
                char[] newPin = params.getNewPin();
                if (!this.supportPUK()) break block18;
                AuthInfoImpl auth = this.aliasSerialMap.get(alias);
                if (auth != null && (serialEnc = auth.getSerial()) != null) {
                    byte[] decode = Base64.decode((byte[])serialEnc.getBytes());
                    if (puk == null) {
                        String unlockPin = Confis.get().getString("unlockPIN", new Object[0]);
                        String id = this.getPukId(serial, alias) + "unlock-pin";
                        KeyBoardHandler.remove(id);
                        puk = KeyBoardHandler.getPassword(id, unlockPin, false, true, null);
                    }
                    String pass = new String(puk);
                    SecretKeySpec pukKey = new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest(pass.getBytes()), "AES");
                    try {
                        byte[] encode = UtilsPki.encryptDataAES(decode, BLOQ_CIPHER_TYPE.OFB, pukKey);
                        boolean pukOK = Arrays.equals(encode, serial.getBytes());
                        if (pukOK) {
                            if (auth.getPinEnc() != null) {
                                X509Certificate[] chain = this.getCertificateChain(alias);
                                X509Certificate cert = chain[CertUtils.getFinalCert((X509Certificate[])chain)];
                                if (cert != null) {
                                    decode = Base64.decode((byte[])auth.getPinEnc().getBytes());
                                    byte[] pinDec = UtilsPki.encryptDataAES(decode, BLOQ_CIPHER_TYPE.OFB, pukKey);
                                    char[] pin = new String(pinDec).toCharArray();
                                    if (puk == null && newPin == null) {
                                        String title = Confis.get().getString("inputPINCert", CertUtils.getSubjectCN((X509Certificate)cert), this.usb != null ? Character.valueOf(this.usb.getLetter()) : this.getSerialNumberToken());
                                        String id = serial + "-" + alias + "new-pin";
                                        newPin = KeyBoardHandler.getPassword(id, title, false, true, null);
                                    }
                                    unlock = newPin != null ? this.changePIN(alias, pin, newPin, puk) : true;
                                } else {
                                    unlock = false;
                                }
                            } else {
                                this.resetAliasAuth(alias);
                                this.saveStore();
                                if (puk == null && newPin == null) {
                                    KeyBoardHandler.msg(Confis.get().getString("warnPINPUK", new Object[0]), Confis.get().getString("PINnoPUK", new Object[0]), 2);
                                }
                                unlock = true;
                            }
                        } else {
                            unlock = false;
                        }
                    }
                    finally {
                        pukKey = null;
                    }
                }
                if (!unlock) {
                    auth.setPukCounter(auth.getPukCounter() + 1);
                    this.saveStore();
                    if (auth.getPinCounter() >= this.MAX_PIN && auth.getPukCounter() >= this.MAX_PUK) {
                        this.lockPrivateKey(alias);
                    }
                } else {
                    this.resetAliasAuth(alias);
                    this.saveStore();
                }
            }
            catch (Exception e) {
                throw new UnlockPINException((Throwable)e);
            }
        }
        return unlock;
    }

    @Override
    public void saveStore() {
    }

    protected void updatePINLocked(String alias, int t) {
        AuthInfoImpl auth = this.aliasSerialMap.get(alias);
        if (auth != null) {
            auth.setPinCounter(t);
        }
        this.saveStore();
    }

    @Override
    public String getName() {
        if (this instanceof TKManagerCritAcces) {
            return "PlugAndSign";
        }
        if (this instanceof TKManagerSMI) {
            return "SMI";
        }
        return Confis.get().getString("unknown", new Object[0]);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            log.info((Object)("getCertificateChain: " + this.getKeyStore().toString() + " ALIAS: " + alias));
            Certificate[] certChain = this.getKeyStore().getCertificateChain(alias);
            if (certChain != null) {
                X509Certificate issuer;
                log.info((Object)(alias + " chain length: " + certChain.length));
                boolean sort = true;
                X509Certificate[] chain = CertUtils.toX509((Certificate[])certChain);
                int finalCert = CertUtils.getFinalCert((X509Certificate[])chain);
                if (finalCert != -1 && (issuer = CertUtils.getIssuerCertificate((X509Certificate)chain[finalCert])) != null) {
                    log.info(new Object[]{"final cert is ", finalCert, " build chain from final cert"});
                    chain = CertUtils.buildChain((X509Certificate[])new X509Certificate[]{chain[finalCert]});
                    log.info((Object)("built chain from final cert length:" + chain.length));
                    sort = false;
                }
                if (sort) {
                    chain = CertUtils.sortChain((X509Certificate[])chain);
                }
                log.info((Object)("sorted chain length:" + chain.length + " vs original chain length: " + certChain.length));
                if (certChain.length > chain.length) {
                    log.info((Object)"using original chain");
                    chain = CertUtils.toX509((Certificate[])certChain);
                }
                return chain;
            }
            return null;
        }
        catch (Throwable e) {
            throw new ANFCertificateException(e);
        }
    }

    @Override
    public KeyStore getKeyStore() {
        return this.store;
    }

    @Override
    public Provider getProvider() {
        return this.getKeyStore().getProvider();
    }

    @Override
    public KeyPair getKeyPair(String alias) {
        log.info((Object)("getKeyPair(" + alias + ")"));
        KeyPair kp = new KeyPair(this.getPublicKey(alias), this.getPrivateKey(alias));
        return kp;
    }

    @Override
    public KeyPair getKeyPair(String alias, char[] pin) {
        log.info((Object)("getKeyPair(" + alias + ")"));
        KeyPair kp = new KeyPair(this.getPublicKey(alias), this.getPrivateKey(alias, pin));
        return kp;
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm) {
        byte[] signedData = UtilsPki.signData(data, this.getPrivateKey(alias), signAlgorithm, this.getProvider());
        return signedData;
    }

    @Override
    public byte[] signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        byte[] signedData = UtilsPki.signData(data, this.getPrivateKey(alias, pin), signAlgorithm, this.getProvider());
        return signedData;
    }

    @Override
    public boolean verifyData(String alias, byte[] data, byte[] signedData, String signAlgorithm) {
        return UtilsPki.verifyData(data, signedData, this.getPublicKey(alias), signAlgorithm, Security.getProvider("BC"));
    }

    @Override
    public byte[] encryptData(String alias, byte[] data, String algorithm) {
        return UtilsPki.cipherData(data, Security.getProvider("BC"), this.getPublicKey(alias), algorithm);
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm) {
        return UtilsPki.decipherData(encryptedData, this.getKeyStore().getProvider(), this.getPrivateKey(alias), algorithm);
    }

    @Override
    public byte[] decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        return UtilsPki.decipherData(encryptedData, this.getKeyStore().getProvider(), this.getPrivateKey(alias, pin), algorithm);
    }

    @Override
    public X509Certificate[] convertCertificateArraytoX509CertificateArray(Certificate[] certArray) {
        if (certArray instanceof X509Certificate[]) {
            return (X509Certificate[])certArray;
        }
        X509Certificate[] result = new X509Certificate[certArray.length];
        if (this.isAllItemInstanceOfX509Certificate(certArray)) {
            for (int i = 0; i < certArray.length; ++i) {
                result[i] = (X509Certificate)certArray[i];
            }
        }
        return result;
    }

    @Override
    public boolean isAllItemInstanceOfX509Certificate(Certificate[] certArray) {
        boolean result = true;
        for (int i = 0; i < certArray.length; ++i) {
            if (certArray[i] instanceof X509Certificate) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public PrivateKey getPrivateKey2(String alias) {
        return null;
    }

    @Override
    public KeyPair _generateKeyPair(int keySize) throws KeyStoreException {
        return this.generateKeyPair(keySize);
    }

    @Override
    public LinkedList<X509Certificate> getCertificates() {
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        Enumeration<String> listAlias = this.getAlias();
        while (listAlias.hasMoreElements()) {
            String alias = listAlias.nextElement();
            X509Certificate cert = this.getCertificate(alias);
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public int[] getCertificateCounts() {
        LinkedList<X509Certificate> certs = this.getCertificates();
        int c1 = 0;
        int c2 = 0;
        for (X509Certificate cert : certs) {
            if (!(cert.getPublicKey() instanceof RSAPublicKey)) continue;
            if (((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() == 1024) {
                ++c1;
                continue;
            }
            if (((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() != 2048) continue;
            ++c2;
        }
        return new int[]{c1, c2};
    }

    @Override
    public boolean canGenerateCertificateCount(int count2048) {
        return true;
    }

    @Override
    public boolean containsAlias(String alias) {
        try {
            return this.getKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public USB getUSB() {
        return this.usb;
    }

    public abstract AuthHandler getAuthHandler(Object ... var1);

    @Override
    public char[] getPIN(String alias) {
        char[] password = null;
        try {
            X509Certificate cert = this.getCertificate(alias);
            if (cert != null) {
                String id = this.getKeyBoardId(alias);
                password = KeyBoardHandler.getPassword(id, Confis.get().getString("26", new Object[0]) + new DatosPersonales(cert.getSubjectX500Principal()).getCN(), false, false, this.getAuthHandler(alias));
                if (this.getKeyStore().getKey(alias, password) != null) {
                    return password;
                }
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)e);
        }
        return null;
    }

    @Override
    public SecretKey generateSecretKey(int byteLength) throws NOPINException, PINLOCKEDException {
        try {
            AgregarProveedor.agregarBouncyCastleProvider();
            Provider provider = Security.getProvider("BC");
            KeyGenerator keygen = KeyGenerator.getInstance("AES", provider);
            keygen.init(byteLength * 8);
            keygen.init(new SecureRandom());
            SecretKey secretKey = keygen.generateKey();
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadAliasSerialMap(byte[] buffer) throws Exception {
        log.info((Object)"TKManagerAbstract.loadAliasSerialMap()");
        try {
            TreeMap<String, AuthInfoImpl> map = new TreeMap<String, AuthInfoImpl>();
            SecretKeySpec skeySpec = new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest(this.getSerialNumberToken().getBytes()), "AES");
            byte[] encode = UtilsPki.encryptDataAES(buffer, BLOQ_CIPHER_TYPE.OFB, skeySpec);
            String str = new String(encode);
            try (Scanner in = new Scanner(str);){
                while (in.hasNextLine()) {
                    String line = in.nextLine();
                    String[] values = line.split(" ");
                    if (values.length < 4) continue;
                    try {
                        Integer pin = Integer.valueOf(values[1]);
                        Integer puk = Integer.valueOf(values[2]);
                        String pinEnc = null;
                        if (values.length > 4) {
                            pinEnc = values[4];
                        }
                        String alias = values[0];
                        try {
                            alias = new String(Hex.decode((byte[])values[0].getBytes()));
                        }
                        catch (Exception e) {
                            alias = values[0];
                        }
                        map.put(alias, new AuthInfoImpl(pin, puk, values[3], pinEnc, this.MAX_PIN, this.MAX_PUK));
                    }
                    catch (Exception e) {
                        log.error((Object)"ERROR DE FORMATO EN ALIAS MAP", (Throwable)e);
                    }
                }
                this.aliasSerialMap = map;
                log.info((Object)"el mapa de PUK se ha cargado");
                return;
            }
        }
        catch (Throwable e) {
            this.aliasSerialMap = new TreeMap<String, AuthInfoImpl>();
            log.error((Object)"el mapa de PUK se creara vacio", e);
        }
    }

    protected byte[] saveAliasSerialMap() throws Exception {
        log.info((Object)"TKManagerAbstract.saveAliasSerialMap()");
        SecretKeySpec skeySpec = new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest(this.getSerialNumberToken().getBytes()), "AES");
        Set<Map.Entry<String, AuthInfoImpl>> entrySet = this.aliasSerialMap.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, AuthInfoImpl> e : entrySet) {
            String line = e.getValue().getLine(e.getKey());
            sb.append(line);
        }
        byte[] bytes = sb.toString().getBytes();
        byte[] encode = UtilsPki.encryptDataAES(bytes, BLOQ_CIPHER_TYPE.OFB, skeySpec);
        log.info((Object)"TKManagerAbstract.saveAliasSerialMap() retorna OK");
        return encode;
    }

    protected void updateAliasSerialMap(String alias, String serial, String puk, String pin) {
        try {
            log.info((Object)("TKManagerAbstract.updateAliasSerialMap(alias:" + alias + ")"));
            byte[] encode = UtilsPki.encryptDataAES(serial.getBytes(), BLOQ_CIPHER_TYPE.OFB, new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest(puk.getBytes()), "AES"));
            byte[] pinEnc = null;
            String pinB64 = null;
            if (pin != null) {
                pinEnc = UtilsPki.encryptDataAES(pin.getBytes(), BLOQ_CIPHER_TYPE.OFB, new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest(puk.getBytes()), "AES"));
                pinB64 = new String(Base64.encode((byte[])pinEnc));
            }
            this.aliasSerialMap.put(alias, new AuthInfoImpl(new String(Base64.encode((byte[])encode)), pinB64, this.MAX_PIN, this.MAX_PUK));
            log.info((Object)("TKManagerAbstract.updateAliasSerialMap(alias:" + alias + ") retorna OK"));
        }
        catch (IOException | InterruptedException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ANFKeyStoreException("ERR_ALIAS_PIN_INFO", (Throwable)e);
        }
    }

    @Override
    public AuthInfoImpl getCounterInfo(String alias) {
        AuthInfoImpl authInfo;
        if (this.aliasSerialMap != null && !this.aliasSerialMap.isEmpty() && (authInfo = this.aliasSerialMap.get(alias)) != null) {
            return authInfo;
        }
        return new AuthInfoImpl(0, 0, null, null, this.MAX_PIN, this.MAX_PUK);
    }

    @Override
    public String getNewValidAlias(X500Name x500Name) {
        String alias = String.valueOf((int)(Math.random() * 100000.0));
        while (this.containsAlias(alias)) {
            alias = String.valueOf((int)(Math.random() * 100000.0));
        }
        return alias;
    }

    @Override
    public boolean accept(ProfilePolicy profile) {
        return true;
    }

    public void unlock(LockerImpl locker) throws IOException {
        locker.close();
    }

    public boolean isHSM() {
        return false;
    }

    @Override
    public boolean isSignatureStore() {
        return true;
    }

    @Override
    public TokenInfo getTokenInfo() {
        return null;
    }

    @Override
    protected void checkWriteSupported() {
    }

    @Override
    protected String getCertCreationTitle() {
        String title = Confis.get().getString("importNewCert", new Object[0]);
        return title;
    }

    private class WrongPINAction
    extends AbstractPINAction<Integer, Integer> {
        private String alias;
        private String serialCert;

        public WrongPINAction(boolean showMessages, String alias, String serialCert) {
            super(showMessages);
            this.alias = alias;
            this.serialCert = serialCert;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Integer apply(Integer iteration) {
            log.info((Object)"WrongPINAction acquire lock");
            try (Locker locker = TKManagerAbstract.this.getLocker().acquireLock();){
                log.info((Object)"WrongPINAction lock acquired");
                log.info((Object)("WrongPINAction update pin iteration " + iteration + " alias " + this.alias));
                TKManagerAbstract.this.updatePINLocked(this.alias, iteration);
                AuthInfoImpl auth = TKManagerAbstract.this.aliasSerialMap.get(this.alias);
                if (auth != null && auth.getPinCounter() >= TKManagerAbstract.this.MAX_PIN) {
                    if (auth.getPukCounter() >= TKManagerAbstract.this.MAX_PUK) {
                        TKManagerAbstract.this.lockPrivateKey(this.alias);
                        if (!this.showMessages) throw new PINLOCKEDException(false);
                        String errorTitle = Confis.get().getString("ERROR", new Object[0]);
                        KeyBoardHandler.msg(Confis.get().getString("pukBloqued", new Object[0]), errorTitle, 0);
                        throw new PINLOCKEDException(false);
                    }
                    if (!this.showMessages) throw new PINLOCKEDException(true);
                    Integer n = TKManagerAbstract.this.onPINLocked(this.alias, this.serialCert, auth);
                    return n;
                }
                Integer n = iteration;
                return n;
            }
            catch (IOException | KeyStoreException e) {
                return iteration;
            }
        }
    }

    protected abstract class AbstractPINAction<PARAM, RESULT>
    implements Function<PARAM, RESULT> {
        protected boolean showMessages = false;

        public AbstractPINAction(boolean showMessages) {
            this.showMessages = showMessages;
        }

        public void setShowMessages(boolean showMessages) {
            this.showMessages = showMessages;
        }
    }
}

