/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.server.impl;

import anf.centralizados.client.client.CentralClient;
import anf.centralizados.client.client.CentralClientFactory;
import anf.centralizados.core.json.response.Response;
import anf.centralizados.core.json.response.ResponseActivationResult;
import anf.centralizados.core.json.response.ResponseGetPfx;
import anf.centralizados.core.json.response.ResponseGetSigs;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCentralServerError;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.CentralServerController;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;

public class CentralServerControllerImpl
implements CentralServerController {
    private static final Logger log = Logger.getLogger(CentralServerControllerImpl.class);
    private String url = "https://centralizadosws.anf.es/";
    private String user;
    private String password;
    private CentralClient client;

    public CentralServerControllerImpl() {
    }

    public CentralServerControllerImpl(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.updateClient();
    }

    @Override
    public void configureServerManager(String url) {
        this.setUrl(url);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.updateClient();
    }

    @Override
    public void setUser(String user) {
        this.user = user;
        this.updateClient();
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.updateClient();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Set<String> listPendingLocalizators() {
        return this.listLocalizators(false);
    }

    @Override
    public Set<String> listActiveLocalizators() {
        return this.listLocalizators(true);
    }

    @Override
    public Set<String> listAllLocalizators() {
        return this.listLocalizators(null);
    }

    private Set<String> listLocalizators(Boolean active) {
        TreeSet<String> localizators = new TreeSet<String>();
        ResponseGetSigs sigs = this.getClient().getSigs();
        if (this.parseResponse((Response)sigs)) {
            List result = sigs.getResult();
            result.forEach(res -> {
                if (active == null || res.getStatus() != null && res.getStatus().equals("TRAMITADO")) {
                    localizators.add(res.getLocalizador());
                }
            });
        }
        return localizators;
    }

    @Override
    public CentralClient getClient() {
        if (this.client == null) {
            this.updateClient();
        }
        return this.client;
    }

    private void updateClient() {
        this.client = this.createClient();
    }

    @Override
    public ResponseActivationResult activateSig(String localizador, String passSig) {
        String title = Confis.get().getString("importAliasCentral", new Object[0]);
        char[] pin = KeyBoardHandler.getPassword(localizador, title, true, false, null);
        title = Confis.get().getString("insertPUK", new Object[0]);
        char[] puk = KeyBoardHandler.getPassword(localizador + "-puk", title, true, true, null);
        return this.activateSig(localizador, passSig, pin, puk);
    }

    @Override
    public ResponseActivationResult activateSig(String localizador, String passSig, char[] password, char[] puk) {
        return this.getClient().activateSig(localizador, passSig, new String(password), new String(puk));
    }

    @Override
    public boolean parseResponse(Response resp) {
        ANFCentralServerError exc = null;
        if (resp != null) {
            if (resp.getErrorId() != null) {
                exc = new ANFCentralServerError(resp.getErrorId());
            }
            if (resp.isSuccess()) {
                if (exc != null) {
                    log.error((Object)exc);
                }
                return resp.isSuccess();
            }
            if (exc == null) {
                exc = new ANFCentralServerError();
            }
        } else {
            exc = new ANFCentralServerError("NULL_RESPONSE:" + this.getUrl());
        }
        throw exc;
    }

    @Override
    public boolean uploadPFX(File pfxFile, String pass, String puk) {
        boolean bl;
        byte[] content = null;
        FileInputStream in = new FileInputStream(pfxFile);
        try {
            content = IOUtils.toByteArray((InputStream)in);
            Response pfxResp = this.getClient().loadPfx(content, pass, puk);
            bl = this.parseResponse(pfxResp);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ANFCentralServerError("ERR_UPLOAD_PFX", (Throwable)e);
            }
        }
        in.close();
        return bl;
    }

    @Override
    public boolean downloadPfx(String pin, String alias, OutputStream outputStream) {
        try {
            ResponseGetPfx pfxResp = this.getClient().getPfx(pin, alias);
            if (this.parseResponse((Response)pfxResp) && pfxResp.getResult() != null && pfxResp.getResult().length > 0) {
                IOUtils.write((byte[])pfxResp.getResult(), (OutputStream)outputStream);
                return true;
            }
        }
        catch (IOException e) {
            throw new ANFCentralServerError("ERR_DOWNLOAD_PFX", (Throwable)e);
        }
        return false;
    }

    @Override
    public CentralClient createClient() {
        try {
            return CentralClientFactory.createClient((String)this.getUser(), (String)this.getPassword(), (String)this.url);
        }
        catch (Exception e) {
            throw new ANFCentralServerError(e.getMessage(), e.getCause());
        }
    }
}

