/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.server;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.TrayIconNotificationHandler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class TrayIconNotificationWebSocketClient {
    private static final Logger log = Logger.getLogger(TrayIconNotificationWebSocketClient.class);
    private Consumer<String> onUserChange;
    private HttpClient httpClient;
    Vertx vertx;
    TrayIconNotificationHandler notificationHandler;

    public TrayIconNotificationWebSocketClient(Consumer<String> onUserChange) {
        this.onUserChange = onUserChange;
        System.setProperty("vertx.disableFileCaching", "true");
        System.setProperty("vertx.disableDnsResolver", "true");
        System.setProperty("vertx.disableFileCPResolving", "true");
        String vertxFolder = System.getenv("PUBLIC");
        if (vertxFolder == null) {
            vertxFolder = System.getProperty("user.home");
        }
        if (vertxFolder == null) {
            vertxFolder = new File(".").getAbsolutePath();
        }
        System.setProperty("vertx.cwd", vertxFolder);
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(true));
        System.setProperty("io.netty.tryReflectionSetAccessible", "false");
        this.vertx = Vertx.vertx((VertxOptions)vertxOptions);
        this.notificationHandler = new TrayIconNotificationHandler(onUserChange);
        this.createNewClient();
    }

    public synchronized boolean connect(Consumer<Void> onDisconnect) throws Throwable {
        if (!this.notificationHandler.isClientConnected()) {
            AtomicReference<Object> error = new AtomicReference<Object>(null);
            CountDownLatch latch = new CountDownLatch(1);
            this.notificationHandler.setOnDisconnect(ignore -> {
                log.info((Object)"cerrando un cliente");
                if (onDisconnect != null) {
                    onDisconnect.accept((Void)ignore);
                }
            });
            this.createNewClient();
            this.httpClient.webSocket(6542, "127.0.0.1", "/test", onConnectedWebSocket -> {
                if (onConnectedWebSocket.failed()) {
                    log.error((Object)onConnectedWebSocket.cause());
                    if (onConnectedWebSocket.result() != null) {
                        ((WebSocket)onConnectedWebSocket.result()).close();
                    }
                } else {
                    this.notificationHandler.handle((WebSocket)onConnectedWebSocket.result());
                }
                latch.countDown();
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
        return this.notificationHandler.isClientConnected();
    }

    private void createNewClient() {
        HttpClientOptions options = new HttpClientOptions();
        options.setHttp2MaxPoolSize(1);
        this.httpClient = this.vertx.createHttpClient(options);
    }
}

