/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.server;

import com.anf.cryptotoken.api.thread.AsyncExecutor;
import com.anf.cryptotoken.json.UpdateNotification;
import com.anf.cryptotoken.log.Logger;
import com.anf.oauth.json.JSONFactory;
import io.vertx.core.Handler;
import io.vertx.core.http.WebSocket;
import java.util.function.Consumer;

public class TrayIconNotificationHandler
implements Handler<WebSocket>,
AsyncExecutor {
    private static final Logger log = Logger.getLogger(TrayIconNotificationHandler.class);
    private Consumer<String> onUserChange;
    private Consumer<Void> onDisconnect;
    private boolean clientConnected;

    public TrayIconNotificationHandler(Consumer<String> onUserChange) {
        this.onUserChange = onUserChange;
    }

    public void handle(WebSocket webSocket) {
        this.clientConnected = true;
        webSocket.handler(data -> executorService.execute(() -> {
            try {
                UpdateNotification notification = (UpdateNotification)JSONFactory.buildObject((byte[])data.getBytes(), (String)"update", UpdateNotification.class);
                this.onUserChange.accept(notification.getUser());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        })).closeHandler(ignore -> {
            log.info((Object)"cerrando websocket del tray icon");
            this.clientConnected = false;
            if (this.onDisconnect != null) {
                this.onDisconnect.accept(null);
            }
        }).exceptionHandler(err -> {
            log.info((Object)"manejando error de websocket");
            log.error(err);
        });
        System.out.println("Client Connected!");
    }

    public boolean isClientConnected() {
        return this.clientConnected;
    }

    public void setOnDisconnect(Consumer<Void> onDisconnect) {
        this.onDisconnect = onDisconnect;
    }
}

