/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ocsp.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.OCSPValidationResult;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.OCSPHandlerFactory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class OCSPValidationResultImpl
implements OCSPValidationResult {
    private static final Logger log = Logger.getLogger(OCSPValidationResultImpl.class);
    private static final DefaultAlgorithmNameFinder algorithmNameFinder = new DefaultAlgorithmNameFinder();
    @JsonIgnore
    private BasicOCSPResp resp;
    private boolean integrity = false;
    private boolean valid = false;
    private String status;
    @JsonIgnore
    private X509Certificate[] responderCertChain;
    private Date producedAt;
    private ASN1ObjectIdentifier signatureAlgOid;
    private int version;
    private String signAlgorithmName;

    public OCSPValidationResultImpl() {
    }

    public OCSPValidationResultImpl(BasicOCSPResp resp) {
        this.resp = resp;
        try {
            this.integrity = this.validateOCSPResp(resp);
            this.status = OCSPHandlerFactory.ocspHandler().getStatus(resp);
            X509CertificateHolder[] certs = resp.getCerts();
            this.responderCertChain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                this.responderCertChain[i] = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certs[i]);
            }
            if (this.responderCertChain.length >= 1 && (this.responderCertChain.length == 1 || Arrays.equals(this.responderCertChain[0].getSignature(), this.responderCertChain[1].getSignature()))) {
                this.responderCertChain = CertUtils.buildChain((X509Certificate[])new X509Certificate[]{this.responderCertChain[0]});
            }
            this.version = resp.getVersion();
            this.producedAt = resp.getProducedAt();
            this.signatureAlgOid = resp.getSignatureAlgOID();
            this.signAlgorithmName = algorithmNameFinder.getAlgorithmName(this.signatureAlgOid);
            this.valid = this.integrity;
            if (this.valid) {
                int finalCert;
                boolean bl = this.valid = this.signAlgorithmName != null && !this.signAlgorithmName.equals("SHA1WITHRSA");
                if (this.valid && this.responderCertChain != null && (finalCert = CertUtils.getFinalCert((X509Certificate[])this.responderCertChain)) != -1) {
                    X509Certificate ocspCert = this.responderCertChain[finalCert];
                    try {
                        ocspCert.checkValidity(this.producedAt);
                        this.valid = true;
                    }
                    catch (Exception e) {
                        this.valid = false;
                    }
                }
            }
        }
        catch (CertificateException e) {
            log.error((Object)e);
        }
    }

    public OCSPValidationResultImpl(BasicOCSPResponse response) {
        this(new BasicOCSPResp(response));
    }

    public boolean validateOCSPResponderCert() {
        X509Certificate cert;
        X509Certificate issuerCertificate;
        int finalCert;
        boolean isValid = false;
        if (this.responderCertChain != null && (finalCert = CertUtils.getFinalCert((X509Certificate[])this.responderCertChain)) != -1 && (issuerCertificate = CertUtils.getIssuerCertificate((X509Certificate[])this.responderCertChain, (X509Certificate)(cert = this.responderCertChain[finalCert]))) != null) {
            try {
                cert.verify(issuerCertificate.getPublicKey());
                isValid = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                log.error((Object)e);
            }
        }
        return isValid;
    }

    public boolean validateOCSPResp(BasicOCSPResp resp) {
        if (resp == null) {
            return false;
        }
        X509CertificateHolder[] certs = resp.getCerts();
        boolean isValid = false;
        if (certs != null && certs.length > 0) {
            JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder().setProvider("BC");
            for (int i = 0; !isValid && i < certs.length; ++i) {
                X509CertificateHolder cert = certs[i];
                try {
                    ContentVerifierProvider verifier = builder.build(cert.getSubjectPublicKeyInfo());
                    isValid = resp.isSignatureValid(verifier);
                    continue;
                }
                catch (OCSPException | OperatorCreationException e) {
                    log.error((Object)e);
                }
            }
        }
        return isValid;
    }

    public BasicOCSPResp getResp() {
        return this.resp;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isIntegrity() {
        return this.integrity;
    }

    public String getStatus() {
        return this.status;
    }

    public X509Certificate[] getResponderCertChain() {
        return this.responderCertChain;
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public ASN1ObjectIdentifier getSignatureAlgOid() {
        return this.signatureAlgOid;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSignAlgorithmName() {
        return this.signAlgorithmName;
    }

    public Date getRevocationTime() {
        SingleResp response;
        CertificateStatus ocspStatus;
        SingleResp[] responses;
        Date revocationTime = null;
        if (this.resp != null && (responses = this.resp.getResponses()) != null && responses.length >= 1 && (ocspStatus = (response = responses[0]).getCertStatus()) != null && ocspStatus instanceof RevokedStatus) {
            RevokedStatus revokedStatus = (RevokedStatus)ocspStatus;
            revocationTime = revokedStatus.getRevocationTime();
        }
        return revocationTime;
    }
}

