/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ocsp.impl;

import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.api.ocsp.OCSPValidationResult;
import com.anf.cryptotoken.ocsp.impl.OCSPValidationResultImpl;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;

public class CertStatusImpl
implements CertStatus,
Serializable {
    private static final long serialVersionUID = 1L;
    X509Certificate cert;
    Throwable verifyError;
    boolean verified;
    private BasicOCSPResp ocspResponse;
    private String statusOCSP;
    private OCSPValidationResult ocspResult;

    public CertStatusImpl() {
    }

    public CertStatusImpl(X509Certificate cert, Throwable e) {
        this.cert = cert;
        this.verifyError = e;
        this.verified = false;
    }

    public CertStatusImpl(X509Certificate cur, boolean verified) {
        this(cur, null);
        this.verified = verified;
    }

    public CertStatusImpl(X509Certificate cur, BasicOCSPResp ocspResponse, String status) {
        this.cert = cur;
        this.ocspResponse = ocspResponse;
        this.statusOCSP = status;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public Throwable getVerifyError() {
        return this.verifyError;
    }

    public void setVerifyError(Throwable verifyError) {
        this.verifyError = verifyError;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public BasicOCSPResp getOcspResponse() {
        return this.ocspResponse;
    }

    public void setOcspResponse(BasicOCSPResp ocspResponse) {
        this.ocspResponse = ocspResponse;
        this.ocspResult = new OCSPValidationResultImpl(ocspResponse);
    }

    public String getStatusOCSP() {
        return this.statusOCSP;
    }

    public void setStatusOCSP(String statusOCSP) {
        this.statusOCSP = statusOCSP;
    }

    public Date getRevocationTime() {
        SingleResp response;
        CertificateStatus ocspStatus;
        SingleResp[] responses;
        Date revocationTime = null;
        BasicOCSPResp ocspResp = this.getOcspResponse();
        if (ocspResp != null && (responses = ocspResp.getResponses()) != null && responses.length >= 1 && (ocspStatus = (response = responses[0]).getCertStatus()) != null && ocspStatus instanceof RevokedStatus) {
            RevokedStatus revokedStatus = (RevokedStatus)ocspStatus;
            revocationTime = revokedStatus.getRevocationTime();
        }
        return revocationTime;
    }

    public OCSPValidationResult getOcspValidationResult() {
        return this.ocspResult;
    }
}

