/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.ocsp.impl;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.ANFOCSPClient;
import com.anf.cryptotoken.api.ocsp.exception.ANFOcspException;
import com.anf.cryptotoken.api.ocsp.model.RevocationSerialInfo;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.impl.RevocationSerialsRequest;
import com.anf.cryptotoken.ocsp.impl.RevocationSerialsResponse;
import com.anf.cryptotoken.utils.CertURLUtils;
import com.anf.oauth.client.AbstractClient;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class ANFOCSPClientImpl
extends AbstractClient
implements ANFOCSPClient {
    private static final Logger log = Logger.getLogger(ANFOCSPClientImpl.class);
    private int readTimeOut = 30000;
    private int connectTimeOut = 30000;
    private boolean debug = false;
    private Consumer<OCSPReq> onOCSPRequestCreated = request -> {};
    private DigestCalculator digestCalculator;

    public ANFOCSPClientImpl() {
        super("https://ocsp.anf.es", 30000L);
        AgregarProveedor.agregarBouncyCastleProvider();
        this.setPrintRequest(true);
        this.setPrintResponse(true);
        try {
            this.digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
        }
        catch (OperatorCreationException e) {
            log.error((Object)e);
        }
    }

    public boolean setReadTimeOut(int readTimeOut) {
        if (readTimeOut >= 1000 && readTimeOut <= 1000000) {
            this.readTimeOut = readTimeOut;
            return true;
        }
        return false;
    }

    public boolean setConnectTimeOut(int connectTimeOut) {
        if (connectTimeOut >= 1000 && connectTimeOut <= 1000000) {
            this.connectTimeOut = connectTimeOut;
            return true;
        }
        return false;
    }

    public BasicOCSPResp getBasicOCSPResp(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            OCSPResp ocspResponse = this.getOcspResponse(checkCert, rootCert, url);
            return this.getBasicOcspResp(ocspResponse);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public BasicOCSPResp getBasicOcspResp(OCSPResp ocspResponse) throws OCSPException {
        if (ocspResponse == null) {
            return null;
        }
        if (ocspResponse.getStatus() != 0) {
            return null;
        }
        return (BasicOCSPResp)ocspResponse.getResponseObject();
    }

    public OCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws CertificateEncodingException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = CertURLUtils.getOCSPURL((X509Certificate)checkCert);
        }
        if (url == null) {
            return null;
        }
        byte[] nonce = null;
        if (url.contains("anf.es")) {
            nonce = new byte[16];
            new SecureRandom(new BigInteger("" + System.nanoTime()).toByteArray()).nextBytes(nonce);
            log.info((Object)("Getting OCSP from " + url));
        }
        OCSPReq request = this.generateOCSPRequest(rootCert, checkCert.getSerialNumber(), nonce);
        this.onOCSPRequestCreated.accept(request);
        OCSPResp resp = this.getOCSPResponse(url, request);
        BasicOCSPResp responseObject = (BasicOCSPResp)resp.getResponseObject();
        if (responseObject != null && nonce != null) {
            Extension nonceExt = responseObject.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            if (nonceExt == null) {
                throw new OCSPException("ERR_RESP_NONCE_NOT_FOUND");
            }
            byte[] octets = ASN1OctetString.getInstance((Object)nonceExt.getExtnValue().getOctets()).getOctets();
            if (!Arrays.equals(nonce, octets)) {
                throw new OCSPException("ERR_RESP_NONCE_NOT_MATCH");
            }
        }
        return resp;
    }

    public OCSPResp getOCSPResponse(String url, OCSPReq request) throws IOException, MalformedURLException {
        URL urlt = new URL(url);
        HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
        if (!url.contains("anf.es") && con instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)con;
            https.setSSLSocketFactory(this.trustServerCertFactory(urlt));
        }
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "*");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setReadTimeout(this.readTimeOut);
        con.setConnectTimeout(this.connectTimeOut);
        con.getOutputStream().write(request.getEncoded());
        int responseCode = con.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("ERR_OCSP_RESPONSE:" + responseCode);
        }
        InputStream in = con.getInputStream();
        byte[] content = IOUtils.toByteArray((InputStream)in);
        con.getHeaderFields().entrySet().forEach(set -> this.debug((String)set.getKey() + " -> " + set.getValue()));
        return new OCSPResp(content);
    }

    private SSLSocketFactory trustServerCertFactory(URL url) {
        try {
            X509Certificate[] chain = ANFOCSPClientImpl.getServerCertificates(url);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            for (X509Certificate cert : chain) {
                trustStore.setCertificateEntry(cert.getSerialNumber().toString(), cert);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            try {
                return SSLContext.getDefault().getSocketFactory();
            }
            catch (NoSuchAlgorithmException e1) {
                return null;
            }
        }
    }

    private static X509Certificate[] getServerCertificates(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException, MalformedURLException, SSLPeerUnverifiedException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext trustAllSSLContext = SSLContext.getInstance("TLSv1.2");
        trustAllSSLContext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection https = (HttpsURLConnection)new URL(url.getProtocol() + "://" + url.getHost()).openConnection();
        https.setSSLSocketFactory(trustAllSSLContext.getSocketFactory());
        https.connect();
        Certificate[] serverCertificates = https.getServerCertificates();
        X509Certificate[] chain = CertUtils.toX509((Certificate[])serverCertificates);
        return chain;
    }

    public Map<String, RevocationSerialInfo> getSerialNumbersRevocationStatus(List<String> serials) {
        TreeMap<String, RevocationSerialInfo> revocationMap = new TreeMap<String, RevocationSerialInfo>();
        if (serials == null || serials.isEmpty()) {
            return revocationMap;
        }
        try {
            RevocationSerialsResponse resp = (RevocationSerialsResponse)((Object)this.handleJsonRequest("/revocation/status-serials", (Object)new RevocationSerialsRequest(serials), RevocationSerialsResponse.class).get());
            if (resp.isSuccess()) {
                List<RevocationSerialInfo> result = resp.getResult();
                for (RevocationSerialInfo info : result) {
                    revocationMap.put(info.getSerial(), info);
                }
            } else if (resp.getError() != null) {
                throw new IOException(resp.getError());
            }
            return revocationMap;
        }
        catch (IOException e) {
            throw new ANFOcspException((Throwable)e);
        }
    }

    private void debug(String log) {
        if (this.debug) {
            System.out.println(log);
        }
    }

    private OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber, byte[] nonce) throws OCSPException, IOException, OperatorException, CertificateEncodingException {
        CertificateID id = new CertificateID(this.digestCalculator, (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        return this.generateOCSPRequest(id, nonce);
    }

    public OCSPReq generateOCSPRequest(CertificateID id, byte[] nonce) throws IOException, OCSPException {
        OCSPReqBuilder gen = new OCSPReqBuilder();
        gen.addRequest(id);
        if (nonce != null) {
            DEROctetString encodable = new DEROctetString(nonce);
            Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, encodable.toASN1Primitive().getEncoded());
            gen.setRequestExtensions(new Extensions(new Extension[]{ext}));
        }
        return gen.build();
    }

    public void setOnOCSPRequestCreated(Consumer<OCSPReq> onOCSPRequestCreated) {
        if (onOCSPRequestCreated != null) {
            this.onOCSPRequestCreated = onOCSPRequestCreated;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

