/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.impl;

import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.ANFCryptoTokenFactory;
import com.anf.cryptotoken.api.token.SmartCardInfo;
import com.anf.cryptotoken.impl.ANFCryptoTokenImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.CentralServerController;
import com.anf.cryptotoken.server.impl.CentralServerControllerImpl;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.tkmanager.TKManagerFactory;
import com.anf.cryptotoken.tkmanager.TKManagerPFXRemote;
import com.anf.cryptotoken.tkmanager.TKManagerRemote;
import com.anf.cryptotoken.tkmanager.token.detect.ConstantUpdateHandler;
import com.anf.cryptotoken.tkmanager.token.detect.TokenDetector;
import com.anf.cryptotoken.tkmanager.token.detect.impl.ConstantUpdater;
import com.anf.cryptotoken.tkmanager.token.detect.impl.USBDetector;
import com.anf.utils.OSUtils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Level;

public class ANFCryptoTokenFactoryImpl
implements ConstantUpdateHandler,
ANFCryptoTokenFactory {
    private static final Logger log = Logger.getLogger(ANFCryptoTokenFactoryImpl.class);
    private List<File> previousUsbList;
    private ANFCryptoToken[] instances = new ANFCryptoToken[ManagerType.values().length];
    private Map<ManagerType, Boolean> activeTypes = new TreeMap<ManagerType, Boolean>();
    private CentralServerController centralServerController;
    private TKManagerFactory managerFactory;
    private TokenDetector tokenDetector;

    public ANFCryptoTokenFactoryImpl(TokenDetector tokenDetector) {
        this.tokenDetector = tokenDetector;
        tokenDetector.addRootClient(this);
        this.centralServerController = new CentralServerControllerImpl();
        this.managerFactory = new TKManagerFactory(this.centralServerController, tokenDetector.getCardDetector());
        this.activeTypes.put(ManagerType.P11_BIT4ID, true);
        this.activeTypes.put(ManagerType.P11_ST, true);
        this.activeTypes.put(ManagerType.P11_DNI, true);
        this.activeTypes.put(ManagerType.PLUGSIGN, true);
        this.activeTypes.put(ManagerType.WINDOWS, true);
        this.activeTypes.put(ManagerType.SERVER, true);
        this.activeTypes.put(ManagerType.P11_IDEMIA, true);
        if (OSUtils.isWindows()) {
            try {
                this.previousUsbList = USBDetector.getRemovableDevices();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public boolean isActiveType(ManagerType type) {
        Boolean f = this.activeTypes.get((Object)type);
        return f != null && f != false;
    }

    @Override
    public void disablePlugAndSign() {
        this.activeTypes.put(ManagerType.PLUGSIGN, false);
    }

    @Override
    public ANFCryptoToken getInstance() {
        return new ANFCryptoTokenImpl();
    }

    @Override
    public ANFCryptoToken getInstancePFX(InputStream pfxStream, char[] pass) {
        return new ANFCryptoTokenImpl(pfxStream, pass);
    }

    @Override
    public ANFCryptoToken getInstancePFX(File pfx, char[] pass) {
        return new ANFCryptoTokenImpl(pfx, pass);
    }

    @Override
    public ANFCryptoToken getInstancePFXRemote(TKManagerPFXRemote pfx) {
        return new ANFCryptoTokenImpl(pfx);
    }

    @Override
    public ANFCryptoToken updateInstance(ManagerType type) {
        Boolean active;
        if (this.instances[type.ordinal()] != null) {
            this.instances[type.ordinal()] = null;
        }
        if ((active = this.activeTypes.get((Object)type)) != null && active.booleanValue()) {
            try {
                this.instances[type.ordinal()] = new ANFCryptoTokenImpl(type, this.managerFactory);
                return this.instances[type.ordinal()];
            }
            catch (Exception e) {
                log.error((Object)e);
                throw e;
            }
        }
        return null;
    }

    @Override
    public ANFCryptoToken getWindowsInstance() {
        return this.getInstance(ManagerType.WINDOWS);
    }

    @Override
    public ANFCryptoToken getInstance(ManagerType type) {
        boolean active;
        log.info(new Object[]{"entrando en ANFCryptoToken getInstance(" + type + ")", Level.DEBUG});
        boolean bl = active = this.activeTypes.get((Object)type) != null && this.activeTypes.get((Object)type) != false;
        if (this.instances[type.ordinal()] == null) {
            log.info((Object)("instances[" + type + ".ordinal()]=null"));
            if (active) {
                try {
                    this.instances[type.ordinal()] = new ANFCryptoTokenImpl(type, this.managerFactory);
                    log.info((Object)("instances[" + type + ".ordinal()]=" + this.instances[type.ordinal()]));
                }
                catch (Exception e) {
                    log.error((Object)e);
                    throw e;
                }
            } else {
                this.instances[type.ordinal()] = new ANFCryptoTokenImpl();
            }
        } else if (active && (this.instances[type.ordinal()].alwaysUpdate() || this.instances[type.ordinal()].isRequireUpdate() || this.isUpdate())) {
            this.instances[type.ordinal()].update();
        }
        log.info(new Object[]{"saliendo de ANFCryptoToken getInstance(" + type + ") = " + this.instances[type.ordinal()], Level.DEBUG});
        return this.instances[type.ordinal()];
    }

    @Override
    public boolean isUpdate() {
        return this.tokenDetector.isUpdating();
    }

    @Override
    public void setUpdate(boolean u) {
        this.tokenDetector.setConstantDetect(u, this);
    }

    @Override
    public void update(ConstantUpdater updater) {
        if (updater != null) {
            ManagerType[] values = ManagerType.values();
            for (int i = 0; i < this.instances.length && i < values.length; ++i) {
                boolean c;
                if (!this.isActiveType(values[i]) || this.instances[i] == null || !(c = this.instances[i].update())) continue;
                log.info((Object)"Cambio detectado");
            }
        }
    }

    private void update(boolean usb) {
        ManagerType[] values = ManagerType.values();
        for (int i = 0; i < this.instances.length && i < values.length; ++i) {
            if (!this.isActiveType(values[i]) || this.instances[i] == null || (!usb || !this.isUSBToken(this.instances[i])) && this.isUSBToken(this.instances[i])) continue;
            this.instances[i].setUpdateRequired(true);
        }
    }

    private boolean isUSBToken(ANFCryptoToken anf) {
        if (anf != null) {
            switch (anf.getType()) {
                case P11_ANF: 
                case PLUGSIGN: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isCard(ManagerType type) {
        return type == ManagerType.P11_SAFENET || type == ManagerType.P11_ST || type == ManagerType.P11_BIT4ID || type == ManagerType.P11_VAULT;
    }

    @Override
    public ANFCryptoToken getServerDefault() {
        TKManagerRemote instance = this.managerFactory.getTrayIconInstance();
        if (instance != null) {
            return new ANFCryptoTokenImpl(instance);
        }
        return null;
    }

    @Override
    public ANFCryptoToken getServer(String user, String pass) {
        this.centralServerController.setPassword(pass);
        this.centralServerController.setUser(user);
        CentralServerController control = this.getCentralServerController(user, pass);
        return new ANFCryptoTokenImpl(new TKManagerRemote(control));
    }

    @Override
    public ANFCryptoToken getServer(String user, String pass, boolean usePasswordAsPIN) {
        this.centralServerController.setPassword(pass);
        this.centralServerController.setUser(user);
        CentralServerController control = this.getCentralServerController(user, pass);
        return new ANFCryptoTokenImpl(new TKManagerRemote(usePasswordAsPIN, control));
    }

    @Override
    public ANFCryptoToken getServer(String user, String pass, char[] pin) {
        this.centralServerController.setPassword(pass);
        this.centralServerController.setUser(user);
        CentralServerController control = this.getCentralServerController(user, pass);
        return new ANFCryptoTokenImpl(new TKManagerRemote(pin, control));
    }

    @Override
    public CentralServerController getCentralServerController() {
        if (this.centralServerController == null) {
            this.centralServerController = new CentralServerControllerImpl();
        }
        return this.centralServerController;
    }

    @Override
    public TKManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    @Override
    public void configureServerManager(String url) {
        this.centralServerController.configureServerManager(url);
    }

    @Override
    public CentralServerController getCentralServerController(String user, String pass) {
        return new CentralServerControllerImpl(this.centralServerController.getUrl(), user, pass);
    }

    @Override
    public Object onCardDetect(List<SmartCardInfo> cards) {
        this.update(false);
        return null;
    }

    @Override
    public Object onUsbDetect(List<File> usbs) {
        try {
            log.info((Object)("onUsbDetect usbs=" + usbs));
            if (!this.activeTypes.get((Object)ManagerType.PLUGSIGN).booleanValue() && !usbs.isEmpty()) {
                log.info((Object)("onUsbDetect usbs.size=" + usbs.size()));
                Boolean active = this.activeTypes.get((Object)ManagerType.PLUGSIGN);
                log.info((Object)("onUsbDetect active=" + active));
                if (active == null || !active.booleanValue()) {
                    // empty if block
                }
            }
            this.update(true);
        }
        finally {
            this.previousUsbList = usbs;
        }
        return null;
    }

    @Override
    public Object onCentralCertDetect(String user) {
        ANFCryptoToken serverInstance = this.instances[ManagerType.SERVER.ordinal()];
        if (serverInstance != null) {
            serverInstance.update();
        } else {
            serverInstance = this.getInstance(ManagerType.SERVER);
        }
        return null;
    }

    @Override
    public int getTypesCount() {
        return this.activeTypes.size();
    }
}

