/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.credentials.impl;

import com.anf.cryptotoken.api.exceptions.CredencialsException;
import com.anf.cryptotoken.api.sign.exception.CertificateCredentialException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.credentials.CredentialsHandler;
import com.anf.cryptotoken.credentials.URLAuthInfo;
import com.anf.cryptotoken.credentials.impl.DefaultCredentialsHandler;
import com.anf.cryptotoken.credentials.impl.URLAuthInfoImpl;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.oid.OIDUtils;
import com.anf.cryptotoken.utils.DatosPersonales;
import com.anf.oauth.json.BasicResponse;
import com.anf.utils.NetworkConfig;
import com.anf.utils.SerialUtils;
import com.anf.ws.credential.client.enums.TypeCertificate;
import com.anf.ws.credential.client.factory.FactoryClient;
import com.anf.ws.credential.client.interfaces.IClient;
import com.anf.ws.credential.client.model.AccessAuditObject;
import com.anf.ws.credential.client.model.CertificateInfo;
import com.anf.ws.credential.client.model.CredentialResponse;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class CredentialsControllerImpl
implements CredentialsController {
    private static final Logger log = Logger.getLogger(CredentialsControllerImpl.class);
    public URLAuthInfo urlAuthInfo = new URLAuthInfoImpl();
    private CredentialsHandler credentialsHandler;
    private String computerSerialNumber = null;
    private String url = "https://credencial.anf.es";
    private int timeout = 10000;

    public CredentialsControllerImpl(CredentialsHandler credentialsHandler) {
        this.credentialsHandler = credentialsHandler;
        this.computerSerialNumber = SerialUtils.getComputerSerialNumber();
    }

    public CredentialsControllerImpl() {
        this(new DefaultCredentialsHandler());
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setUrlAuthInfo(String urlStr, String appName, String version, String ip) {
        try {
            if (urlStr != null && !((String)urlStr).isEmpty()) {
                if (!((String)urlStr).startsWith("http://") && !((String)urlStr).startsWith("https://")) {
                    urlStr = "https://" + (String)urlStr;
                }
                this.urlAuthInfo.setUrl(new URL((String)urlStr));
            } else {
                this.urlAuthInfo.setUrl(new URL("http://localhost"));
            }
            this.urlAuthInfo.setAppName(appName);
            this.urlAuthInfo.setVersion(version);
            this.urlAuthInfo.setIp(ip);
            log.info((Object)("Setting URL INFO [[[url:" + (String)urlStr + ",app:" + appName + ",ver:" + version + ",ip:" + ip + "]]]"));
        }
        catch (MalformedURLException e) {
            throw new CredencialsException("ERR_URL_CREDENTIALS", (Throwable)e);
        }
    }

    @Override
    public void setUrlAuthInfoClear() {
        this.urlAuthInfo.setUrl(null);
        this.urlAuthInfo.setAppName(null);
        this.urlAuthInfo.setVersion(null);
        this.urlAuthInfo.setIp(null);
    }

    @Override
    public URLAuthInfo getUrlAuthInfo() {
        return this.urlAuthInfo;
    }

    @Override
    public boolean sendURLCrendentials(X509Certificate cert) {
        return this.sendURLCrendentials(cert, this.computerSerialNumber, this.urlAuthInfo);
    }

    @Override
    public boolean sendURLCrendentials(X509Certificate cert, String computerSerialNumber, URLAuthInfo url) {
        ASN1EncodableVector oid = OIDUtils.getCompanyID((X509Certificate)cert);
        if (oid != null && oid.size() >= 2 && oid.get(0) instanceof ASN1ObjectIdentifier && oid.get(1) != null) {
            if (new File("cancelCredenciales.txt").exists()) {
                log.info((Object)"cancelando el envio a credenciales");
                return true;
            }
            log.info((Object)("autenticando certificado en credenciales: " + cert.getSubjectX500Principal()));
            IClient client = this.createClientCredentials();
            NetworkConfig networkConfig = NetworkConfig.get();
            if (networkConfig.getIpAddress() != null) {
                url.setIp(networkConfig.getIpAddress().getHostAddress());
            }
            AccessAuditObject accessAuditObject = this.getAccessAuditObject(url);
            log.info((Object)("ID de Compania para el certificado a autenticar: " + oid.get(1)));
            CertificateInfo certInfo = this.getCertInfo(cert);
            try {
                try {
                    String macAddress = networkConfig.getMacAddress();
                    if (macAddress != null) {
                        computerSerialNumber = macAddress;
                    }
                    if (computerSerialNumber == null) {
                        computerSerialNumber = this.computerSerialNumber;
                    }
                    if (computerSerialNumber == null) {
                        throw new CertificateCredentialException("ERR_COMPUTER_MAC_UNAVAILABLE");
                    }
                }
                catch (Throwable e) {
                    throw new CertificateCredentialException("ERR_COMPUTER_MAC_UNAVAILABLE");
                }
                String companyOid = oid.get(1).toString();
                log.info((Object)("enviando credencial, ID de compania: " + companyOid + ", MAC: " + computerSerialNumber + ", user:" + certInfo.getUsername() + ", cert-sn:" + cert.getSerialNumber()));
                try {
                    CredentialResponse response = client.checkCredentialAuthorization(accessAuditObject, certInfo, companyOid, computerSerialNumber, accessAuditObject.getDateRequestPermission());
                    log.info((Object)"respuesta recibida del servicio de credenciales");
                    boolean handleSMS = true;
                    return this.handleResponse(client, accessAuditObject, certInfo, response, handleSMS);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                    throw new CertificateCredentialException(e.getMessage());
                }
            }
            catch (Throwable e) {
                this.handleErrorMessage(e);
                throw e;
            }
        }
        return true;
    }

    @Override
    public void checkCode(String code, X509Certificate cert) {
        CertificateInfo certInfo = this.getCertInfo(cert);
        String serialNumber = certInfo.getSerialCert();
        this.checkCode(code, serialNumber);
    }

    @Override
    public void checkCode(String code, String serialNumber) {
        CredentialResponse resp = this.createClientCredentials().checkCode(Integer.valueOf(code).intValue(), serialNumber);
        if (resp.isSucceded()) {
            if (resp.getResult().getCause().name().equals("OUT_OF_CHECKING_TIME")) {
                throw new CertificateCredentialException(resp.getResult().getCause().name());
            }
            if (resp.getResult().getValue().equals("KO")) {
                throw new CertificateCredentialException("ERR_WRONG_CODE");
            }
        } else {
            throw new CertificateCredentialException("ERR_CREDENTIAL_RESPONSE_FAILED", (Throwable)new Exception(resp.getResult().getCause() + ":" + resp.getResult().getType() + ":" + resp.getResult().getServerError().name()));
        }
        log.info((Object)("CODE SMS OK " + serialNumber));
    }

    @Override
    public void useOtp(X509Certificate cert, String otp) {
        BasicResponse resp = null;
        try {
            resp = this.createClientCredentials().useOtp(cert, otp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!resp.isSuccess()) {
            throw new RuntimeException(resp.getError());
        }
    }

    private CertificateInfo getCertInfo(X509Certificate cert) {
        DatosPersonales dp = new DatosPersonales(cert.getSubjectX500Principal());
        TypeCertificate certType = OIDUtils.isPF((X509Certificate)cert) ? TypeCertificate.PF : (OIDUtils.isRLPJ((X509Certificate)cert) ? TypeCertificate.RLPJ : TypeCertificate.PF);
        String username = dp.getGIVENNAME().trim();
        String fullName = (dp.getGIVENNAME() + " " + dp.getSURNAME()).trim();
        CertificateInfo certInfo = new CertificateInfo(cert.getSerialNumber().toString(), cert.getNotBefore(), cert.getNotAfter(), fullName, username, certType, dp.getEMAILADDRESS());
        return certInfo;
    }

    private AccessAuditObject getAccessAuditObject(URLAuthInfo url) {
        Date date = new Date();
        String urlStr = url.getUrl() == null ? "http://localhost" : url.getUrl().toString();
        AccessAuditObject accessAuditObject = new AccessAuditObject(urlStr, url.getVersion(), url.getIp(), url.getAppName(), date);
        return accessAuditObject;
    }

    private IClient createClientCredentials() {
        FactoryClient factoryClient = new FactoryClient();
        return factoryClient.getClient(this.url, this.timeout);
    }

    private void handleErrorMessage(Throwable error) {
        String message = error.getMessage();
        if (message != null && !message.equals("NO_ERROR")) {
            Object info = Confis.get().getString(message, new Object[0]);
            if (info == null || ((String)info).isEmpty()) {
                info = "ERROR:" + message;
            }
            if (error.getCause() != null) {
                info = (String)info + ": " + error.getCause().getMessage();
            }
            this.credentialsHandler.onError(error, (String)info);
            log.error((Object)error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleResponse(IClient client, AccessAuditObject accessAuditObject, CertificateInfo certInfo, CredentialResponse response, boolean handleSMS) {
        boolean success = false;
        if (!response.isFailed()) {
            if (!response.isSucceded()) return success;
            log.info((Object)("credential response success: " + response.getResult().getValue() + ":" + response.getResult().getCause()));
            if (!response.getResult().getValue().equals("KO")) return true;
            if (!handleSMS) throw new CertificateCredentialException(response.getResult().getCause().name());
            if (!response.getResult().getCause().name().equals("NEED_SMS_DOBLE_FACTOR_AUTH")) throw new CertificateCredentialException(response.getResult().getCause().name());
            response = client.sendCodeSms(certInfo.getSerialCert());
            if (!response.isSucceded()) throw new CertificateCredentialException(response.getResult().getCause().name());
            if (!response.getResult().getValue().equals("OK")) throw new CertificateCredentialException(response.getResult().getCause().name());
            this.credentialsHandler.onSmsConfirmationSent(client, certInfo);
            return true;
        }
        log.info((Object)"credential response failed");
        this.credentialsHandler.onFailedResponse(response);
        return success;
    }

    @Override
    public void sendAuthURL(X509Certificate cert) {
        if (this.urlAuthInfo.isUsable()) {
            if (cert == null) {
                throw new NullPointerException("certificado es nulo");
            }
            try {
                this.sendURLCrendentials(cert);
            }
            catch (Exception e) {
                log.info((Object)e);
                throw new CertificateCredentialException("ERR_CREDENTIALS_CERT_AUTH:" + e.getMessage(), (Throwable)e);
            }
        } else {
            log.info((Object)("NO hay datos de URLInfo para credenciales:" + this.urlAuthInfo.toString()));
        }
    }

    public CredentialsHandler getCredentialsHandler() {
        return this.credentialsHandler;
    }

    @Override
    public void setCredentialsHandler(CredentialsHandler credentialsHandler) {
        this.credentialsHandler = credentialsHandler;
    }

    @Override
    public void setComputerSerialNumber(String computerSerialNumber) {
        this.computerSerialNumber = computerSerialNumber;
    }
}

