/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.config;

import com.anf.cryptotoken.config.AtrObject;
import com.anf.cryptotoken.config.Device;
import com.anf.cryptotoken.config.DvcType;
import com.anf.cryptotoken.config.LANG;
import com.anf.cryptotoken.log.Logger;
import com.anf.oauth.json.JSONFactory;
import com.anf.timestamp.model.URLTSU;
import com.anf.timestamp.services.TSUController;
import com.anf.utils.VersionControl;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.util.encoders.Hex;

public class Confis {
    private static final Logger log = Logger.getLogger(Confis.class);
    private static Confis instance;
    boolean encrypted = false;
    private LANG lang = LANG.ES;
    private ResourceBundle bundle;
    private TSUController control;
    private String tsuKey;
    private List<Device> devices;
    private List<AtrObject> atrs;

    public static Confis get() {
        if (instance == null) {
            instance = new Confis();
        }
        return instance;
    }

    public Confis() {
        byte[] content;
        this.loadTexts(this.lang.toLocale());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String basePackage = "com/anf/cryptotoken/config/";
        log.info((Object)"loading devices...");
        try {
            content = IOUtils.toByteArray((InputStream)loader.getResourceAsStream(basePackage + "devices.json"));
            log.info((Object)(this + " config devices:\n" + new String(content)));
            this.devices = (List)JSONFactory.getMapper().readValue(content, (TypeReference)new TypeReference<ArrayList<Device>>(){});
            log.info((Object)(this + " config devices loaded:\n" + JSONFactory.buildJSON(this.devices)));
        }
        catch (Exception e) {
            log.info((Object)("error cargando los dispositivos: " + ExceptionUtils.getStackTrace((Throwable)e)));
            log.error((Object)"no se pudo cargar los dispositivos de config", (Throwable)e);
        }
        log.info((Object)(this + " config devices after load:\n" + JSONFactory.buildJSON(this.devices)));
        try {
            content = IOUtils.toByteArray((InputStream)loader.getResourceAsStream(basePackage + "atr-list.json"));
            this.atrs = (List)JSONFactory.getMapper().readValue(content, (TypeReference)new TypeReference<ArrayList<AtrObject>>(){});
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public List<AtrObject> getAtrs() {
        return this.atrs;
    }

    public AtrObject getAtrObject(byte[] atr) {
        log.info((Object)("get ATR info: " + new String(Hex.encode((byte[])atr))));
        for (AtrObject a : this.atrs) {
            if (!a.compare(atr)) continue;
            return a;
        }
        return null;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public Device getDevice(DvcType type) {
        if (this.devices != null && !this.devices.isEmpty()) {
            log.info((Object)(this + " devices:\n" + JSONFactory.buildJSON(this.devices)));
            for (Device device : this.devices) {
                log.info((Object)("checking device " + device + " vs " + type));
                if (!device.getType().equals(type.name())) continue;
                return device;
            }
        }
        return null;
    }

    public LANG getLang() {
        return this.lang;
    }

    public void setLang(LANG lang) {
        this.lang = lang;
        this.loadTexts(lang.toLocale());
    }

    private void loadTexts(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        log.info((Object)("cargando textos del idioma " + locale));
        this.bundle = ResourceBundle.getBundle("com.anf.cryptotoken.config.text", locale, Thread.currentThread().getContextClassLoader());
    }

    public String getString(String id, Object ... args) {
        String text = this.getBundleValue(id);
        if (text == null) {
            text = this.getBundleValue(id.toLowerCase());
        }
        if (text == null) {
            text = this.getBundleValue(id.toUpperCase());
        }
        if (text != null) {
            text = text.replace("\\n", "\n");
            try {
                if (args != null && args.length > 0) {
                    return String.format(text, args);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else {
            log.warn((Object)("no text for key: " + id));
        }
        return text;
    }

    private String getBundleValue(String id) {
        try {
            return this.bundle.getString(id);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public TSUController getTSUControl() {
        if (this.control == null) {
            String tsuURL = System.getenv("tsu.url");
            if (tsuURL == null) {
                tsuURL = "https://tsu.anf.es/TimeStampServer/TimeServer";
            }
            URLTSU urlConfig = new URLTSU(tsuURL, null, this.getTsuKey());
            this.control = new TSUController(new URLTSU[]{urlConfig});
        }
        return this.control;
    }

    public void setTsuKey(String tsuKey) {
        this.tsuKey = tsuKey;
    }

    public String getTsuKey() {
        if (this.tsuKey == null) {
            this.tsuKey = System.getProperty("anf.tsu.key", "ANFCT-" + VersionControl.version);
        }
        return this.tsuKey;
    }
}

