/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.clients;

import com.anf.cryptotoken.filecert.FileCertUtils;
import com.anf.cryptotoken.json.TSLCertificateValidation;
import com.anf.cryptotoken.json.TSLCertificateValidationRequest;
import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.json.JSONFactory;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;

public class TSLValidationCertClient
extends AbstractClient {
    private static final Logger log = LogManager.getLogger(TSLValidationCertClient.class);

    public static void main(String[] args) throws Exception {
        X509Certificate[] chain = null;
        chain = FileCertUtils.getCertificatesP7B(new File("C:\\Users\\Aramis ANF AC\\Downloads\\2024", "tsu-sl.p7b"));
        String url = "http://localhost:8081";
        url = "https://validaciones.anf.es";
        TSLValidationCertClient client = new TSLValidationCertClient(url, 500000);
        TSLCertificateValidation validation = client.validateSignCertificateChain(chain);
        if (log.isInfoEnabled()) {
            log.info(JSONFactory.buildJSON((Object)validation));
        }
    }

    public TSLValidationCertClient(String url, int timeout) {
        super(url, (long)timeout);
    }

    public TSLCertificateValidation validateSignCertificateChain(X509Certificate[] chain) throws IOException, CertificateEncodingException {
        ArrayList<String> certChain = new ArrayList<String>();
        for (int i = 0; i < chain.length; ++i) {
            certChain.add(new String(Hex.encode((byte[])chain[i].getEncoded())));
        }
        TSLCertificateValidationRequest request = new TSLCertificateValidationRequest(certChain, new Date());
        return (TSLCertificateValidation)this.handleJsonRequest("/validate/tsl/cert", request, TSLCertificateValidation.class).get();
    }
}

